/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.directory.mavibot.btree.BTree;
import org.apache.directory.mavibot.btree.BtreeInfo;
import org.apache.directory.mavibot.btree.PageIO;
import org.apache.directory.mavibot.btree.PersistedBTree;
import org.apache.directory.mavibot.btree.RecordManager;
import org.apache.directory.mavibot.btree.exception.InvalidBTreeException;
import org.apache.directory.mavibot.btree.serializer.ElementSerializer;
import org.apache.directory.mavibot.btree.serializer.LongSerializer;
import org.apache.directory.mavibot.btree.serializer.StringSerializer;
import org.apache.directory.mavibot.btree.util.Strings;

public class MavibotInspector {
    private File dbFile;
    private RecordManager rm;
    private BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
    private static final String GLOBAL_PAGES_NAME = "__global__";
    private static final String FREE_PAGES_NAME = "__free-pages__";
    private static Set<String> knownPagesArrays = new HashSet<String>();

    public MavibotInspector(File dbFile) {
        this.dbFile = dbFile;
    }

    private boolean checkFilePresence() {
        if (this.dbFile == null) {
            System.out.println("No mavibot database file was given");
            return false;
        }
        if (!this.dbFile.exists()) {
            System.out.println("Given mavibot database file " + this.dbFile + " doesn't exist");
            return false;
        }
        return true;
    }

    public void printFileSize() throws IOException {
        FileChannel fileChannel = new RandomAccessFile(this.dbFile, "r").getChannel();
        long l = fileChannel.size();
        fileChannel.close();
        String msg = l < 1024L ? l + " bytes" : l / 1024L + " KB";
        System.out.println(msg);
        fileChannel.close();
    }

    public void printNumberOfBTrees() {
        int nbBtrees = 0;
        if (this.rm != null) {
            nbBtrees = this.rm.getNbManagedTrees();
        }
        System.out.println("Total Number of BTrees: " + nbBtrees);
    }

    public void printBTreeNames() {
        if (this.rm == null) {
            System.out.println("Couldn't find the number of managed btrees");
            return;
        }
        Set<String> trees = this.rm.getManagedTrees();
        System.out.println("\nManaged BTrees:");
        for (String tree : trees) {
            System.out.println(tree);
        }
        System.out.println();
    }

    public void checkBTree() {
        if (this.rm == null) {
            System.out.println("Cannot check BTree(s)");
            return;
        }
        System.out.print("BTree Name: ");
        String name = this.readLine();
        PersistedBTree pb = (PersistedBTree)this.rm.getManagedTree(name);
        if (pb == null) {
            System.out.println("No BTree exists with the name '" + name + "'");
            return;
        }
        System.out.println("\nBTree offset: " + String.format("0x%1$08x", pb.getBtreeOffset()));
        System.out.println("BTree _info_ offset: " + String.format("0x%1$08x", pb.getBtreeInfoOffset()));
        System.out.println("BTree root page offset: " + String.format("0x%1$08x", pb.getRootPageOffset()));
        System.out.println("Number of elements present: " + pb.getNbElems());
        System.out.println("BTree Page size: " + pb.getPageSize());
        System.out.println("BTree revision: " + pb.getRevision());
        System.out.println("Key serializer: " + pb.getKeySerializerFQCN());
        System.out.println("Value serializer: " + pb.getValueSerializerFQCN());
        System.out.println();
    }

    private boolean loadRm() {
        try {
            if (this.rm != null) {
                System.out.println("Closing record manager");
                this.rm.close();
            }
            this.rm = new RecordManager(this.dbFile.getAbsolutePath());
            System.out.println("Loaded record manager");
        }
        catch (Exception e) {
            System.out.println("Given database file seems to be corrupted. " + e.getMessage());
            return false;
        }
        return true;
    }

    static void check(RecordManager recordManager) {
        try {
            ByteBuffer recordManagerHeader = ByteBuffer.allocate(RecordManager.RECORD_MANAGER_HEADER_SIZE);
            long fileSize = recordManager.fileChannel.size();
            if (fileSize < (long)RecordManager.RECORD_MANAGER_HEADER_SIZE) {
                throw new InvalidBTreeException("File size too small : " + fileSize);
            }
            recordManager.fileChannel.read(recordManagerHeader, 0L);
            recordManagerHeader.flip();
            int pageSize = recordManagerHeader.getInt();
            if (pageSize != recordManager.pageSize || pageSize < 32 || (pageSize & ~pageSize + 1) != pageSize) {
                throw new InvalidBTreeException("Wrong page size : " + pageSize);
            }
            long nbPages = (fileSize - (long)RecordManager.RECORD_MANAGER_HEADER_SIZE) / (long)pageSize;
            int nbBtrees = recordManagerHeader.getInt();
            if (nbBtrees < 0 || nbBtrees != recordManager.nbBtree) {
                throw new InvalidBTreeException("Wrong nb trees : " + nbBtrees);
            }
            long firstFreePage = recordManagerHeader.getLong();
            if (firstFreePage != -1L) {
                MavibotInspector.checkOffset(recordManager, firstFreePage);
            }
            int nbPageBits = (int)(nbPages / 32L);
            HashMap<String, int[]> checkedPages = new HashMap<String, int[]>(nbBtrees + 4);
            checkedPages.put(GLOBAL_PAGES_NAME, new int[nbPageBits + 1]);
            checkedPages.put(FREE_PAGES_NAME, new int[nbPageBits + 1]);
            checkedPages.put("_btree_of_btrees_", new int[nbPageBits + 1]);
            checkedPages.put("_copiedPageBtree_", new int[nbPageBits + 1]);
            MavibotInspector.checkFreePages(recordManager, checkedPages);
            long currentBtreeOfBtreesOffset = recordManagerHeader.getLong();
            long previousBtreeOfBtreesOffset = recordManagerHeader.getLong();
            long currentCopiedPagesBtreeOffset = recordManagerHeader.getLong();
            long previousCopiedPagesBtreeOffset = recordManagerHeader.getLong();
            if (previousBtreeOfBtreesOffset != -1L) {
                System.out.println("The previous Btree of Btrees offset is not valid : " + previousBtreeOfBtreesOffset);
                return;
            }
            if (previousCopiedPagesBtreeOffset != -1L) {
                System.out.println("The previous Copied Pages Btree offset is not valid : " + previousCopiedPagesBtreeOffset);
                return;
            }
            MavibotInspector.checkOffset(recordManager, currentBtreeOfBtreesOffset);
            MavibotInspector.checkOffset(recordManager, currentCopiedPagesBtreeOffset);
            MavibotInspector.checkBtreeOfBtrees(recordManager, checkedPages);
            MavibotInspector.checkBtree(recordManager, currentCopiedPagesBtreeOffset, checkedPages);
            MavibotInspector.dumpCheckedPages(recordManager, checkedPages);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InvalidBTreeException("Error : " + e.getMessage());
        }
    }

    private static <K, V> void checkBtreeOfBtrees(RecordManager recordManager, Map<String, int[]> checkedPages) throws Exception {
        PageIO[] bobHeaderPageIos = recordManager.readPageIOs(recordManager.currentBtreeOfBtreesOffset, Long.MAX_VALUE);
        MavibotInspector.updateCheckedPages(checkedPages.get("_btree_of_btrees_"), recordManager.pageSize, bobHeaderPageIos);
        MavibotInspector.updateCheckedPages(checkedPages.get(GLOBAL_PAGES_NAME), recordManager.pageSize, bobHeaderPageIos);
        long dataPos = 0L;
        recordManager.readLong(bobHeaderPageIos, dataPos);
        recordManager.readLong(bobHeaderPageIos, dataPos += 8L);
        long rootPageOffset = recordManager.readLong(bobHeaderPageIos, dataPos += 8L);
        MavibotInspector.checkOffset(recordManager, rootPageOffset);
        long btreeInfoOffset = recordManager.readLong(bobHeaderPageIos, dataPos += 8L);
        MavibotInspector.checkOffset(recordManager, btreeInfoOffset);
        MavibotInspector.checkBtreeInfo(recordManager, checkedPages, btreeInfoOffset, -1L);
        MavibotInspector.checkBtreeOfBtreesPage(recordManager, checkedPages, rootPageOffset);
    }

    private static <K, V> void checkBtree(RecordManager recordManager, long btreeOffset, Map<String, int[]> checkedPages) throws Exception {
        PageIO[] btreeHeaderPageIos = recordManager.readPageIOs(btreeOffset, Long.MAX_VALUE);
        long dataPos = 0L;
        long btreeRevision = recordManager.readLong(btreeHeaderPageIos, dataPos);
        recordManager.readLong(btreeHeaderPageIos, dataPos += 8L);
        long rootPageOffset = recordManager.readLong(btreeHeaderPageIos, dataPos += 8L);
        MavibotInspector.checkOffset(recordManager, rootPageOffset);
        long btreeInfoOffset = recordManager.readLong(btreeHeaderPageIos, dataPos += 8L);
        MavibotInspector.checkOffset(recordManager, btreeInfoOffset);
        BtreeInfo<K, V> btreeInfo = MavibotInspector.checkBtreeInfo(recordManager, checkedPages, btreeInfoOffset, btreeRevision);
        MavibotInspector.updateCheckedPages(checkedPages.get(btreeInfo.btreeName), recordManager.pageSize, btreeHeaderPageIos);
        MavibotInspector.updateCheckedPages(checkedPages.get(GLOBAL_PAGES_NAME), recordManager.pageSize, btreeHeaderPageIos);
        MavibotInspector.checkBtreePage(recordManager, btreeInfo, checkedPages, rootPageOffset);
    }

    private static <K, V> void checkBtreePage(RecordManager recordManager, BtreeInfo<K, V> btreeInfo, Map<String, int[]> checkedPages, long pageOffset) throws Exception {
        PageIO[] pageIos = recordManager.readPageIOs(pageOffset, Long.MAX_VALUE);
        MavibotInspector.updateCheckedPages(checkedPages.get(btreeInfo.btreeName), recordManager.pageSize, pageIos);
        MavibotInspector.updateCheckedPages(checkedPages.get(GLOBAL_PAGES_NAME), recordManager.pageSize, pageIos);
        long position = 0L;
        long revision = recordManager.readLong(pageIos, position);
        int nbElems = recordManager.readInt(pageIos, position += 8L);
        ByteBuffer byteBuffer = recordManager.readBytes(pageIos, position += 4L);
        if (nbElems >= 0) {
            MavibotInspector.checkBtreeLeaf(recordManager, btreeInfo, checkedPages, nbElems, revision, byteBuffer, pageIos);
        } else {
            long[] children = MavibotInspector.checkBtreeNode(recordManager, btreeInfo, checkedPages, -nbElems, revision, byteBuffer, pageIos);
            for (int pos = 0; pos <= -nbElems; ++pos) {
                MavibotInspector.checkBtreePage(recordManager, btreeInfo, checkedPages, children[pos]);
            }
        }
    }

    private static <K, V> BtreeInfo<K, V> checkBtreeInfo(RecordManager recordManager, Map<String, int[]> checkedPages, long btreeInfoOffset, long btreeRevision) throws IOException {
        ByteBuffer valueSerializerBytes;
        BtreeInfo btreeInfo = new BtreeInfo();
        PageIO[] btreeInfoPagesIos = recordManager.readPageIOs(btreeInfoOffset, Long.MAX_VALUE);
        long dataPos = 0L;
        recordManager.readInt(btreeInfoPagesIos, dataPos);
        ByteBuffer btreeNameBytes = recordManager.readBytes(btreeInfoPagesIos, dataPos += 4L);
        String btreeName = Strings.utf8ToString(btreeNameBytes);
        ByteBuffer keySerializerBytes = recordManager.readBytes(btreeInfoPagesIos, dataPos += (long)(4 + btreeNameBytes.limit()));
        if (keySerializerBytes != null) {
            String keySerializerFqcn = Strings.utf8ToString(keySerializerBytes);
            btreeInfo.keySerializer = MavibotInspector.getSerializer(keySerializerFqcn);
        }
        if ((valueSerializerBytes = recordManager.readBytes(btreeInfoPagesIos, dataPos += (long)(4 + keySerializerBytes.limit()))) != null) {
            String valueSerializerFqcn = Strings.utf8ToString(valueSerializerBytes);
            btreeInfo.valueSerializer = MavibotInspector.getSerializer(valueSerializerFqcn);
        }
        recordManager.readInt(btreeInfoPagesIos, dataPos += (long)(4 + valueSerializerBytes.limit()));
        dataPos += 4L;
        if (!"_copiedPageBtree_".equals(btreeName) && !"_btree_of_btrees_".equals(btreeName)) {
            btreeName = btreeName + "<" + btreeRevision + ">";
        }
        btreeInfo.btreeName = btreeName;
        int[] checkedPagesArray = checkedPages.get(btreeName);
        if (checkedPagesArray == null) {
            checkedPagesArray = MavibotInspector.createPageArray(recordManager);
            checkedPages.put(btreeName, checkedPagesArray);
        }
        MavibotInspector.updateCheckedPages(checkedPagesArray, recordManager.pageSize, btreeInfoPagesIos);
        MavibotInspector.updateCheckedPages(checkedPages.get(GLOBAL_PAGES_NAME), recordManager.pageSize, btreeInfoPagesIos);
        return btreeInfo;
    }

    private static <T> ElementSerializer<T> getSerializer(String serializerFqcn) {
        try {
            Class<?> serializerClass = Class.forName(serializerFqcn);
            ElementSerializer serializer = null;
            try {
                serializer = (ElementSerializer)serializerClass.getDeclaredField("INSTANCE").get(null);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            if (serializer == null) {
                serializer = (ElementSerializer)serializerClass.newInstance();
            }
            return serializer;
        }
        catch (Exception e) {
            throw new InvalidBTreeException("Error : " + e.getMessage());
        }
    }

    private static <K, V> void checkBtreeOfBtreesPage(RecordManager recordManager, Map<String, int[]> checkedPages, long pageOffset) throws Exception {
        PageIO[] pageIos = recordManager.readPageIOs(pageOffset, Long.MAX_VALUE);
        MavibotInspector.updateCheckedPages(checkedPages.get("_btree_of_btrees_"), recordManager.pageSize, pageIos);
        MavibotInspector.updateCheckedPages(checkedPages.get(GLOBAL_PAGES_NAME), recordManager.pageSize, pageIos);
        long position = 0L;
        long revision = recordManager.readLong(pageIos, position);
        int nbElems = recordManager.readInt(pageIos, position += 8L);
        ByteBuffer byteBuffer = recordManager.readBytes(pageIos, position += 4L);
        if (nbElems >= 0) {
            MavibotInspector.checkBtreeOfBtreesLeaf(recordManager, checkedPages, nbElems, revision, byteBuffer, pageIos);
        } else {
            long[] children = MavibotInspector.checkBtreeOfBtreesNode(recordManager, checkedPages, -nbElems, revision, byteBuffer, pageIos);
            for (int pos = 0; pos <= -nbElems; ++pos) {
                MavibotInspector.checkBtreeOfBtreesPage(recordManager, checkedPages, children[pos]);
            }
        }
    }

    private static <K, V> void checkBtreeOfBtreesLeaf(RecordManager recordManager, Map<String, int[]> checkedPages, int nbElems, long revision, ByteBuffer byteBuffer, PageIO[] pageIos) throws Exception {
        for (int i = 0; i < nbElems; ++i) {
            try {
                int nbValues = byteBuffer.getInt();
                if (nbValues != 1) {
                    throw new InvalidBTreeException("We should have only one value for a BOB " + nbValues);
                }
                int valueLength = byteBuffer.getInt();
                if (valueLength != 12) {
                    throw new InvalidBTreeException("The BOB value length is invalid " + valueLength);
                }
                int offsetLength = byteBuffer.getInt();
                if (offsetLength != 8) {
                    throw new InvalidBTreeException("The BOB value offset length is invalid " + offsetLength);
                }
                long btreeOffset = byteBuffer.getLong();
                MavibotInspector.checkOffset(recordManager, btreeOffset);
                int keyLength = byteBuffer.getInt();
                if (keyLength < 12) {
                    throw new InvalidBTreeException("The BOB key length is invalid " + keyLength);
                }
                long btreeRevision = byteBuffer.getLong();
                int btreeNameLength = byteBuffer.getInt();
                if (keyLength != 12 + btreeNameLength) {
                    throw new InvalidBTreeException("The BOB key length is not the expected value " + (12 + btreeNameLength) + ", expected " + keyLength);
                }
                byte[] bytes = new byte[btreeNameLength];
                byteBuffer.get(bytes);
                String btreeName = Strings.utf8ToString(bytes);
                int[] btreePagesArray = MavibotInspector.createPageArray(recordManager);
                checkedPages.put(btreeName + "<" + btreeRevision + ">", btreePagesArray);
                MavibotInspector.checkBtree(recordManager, btreeOffset, checkedPages);
                continue;
            }
            catch (BufferUnderflowException bue) {
                throw new InvalidBTreeException("The BOB leaf byte buffer is too short : " + bue.getMessage());
            }
        }
    }

    private static <K, V> void checkBtreeLeaf(RecordManager recordManager, BtreeInfo<K, V> btreeInfo, Map<String, int[]> checkedPages, int nbElems, long revision, ByteBuffer byteBuffer, PageIO[] pageIos) throws Exception {
        for (int i = 0; i < nbElems; ++i) {
            try {
                int nbValues = byteBuffer.getInt();
                if (nbValues < 0) {
                    long subBtreeOffset = byteBuffer.getLong();
                    MavibotInspector.checkBtree(recordManager, subBtreeOffset, checkedPages);
                    byteBuffer.getInt();
                    btreeInfo.keySerializer.deserialize(byteBuffer);
                    continue;
                }
                byteBuffer.getInt();
                btreeInfo.valueSerializer.deserialize(byteBuffer);
                byteBuffer.getInt();
                btreeInfo.keySerializer.deserialize(byteBuffer);
                continue;
            }
            catch (BufferUnderflowException bue) {
                throw new InvalidBTreeException("The BOB leaf byte buffer is too short : " + bue.getMessage());
            }
        }
    }

    private static <K, V> long[] checkBtreeOfBtreesNode(RecordManager recordManager, Map<String, int[]> checkedPages, int nbElems, long revision, ByteBuffer byteBuffer, PageIO[] pageIos) throws IOException {
        long[] children = new long[nbElems + 1];
        for (int i = 0; i < nbElems; ++i) {
            long firstOffset = LongSerializer.INSTANCE.deserialize(byteBuffer);
            MavibotInspector.checkOffset(recordManager, firstOffset);
            long lastOffset = LongSerializer.INSTANCE.deserialize(byteBuffer);
            MavibotInspector.checkOffset(recordManager, lastOffset);
            children[i] = firstOffset;
            int keyLength = byteBuffer.getInt();
            if (keyLength < 12) {
                throw new InvalidBTreeException("The BOB key length is invalid " + keyLength);
            }
            byteBuffer.getLong();
            int btreeNameLength = byteBuffer.getInt();
            if (keyLength != 12 + btreeNameLength) {
                throw new InvalidBTreeException("The BOB key length is not the expected value " + (12 + btreeNameLength) + ", expected " + keyLength);
            }
            byte[] bytes = new byte[btreeNameLength];
            byteBuffer.get(bytes);
        }
        long firstOffset = LongSerializer.INSTANCE.deserialize(byteBuffer);
        MavibotInspector.checkOffset(recordManager, firstOffset);
        long lastOffset = LongSerializer.INSTANCE.deserialize(byteBuffer);
        MavibotInspector.checkOffset(recordManager, lastOffset);
        children[nbElems] = firstOffset;
        return children;
    }

    private static <K, V> long[] checkBtreeNode(RecordManager recordManager, BtreeInfo<K, V> btreeInfo, Map<String, int[]> checkedPages, int nbElems, long revision, ByteBuffer byteBuffer, PageIO[] pageIos) throws Exception {
        long[] children = new long[nbElems + 1];
        for (int i = 0; i < nbElems; ++i) {
            try {
                long firstOffset = LongSerializer.INSTANCE.deserialize(byteBuffer);
                MavibotInspector.checkOffset(recordManager, firstOffset);
                long lastOffset = LongSerializer.INSTANCE.deserialize(byteBuffer);
                MavibotInspector.checkOffset(recordManager, lastOffset);
                children[i] = firstOffset;
                byteBuffer.getInt();
                btreeInfo.keySerializer.deserialize(byteBuffer);
                continue;
            }
            catch (BufferUnderflowException bue) {
                throw new InvalidBTreeException("The BOB leaf byte buffer is too short : " + bue.getMessage());
            }
        }
        long firstOffset = LongSerializer.INSTANCE.deserialize(byteBuffer);
        MavibotInspector.checkOffset(recordManager, firstOffset);
        long lastOffset = LongSerializer.INSTANCE.deserialize(byteBuffer);
        MavibotInspector.checkOffset(recordManager, lastOffset);
        children[nbElems] = firstOffset;
        return children;
    }

    private static int[] createPageArray(RecordManager recordManager) throws IOException {
        long fileSize = recordManager.fileChannel.size();
        int pageSize = recordManager.pageSize;
        long nbPages = (fileSize - (long)RecordManager.RECORD_MANAGER_HEADER_SIZE) / (long)pageSize;
        int nbPageBits = (int)(nbPages / 32L);
        return new int[nbPageBits + 1];
    }

    private static void updateCheckedPages(int[] checkedPages, int pageSize, PageIO ... pageIos) {
        for (PageIO pageIO : pageIos) {
            long offset = pageIO.getOffset();
            if (offset % (long)pageSize != 0L) {
                throw new InvalidBTreeException("Offset invalid : " + offset);
            }
            int pageNumber = (int)(offset / (long)pageSize);
            int nbBitsPage = 32;
            int pageMask = checkedPages[pageNumber / nbBitsPage];
            int mask = 1 << pageNumber % nbBitsPage;
            if ((pageMask & mask) != 0) {
                // empty if block
            }
            checkedPages[pageNumber / nbBitsPage] = pageMask |= mask;
        }
    }

    private static void checkOffset(RecordManager recordManager, long offset) throws IOException {
        if (offset == -1L || (offset - (long)RecordManager.RECORD_MANAGER_HEADER_SIZE) % (long)recordManager.pageSize != 0L || offset > recordManager.fileChannel.size()) {
            throw new InvalidBTreeException("Invalid Offset : " + offset);
        }
    }

    private static void checkFreePages(RecordManager recordManager, Map<String, int[]> checkedPages) throws IOException {
        if (recordManager.firstFreePage == -1L) {
            return;
        }
        long currentOffset = recordManager.firstFreePage;
        long fileSize = recordManager.fileChannel.size();
        while (currentOffset != -1L) {
            if (currentOffset > fileSize) {
                System.out.println("Wrong free page offset, above file size : " + currentOffset);
                return;
            }
            try {
                long newOffset;
                PageIO pageIo = recordManager.fetchPage(currentOffset);
                if (currentOffset != pageIo.getOffset()) {
                    System.out.println("PageIO offset is incorrect : " + currentOffset + "-" + pageIo.getOffset());
                    return;
                }
                MavibotInspector.setCheckedPage(recordManager, checkedPages.get(GLOBAL_PAGES_NAME), currentOffset);
                MavibotInspector.setCheckedPage(recordManager, checkedPages.get(FREE_PAGES_NAME), currentOffset);
                currentOffset = newOffset = pageIo.getNextPage();
            }
            catch (IOException ioe) {
                throw new InvalidBTreeException("Cannot fetch page at : " + currentOffset);
            }
        }
    }

    private static void setCheckedPage(RecordManager recordManager, int[] checkedPages, long offset) {
        int pageNumber = (int)offset / recordManager.pageSize;
        int nbBitsPage = 32;
        long pageMask = checkedPages[pageNumber / nbBitsPage];
        long mask = 1L << pageNumber % nbBitsPage;
        if ((pageMask & mask) != 0L) {
            // empty if block
        }
        int n = pageNumber / nbBitsPage;
        checkedPages[n] = (int)((long)checkedPages[n] | (pageMask |= mask));
    }

    private static void dumpCheckedPages(RecordManager recordManager, Map<String, int[]> checkedPages) throws IOException {
        int[] globalArray = checkedPages.get(GLOBAL_PAGES_NAME);
        String result = MavibotInspector.dumpPageArray(recordManager, globalArray);
        String dump = String.format("%1$-40s : %2$s", GLOBAL_PAGES_NAME, result);
        System.out.println(dump);
        int[] freePagesArray = checkedPages.get(FREE_PAGES_NAME);
        result = MavibotInspector.dumpPageArray(recordManager, freePagesArray);
        dump = String.format("%1$-40s : %2$s", FREE_PAGES_NAME, result);
        System.out.println(dump);
        int[] btreeOfBtreesArray = checkedPages.get("_btree_of_btrees_");
        result = MavibotInspector.dumpPageArray(recordManager, btreeOfBtreesArray);
        dump = String.format("%1$-40s : %2$s", "_btree_of_btrees_", result);
        System.out.println(dump);
        int[] copiedPagesArray = checkedPages.get("_copiedPageBtree_");
        result = MavibotInspector.dumpPageArray(recordManager, copiedPagesArray);
        dump = String.format("%1$-40s : %2$s", "_copiedPageBtree_", result);
        System.out.println(dump);
        for (String btreeName : checkedPages.keySet()) {
            if (knownPagesArrays.contains(btreeName)) continue;
            int[] btreePagesArray = checkedPages.get(btreeName);
            result = MavibotInspector.dumpPageArray(recordManager, btreePagesArray);
            dump = String.format("%1$-40s : %2$s", btreeName, result);
            System.out.println(dump);
        }
    }

    private static String dumpPageArray(RecordManager recordManager, int[] checkedPages) throws IOException {
        StringBuilder sb = new StringBuilder();
        int i = -1;
        int nbPagesChecked = 0;
        long fileSize = recordManager.fileChannel.size();
        long nbPages = (fileSize - (long)RecordManager.RECORD_MANAGER_HEADER_SIZE) / (long)recordManager.pageSize;
        for (int checkedPage : checkedPages) {
            if (i == 0) {
                sb.append(" ");
                ++i;
            } else {
                i = 0;
            }
            sb.append("[").append(i).append("] ");
            for (int j = 0; j < 32; ++j) {
                if ((long)nbPagesChecked >= nbPages + 1L) {
                    sb.append(".");
                } else if ((checkedPage & 1 << j) == 0) {
                    sb.append("0");
                } else {
                    sb.append("1");
                }
                ++nbPagesChecked;
            }
        }
        return sb.toString();
    }

    public void start() throws Exception {
        if (!this.checkFilePresence()) {
            return;
        }
        if (!this.loadRm()) {
            return;
        }
        boolean stop = false;
        block12: while (!stop) {
            System.out.println("Choose an option:");
            System.out.println("1. Print Number of BTrees");
            System.out.println("2. Print BTree Names");
            System.out.println("3. Inspect BTree");
            System.out.println("4. Check Free Pages");
            System.out.println("5. Get database file size");
            System.out.println("6. Dump RecordManager");
            System.out.println("7. Reload RecordManager");
            System.out.println("q. Quit");
            char c = this.readOption();
            switch (c) {
                case '1': {
                    this.printNumberOfBTrees();
                    continue block12;
                }
                case '2': {
                    this.printBTreeNames();
                    continue block12;
                }
                case '3': {
                    this.checkBTree();
                    continue block12;
                }
                case '4': {
                    long fileSize = this.rm.fileChannel.size();
                    long nbPages = fileSize / (long)this.rm.pageSize;
                    int nbPageBits = (int)(nbPages / 4L);
                    HashMap<String, int[]> checkedPages = new HashMap<String, int[]>(2);
                    checkedPages.put(GLOBAL_PAGES_NAME, new int[nbPageBits + 1]);
                    checkedPages.put(FREE_PAGES_NAME, new int[nbPageBits + 1]);
                    MavibotInspector.checkFreePages(this.rm, checkedPages);
                    continue block12;
                }
                case '5': {
                    this.printFileSize();
                    continue block12;
                }
                case '6': {
                    MavibotInspector.check(this.rm);
                    continue block12;
                }
                case '7': {
                    this.loadRm();
                    continue block12;
                }
                case 'q': {
                    stop = true;
                    continue block12;
                }
            }
            System.out.println("Invalid option");
        }
        try {
            this.rm.close();
            this.br.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String readLine() {
        try {
            return this.br.readLine().trim();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private char readOption() {
        try {
            String s = this.br.readLine();
            if (s.length() == 0) {
                return ' ';
            }
            return s.charAt(0);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) throws Exception {
        File f = new File("/tmp/mavibotispector.db");
        RecordManager rm = new RecordManager(f.getAbsolutePath());
        String name1 = "corpus";
        String name2 = "multiValues";
        if (!rm.getManagedTrees().contains(name2)) {
            rm.addBTree(name2, StringSerializer.INSTANCE, StringSerializer.INSTANCE, true);
        }
        BTree<String, String> btree2 = rm.getManagedTree(name2);
        for (int i = 0; i < 1; ++i) {
            for (int j = 0; j < 10; ++j) {
                btree2.insert(Integer.toString(i), Integer.toString(j));
            }
        }
        rm.close();
        MavibotInspector mi = new MavibotInspector(f);
        mi.start();
    }

    static {
        knownPagesArrays.add(GLOBAL_PAGES_NAME);
        knownPagesArrays.add(FREE_PAGES_NAME);
        knownPagesArrays.add("_btree_of_btrees_");
        knownPagesArrays.add("_copiedPageBtree_");
    }
}

