/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import org.apache.directory.api.ldap.model.csn.Csn;
import org.apache.directory.api.ldap.model.csn.InvalidCSNException;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsnSyntaxChecker
extends SyntaxChecker {
    private static final Logger LOG = LoggerFactory.getLogger(CsnSyntaxChecker.class);

    public CsnSyntaxChecker() {
        super("1.3.6.1.4.1.4203.666.11.2.1");
    }

    @Override
    public boolean isValidSyntax(Object value) {
        if (value == null) {
            LOG.debug("Syntax invalid for 'null'");
            return false;
        }
        if (!(value instanceof String)) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        String csnStr = (String)value;
        try {
            boolean result = Csn.isValid(csnStr);
            if (result) {
                LOG.debug("Syntax valid for '{}'", value);
            } else {
                LOG.debug("Syntax invalid for '{}'", value);
            }
            return result;
        }
        catch (InvalidCSNException icsne) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
    }
}

