/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.registries;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapProtocolErrorException;
import org.apache.directory.api.ldap.model.exception.LdapSchemaException;
import org.apache.directory.api.ldap.model.exception.LdapSchemaExceptionCodes;
import org.apache.directory.api.ldap.model.exception.LdapSchemaViolationException;
import org.apache.directory.api.ldap.model.exception.LdapUnwillingToPerformException;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.schema.AbstractSchemaObject;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.DitContentRule;
import org.apache.directory.api.ldap.model.schema.DitStructureRule;
import org.apache.directory.api.ldap.model.schema.LdapComparator;
import org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.directory.api.ldap.model.schema.LoadableSchemaObject;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.MatchingRuleUse;
import org.apache.directory.api.ldap.model.schema.MutableAttributeType;
import org.apache.directory.api.ldap.model.schema.MutableMatchingRule;
import org.apache.directory.api.ldap.model.schema.NameForm;
import org.apache.directory.api.ldap.model.schema.Normalizer;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.SchemaObject;
import org.apache.directory.api.ldap.model.schema.SchemaObjectWrapper;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.ldap.model.schema.registries.AttributeTypeRegistry;
import org.apache.directory.api.ldap.model.schema.registries.ComparatorRegistry;
import org.apache.directory.api.ldap.model.schema.registries.DefaultAttributeTypeRegistry;
import org.apache.directory.api.ldap.model.schema.registries.DefaultComparatorRegistry;
import org.apache.directory.api.ldap.model.schema.registries.DefaultDitContentRuleRegistry;
import org.apache.directory.api.ldap.model.schema.registries.DefaultDitStructureRuleRegistry;
import org.apache.directory.api.ldap.model.schema.registries.DefaultLdapSyntaxRegistry;
import org.apache.directory.api.ldap.model.schema.registries.DefaultMatchingRuleRegistry;
import org.apache.directory.api.ldap.model.schema.registries.DefaultMatchingRuleUseRegistry;
import org.apache.directory.api.ldap.model.schema.registries.DefaultNameFormRegistry;
import org.apache.directory.api.ldap.model.schema.registries.DefaultNormalizerRegistry;
import org.apache.directory.api.ldap.model.schema.registries.DefaultObjectClassRegistry;
import org.apache.directory.api.ldap.model.schema.registries.DefaultSyntaxCheckerRegistry;
import org.apache.directory.api.ldap.model.schema.registries.DitContentRuleRegistry;
import org.apache.directory.api.ldap.model.schema.registries.DitStructureRuleRegistry;
import org.apache.directory.api.ldap.model.schema.registries.LdapSyntaxRegistry;
import org.apache.directory.api.ldap.model.schema.registries.MatchingRuleRegistry;
import org.apache.directory.api.ldap.model.schema.registries.MatchingRuleUseRegistry;
import org.apache.directory.api.ldap.model.schema.registries.NameFormRegistry;
import org.apache.directory.api.ldap.model.schema.registries.NormalizerRegistry;
import org.apache.directory.api.ldap.model.schema.registries.ObjectClassRegistry;
import org.apache.directory.api.ldap.model.schema.registries.OidRegistry;
import org.apache.directory.api.ldap.model.schema.registries.Schema;
import org.apache.directory.api.ldap.model.schema.registries.SchemaLoaderListener;
import org.apache.directory.api.ldap.model.schema.registries.SyntaxCheckerRegistry;
import org.apache.directory.api.ldap.model.schema.registries.helper.AttributeTypeHelper;
import org.apache.directory.api.ldap.model.schema.registries.helper.DitContentRuleHelper;
import org.apache.directory.api.ldap.model.schema.registries.helper.DitStructureRuleHelper;
import org.apache.directory.api.ldap.model.schema.registries.helper.LdapSyntaxHelper;
import org.apache.directory.api.ldap.model.schema.registries.helper.MatchingRuleHelper;
import org.apache.directory.api.ldap.model.schema.registries.helper.MatchingRuleUseHelper;
import org.apache.directory.api.ldap.model.schema.registries.helper.NameFormHelper;
import org.apache.directory.api.ldap.model.schema.registries.helper.ObjectClassHelper;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Registries
implements SchemaLoaderListener,
Cloneable {
    private static final Logger LOG = LoggerFactory.getLogger(Registries.class);
    protected Map<String, Schema> loadedSchemas = new HashMap<String, Schema>();
    protected AttributeTypeRegistry attributeTypeRegistry;
    protected ObjectClassRegistry objectClassRegistry;
    protected ComparatorRegistry comparatorRegistry;
    protected DitContentRuleRegistry ditContentRuleRegistry;
    protected DitStructureRuleRegistry ditStructureRuleRegistry;
    protected MatchingRuleRegistry matchingRuleRegistry;
    protected MatchingRuleUseRegistry matchingRuleUseRegistry;
    protected NameFormRegistry nameFormRegistry;
    protected NormalizerRegistry normalizerRegistry;
    protected OidRegistry<SchemaObject> globalOidRegistry = new OidRegistry();
    protected SyntaxCheckerRegistry syntaxCheckerRegistry;
    protected LdapSyntaxRegistry ldapSyntaxRegistry;
    private Map<String, Set<SchemaObjectWrapper>> schemaObjects;
    private boolean isRelaxed = false;
    private boolean disabledAccepted = false;
    public static final boolean STRICT = false;
    public static final boolean RELAXED = true;
    protected Map<SchemaObjectWrapper, Set<SchemaObjectWrapper>> usedBy;
    protected Map<SchemaObjectWrapper, Set<SchemaObjectWrapper>> using;

    public Registries() {
        this.attributeTypeRegistry = new DefaultAttributeTypeRegistry();
        this.comparatorRegistry = new DefaultComparatorRegistry();
        this.ditContentRuleRegistry = new DefaultDitContentRuleRegistry();
        this.ditStructureRuleRegistry = new DefaultDitStructureRuleRegistry();
        this.ldapSyntaxRegistry = new DefaultLdapSyntaxRegistry();
        this.matchingRuleRegistry = new DefaultMatchingRuleRegistry();
        this.matchingRuleUseRegistry = new DefaultMatchingRuleUseRegistry();
        this.nameFormRegistry = new DefaultNameFormRegistry();
        this.normalizerRegistry = new DefaultNormalizerRegistry();
        this.objectClassRegistry = new DefaultObjectClassRegistry();
        this.syntaxCheckerRegistry = new DefaultSyntaxCheckerRegistry();
        this.schemaObjects = new HashMap<String, Set<SchemaObjectWrapper>>();
        this.usedBy = new HashMap<SchemaObjectWrapper, Set<SchemaObjectWrapper>>();
        this.using = new HashMap<SchemaObjectWrapper, Set<SchemaObjectWrapper>>();
    }

    public AttributeTypeRegistry getAttributeTypeRegistry() {
        return this.attributeTypeRegistry;
    }

    public ComparatorRegistry getComparatorRegistry() {
        return this.comparatorRegistry;
    }

    public DitContentRuleRegistry getDitContentRuleRegistry() {
        return this.ditContentRuleRegistry;
    }

    public DitStructureRuleRegistry getDitStructureRuleRegistry() {
        return this.ditStructureRuleRegistry;
    }

    public MatchingRuleRegistry getMatchingRuleRegistry() {
        return this.matchingRuleRegistry;
    }

    public MatchingRuleUseRegistry getMatchingRuleUseRegistry() {
        return this.matchingRuleUseRegistry;
    }

    public NameFormRegistry getNameFormRegistry() {
        return this.nameFormRegistry;
    }

    public NormalizerRegistry getNormalizerRegistry() {
        return this.normalizerRegistry;
    }

    public ObjectClassRegistry getObjectClassRegistry() {
        return this.objectClassRegistry;
    }

    public OidRegistry<SchemaObject> getGlobalOidRegistry() {
        return this.globalOidRegistry;
    }

    public SyntaxCheckerRegistry getSyntaxCheckerRegistry() {
        return this.syntaxCheckerRegistry;
    }

    public LdapSyntaxRegistry getLdapSyntaxRegistry() {
        return this.ldapSyntaxRegistry;
    }

    public String getOid(String name) {
        try {
            AttributeType attributeType = (AttributeType)this.attributeTypeRegistry.lookup(name);
            if (attributeType != null) {
                return attributeType.getOid();
            }
        }
        catch (LdapException ne) {
            // empty catch block
        }
        try {
            ObjectClass objectClass = (ObjectClass)this.objectClassRegistry.lookup(name);
            if (objectClass != null) {
                return objectClass.getOid();
            }
        }
        catch (LdapException ne) {
            // empty catch block
        }
        try {
            LdapSyntax ldapSyntax = (LdapSyntax)this.ldapSyntaxRegistry.lookup(name);
            if (ldapSyntax != null) {
                return ldapSyntax.getOid();
            }
        }
        catch (LdapException ne) {
            // empty catch block
        }
        try {
            MatchingRule matchingRule = (MatchingRule)this.matchingRuleRegistry.lookup(name);
            if (matchingRule != null) {
                return matchingRule.getOid();
            }
        }
        catch (LdapException ne) {
            // empty catch block
        }
        try {
            MatchingRuleUse matchingRuleUse = (MatchingRuleUse)this.matchingRuleUseRegistry.lookup(name);
            if (matchingRuleUse != null) {
                return matchingRuleUse.getOid();
            }
        }
        catch (LdapException ne) {
            // empty catch block
        }
        try {
            NameForm nameForm = (NameForm)this.nameFormRegistry.lookup(name);
            if (nameForm != null) {
                return nameForm.getOid();
            }
        }
        catch (LdapException ne) {
            // empty catch block
        }
        try {
            DitContentRule ditContentRule = (DitContentRule)this.ditContentRuleRegistry.lookup(name);
            if (ditContentRule != null) {
                return ditContentRule.getOid();
            }
        }
        catch (LdapException ne) {
            // empty catch block
        }
        try {
            DitStructureRule ditStructureRule = (DitStructureRule)this.ditStructureRuleRegistry.lookup(name);
            if (ditStructureRule != null) {
                return ditStructureRule.getOid();
            }
        }
        catch (LdapException ldapException) {
            // empty catch block
        }
        return null;
    }

    public Schema getLoadedSchema(String schemaName) {
        return this.loadedSchemas.get(Strings.toLowerCase(schemaName));
    }

    public boolean isSchemaLoaded(String schemaName) {
        return this.loadedSchemas.containsKey(Strings.toLowerCase(schemaName));
    }

    public List<Throwable> checkRefInteg() {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        for (Normalizer normalizer : this.normalizerRegistry) {
            this.resolve(normalizer, errors);
        }
        for (LdapComparator comparator : this.comparatorRegistry) {
            this.resolve(comparator, errors);
        }
        for (SyntaxChecker syntaxChecker : this.syntaxCheckerRegistry) {
            this.resolve(syntaxChecker, errors);
        }
        for (LdapSyntax ldapSyntax : this.ldapSyntaxRegistry) {
            this.resolve(ldapSyntax, errors);
        }
        for (MatchingRule matchingRule : this.matchingRuleRegistry) {
            this.resolve(matchingRule, errors);
        }
        for (AttributeType attributeType : this.attributeTypeRegistry) {
            this.resolve(attributeType, errors);
        }
        for (ObjectClass objectClass : this.objectClassRegistry) {
            this.resolve(objectClass, errors);
        }
        return errors;
    }

    public void delCrossReferences(AttributeType attributeType) {
        if (attributeType.getEquality() != null) {
            this.delReference(attributeType, attributeType.getEquality());
        }
        if (attributeType.getOrdering() != null) {
            this.delReference(attributeType, attributeType.getOrdering());
        }
        if (attributeType.getSubstring() != null) {
            this.delReference(attributeType, attributeType.getSubstring());
        }
        if (attributeType.getSyntax() != null) {
            this.delReference(attributeType, attributeType.getSyntax());
        }
        if (attributeType.getSuperior() != null) {
            this.delReference(attributeType, attributeType.getSuperior());
        }
    }

    private void buildAttributeTypeReferences(List<Throwable> errors) {
        for (AttributeType attributeType : this.attributeTypeRegistry) {
            if (this.getUsing(attributeType) != null && !this.getUsing(attributeType).isEmpty()) continue;
            this.buildReference(errors, attributeType);
        }
    }

    private void buildComparatorReferences(List<Throwable> errors) {
        for (LdapComparator comparator : this.comparatorRegistry) {
            this.buildReference(errors, comparator);
        }
    }

    private void buildDitContentRuleReferences(List<Throwable> errors) {
        for (DitContentRule ditContentRule : this.ditContentRuleRegistry) {
        }
    }

    private void buildDitStructureRuleReferences(List<Throwable> errors) {
        for (DitStructureRule ditStructureRule : this.ditStructureRuleRegistry) {
        }
    }

    public void delCrossReferences(MatchingRule matchingRule) {
        if (matchingRule.getLdapComparator() != null) {
            this.delReference(matchingRule, matchingRule.getLdapComparator());
        }
        if (matchingRule.getNormalizer() != null) {
            this.delReference(matchingRule, matchingRule.getNormalizer());
        }
        if (matchingRule.getSyntax() != null) {
            this.delReference(matchingRule, matchingRule.getSyntax());
        }
    }

    public void buildReference(List<Throwable> errors, SchemaObject schemaObject) {
        try {
            switch (schemaObject.getObjectType()) {
                case ATTRIBUTE_TYPE: {
                    AttributeTypeHelper.addToRegistries((MutableAttributeType)schemaObject, errors, this);
                    break;
                }
                case DIT_CONTENT_RULE: {
                    DitContentRuleHelper.addToRegistries((DitContentRule)schemaObject, errors, this);
                    break;
                }
                case DIT_STRUCTURE_RULE: {
                    DitStructureRuleHelper.addToRegistries((DitStructureRule)schemaObject, errors, this);
                    break;
                }
                case LDAP_SYNTAX: {
                    LdapSyntaxHelper.addToRegistries((LdapSyntax)schemaObject, errors, this);
                    break;
                }
                case MATCHING_RULE: {
                    MatchingRuleHelper.addToRegistries((MutableMatchingRule)schemaObject, errors, this);
                    break;
                }
                case MATCHING_RULE_USE: {
                    MatchingRuleUseHelper.addToRegistries((MatchingRuleUse)schemaObject, errors, this);
                    break;
                }
                case NAME_FORM: {
                    NameFormHelper.addToRegistries((NameForm)schemaObject, errors, this);
                    break;
                }
                case OBJECT_CLASS: {
                    ObjectClassHelper.addToRegistries((ObjectClass)schemaObject, errors, this);
                }
            }
        }
        catch (LdapException ne) {
            String msg = I18n.err(I18n.ERR_04292, schemaObject.getName(), ne.getLocalizedMessage());
            LdapProtocolErrorException error = new LdapProtocolErrorException(msg, ne);
            errors.add(error);
            LOG.info(msg);
        }
    }

    public void removeReference(List<Throwable> errors, SchemaObject schemaObject) {
        try {
            switch (schemaObject.getObjectType()) {
                case ATTRIBUTE_TYPE: {
                    AttributeTypeHelper.removeFromRegistries((AttributeType)schemaObject, errors, this);
                    break;
                }
                case LDAP_SYNTAX: {
                    LdapSyntaxHelper.removeFromRegistries((LdapSyntax)schemaObject, errors, this);
                    break;
                }
                case MATCHING_RULE: {
                    MatchingRuleHelper.removeFromRegistries((MatchingRule)schemaObject, errors, this);
                    break;
                }
                case OBJECT_CLASS: {
                    ObjectClassHelper.removeFromRegistries((ObjectClass)schemaObject, errors, this);
                    break;
                }
                case DIT_CONTENT_RULE: {
                    break;
                }
                case DIT_STRUCTURE_RULE: {
                    break;
                }
                case NAME_FORM: {
                    break;
                }
            }
        }
        catch (LdapException ne) {
            String msg = I18n.err(I18n.ERR_04293, schemaObject.getName(), ne.getLocalizedMessage());
            LdapSchemaViolationException error = new LdapSchemaViolationException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, msg, ne);
            errors.add(error);
            LOG.info(msg);
        }
    }

    private void buildMatchingRuleReferences(List<Throwable> errors) {
        for (MatchingRule matchingRule : this.matchingRuleRegistry) {
            this.buildReference(errors, matchingRule);
        }
    }

    private void buildMatchingRuleUseReferences(List<Throwable> errors) {
        for (MatchingRuleUse matchingRuleUse : this.matchingRuleUseRegistry) {
            this.buildReference(errors, matchingRuleUse);
        }
    }

    private void buildNameFormReferences(List<Throwable> errors) {
        for (NameForm nameForm : this.nameFormRegistry) {
        }
    }

    private void buildNormalizerReferences(List<Throwable> errors) {
        for (Normalizer normalizer : this.normalizerRegistry) {
            this.buildReference(errors, normalizer);
        }
    }

    private void buildObjectClassReferences(List<Throwable> errors) {
        HashSet<String> done = new HashSet<String>();
        for (ObjectClass objectClass : this.objectClassRegistry) {
            if (done.contains(objectClass.getOid())) continue;
            done.add(objectClass.getOid());
            this.buildReference(errors, objectClass);
        }
    }

    private void buildLdapSyntaxReferences(List<Throwable> errors) {
        for (LdapSyntax syntax : this.ldapSyntaxRegistry) {
            this.buildReference(errors, syntax);
        }
    }

    private void buildSyntaxCheckerReferences(List<Throwable> errors) {
        for (SyntaxChecker syntaxChecker : this.syntaxCheckerRegistry) {
            this.buildReference(errors, syntaxChecker);
        }
    }

    public List<Throwable> buildReferences() {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        this.buildComparatorReferences(errors);
        this.buildNormalizerReferences(errors);
        this.buildSyntaxCheckerReferences(errors);
        this.buildLdapSyntaxReferences(errors);
        this.buildMatchingRuleReferences(errors);
        this.buildAttributeTypeReferences(errors);
        this.buildMatchingRuleUseReferences(errors);
        this.buildObjectClassReferences(errors);
        this.buildDitContentRuleReferences(errors);
        this.buildNameFormReferences(errors);
        this.buildDitStructureRuleReferences(errors);
        return errors;
    }

    private void resolve(LdapSyntax syntax, List<Throwable> errors) {
        try {
            LdapSyntaxHelper.addToRegistries(syntax, errors, this);
        }
        catch (LdapException e) {
            errors.add(e);
        }
    }

    private void resolve(Normalizer normalizer, List<Throwable> errors) {
    }

    private void resolve(LdapComparator<?> comparator, List<Throwable> errors) {
    }

    private void resolve(SyntaxChecker syntaxChecker, List<Throwable> errors) {
    }

    private void resolve(MatchingRule matchingRule, List<Throwable> errors) {
        LdapComparator<? super Object> comparator;
        String syntaxOid = matchingRule.getSyntaxOid();
        if (syntaxOid != null) {
            try {
                this.ldapSyntaxRegistry.lookup(syntaxOid);
            }
            catch (LdapException ne) {
                LdapSchemaException ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.OID_ALREADY_REGISTERED, I18n.err(I18n.ERR_04294, matchingRule.getOid()), ne);
                ldapSchemaException.setSourceObject(matchingRule);
                errors.add(ldapSchemaException);
            }
        } else {
            LdapSchemaException ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.OID_ALREADY_REGISTERED, I18n.err(I18n.ERR_04294, matchingRule.getOid()));
            ldapSchemaException.setSourceObject(matchingRule);
            errors.add(ldapSchemaException);
        }
        Normalizer normalizer = matchingRule.getNormalizer();
        if (normalizer == null) {
            LdapSchemaViolationException error = new LdapSchemaViolationException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, I18n.err(I18n.ERR_04295, matchingRule.getOid()));
            errors.add(error);
        }
        if ((comparator = matchingRule.getLdapComparator()) == null) {
            LdapSchemaViolationException error = new LdapSchemaViolationException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, I18n.err(I18n.ERR_04296, matchingRule.getOid()));
            errors.add(error);
        }
    }

    private void resolveRecursive(AttributeType attributeType, Set<String> processed, List<Throwable> errors) {
        String substringOid;
        String orderingOid;
        String equalityOid;
        String syntaxOid;
        String superiorOid = attributeType.getSuperiorOid();
        AttributeType superior = null;
        if (superiorOid != null) {
            block20: {
                try {
                    superior = (AttributeType)this.attributeTypeRegistry.lookup(superiorOid);
                }
                catch (LdapException ne) {
                    if (processed.contains(superiorOid)) break block20;
                    errors.add(ne);
                }
            }
            if (superior != null) {
                if (!processed.contains(superiorOid)) {
                    this.resolveRecursive(superior, processed, errors);
                    processed.add(attributeType.getOid());
                } else {
                    LdapSchemaViolationException error = new LdapSchemaViolationException(ResultCodeEnum.OTHER, I18n.err(I18n.ERR_04297, attributeType.getOid()));
                    errors.add(error);
                    return;
                }
            }
        }
        if ((syntaxOid = attributeType.getSyntaxOid()) != null) {
            try {
                this.ldapSyntaxRegistry.lookup(syntaxOid);
            }
            catch (LdapException ne) {
                errors.add(ne);
            }
        } else if (superior == null) {
            LdapSchemaViolationException error = new LdapSchemaViolationException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, I18n.err(I18n.ERR_04298, attributeType.getOid()));
            errors.add(error);
        }
        if ((equalityOid = attributeType.getEqualityOid()) != null) {
            try {
                this.matchingRuleRegistry.lookup(equalityOid);
            }
            catch (LdapException ne) {
                errors.add(ne);
            }
        }
        if ((orderingOid = attributeType.getOrderingOid()) != null) {
            try {
                this.matchingRuleRegistry.lookup(orderingOid);
            }
            catch (LdapException ne) {
                errors.add(ne);
            }
        }
        if ((substringOid = attributeType.getSubstringOid()) != null) {
            try {
                this.matchingRuleRegistry.lookup(substringOid);
            }
            catch (LdapException ne) {
                errors.add(ne);
            }
        }
    }

    private void resolve(AttributeType attributeType, List<Throwable> errors) {
        HashSet<String> processed = new HashSet<String>();
        processed.add(attributeType.getOid());
        this.resolveRecursive(attributeType, processed, errors);
    }

    private List<AttributeType> getMustRecursive(List<AttributeType> musts, Set<ObjectClass> processed, ObjectClass objectClass) {
        if (objectClass != null) {
            if (processed.contains(objectClass)) {
                return null;
            }
            processed.add(objectClass);
            for (AttributeType must : objectClass.getMustAttributeTypes()) {
                musts.add(must);
            }
            for (ObjectClass superior : objectClass.getSuperiors()) {
                this.getMustRecursive(musts, processed, superior);
            }
        }
        return musts;
    }

    private void resolve(ObjectClass objectClass, List<Throwable> errors) {
        HashSet<String> processed = new HashSet<String>();
        processed.add(objectClass.getOid());
        this.resolveRecursive(objectClass, processed, errors);
        List<AttributeType> musts = this.getMustRecursive(new ArrayList<AttributeType>(), new HashSet<ObjectClass>(), objectClass);
        if (musts != null) {
            for (AttributeType may : objectClass.getMayAttributeTypes()) {
                if (!musts.contains(may)) continue;
                LdapSchemaException ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.OC_DUPLICATE_AT_IN_MAY_AND_MUST);
                ldapSchemaException.setSourceObject(objectClass);
                ldapSchemaException.setOtherObject(may);
                errors.add(ldapSchemaException);
            }
        }
    }

    private void resolveRecursive(ObjectClass objectClass, Set<String> processed, List<Throwable> errors) {
        List<String> superiorOids = objectClass.getSuperiorOids();
        ObjectClass superior = null;
        for (String superiorOid : superiorOids) {
            block12: {
                try {
                    superior = (ObjectClass)this.objectClassRegistry.lookup(superiorOid);
                }
                catch (LdapException ne) {
                    if (processed.contains(superiorOid)) break block12;
                    LdapSchemaException ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.OC_NONEXISTENT_SUPERIOR, (Throwable)ne);
                    ldapSchemaException.setSourceObject(objectClass);
                    ldapSchemaException.setRelatedId(superiorOid);
                    errors.add(ldapSchemaException);
                }
            }
            if (superior == null) continue;
            if (!processed.contains(superior.getOid())) {
                this.resolveRecursive(superior, processed, errors);
                processed.add(objectClass.getOid());
                continue;
            }
            LdapSchemaException ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.OC_CYCLE_CLASS_HIERARCHY);
            ldapSchemaException.setSourceObject(objectClass);
            ldapSchemaException.setOtherObject(superior);
            errors.add(ldapSchemaException);
            return;
        }
        for (String mayOid : objectClass.getMayAttributeTypeOids()) {
            try {
                this.attributeTypeRegistry.lookup(mayOid);
            }
            catch (LdapException ne) {
                errors.add(ne);
            }
        }
        for (String mustOid : objectClass.getMustAttributeTypeOids()) {
            try {
                this.attributeTypeRegistry.lookup(mustOid);
            }
            catch (LdapException ne) {
                errors.add(ne);
            }
        }
        try {
            ObjectClassHelper.addToRegistries(objectClass, errors, this);
        }
        catch (LdapException ne) {
            // empty catch block
        }
    }

    public List<Throwable> add(List<Throwable> errors, SchemaObject schemaObject, boolean check) throws LdapException {
        boolean wasRelaxed = this.isRelaxed;
        this.setRelaxed();
        this.register(errors, schemaObject);
        this.associateWithSchema(errors, schemaObject);
        if (check) {
            this.buildReference(errors, schemaObject);
        }
        schemaObject.lock();
        if (check && errors.isEmpty()) {
            List<Throwable> checkErrors = this.checkRefInteg();
            errors.addAll(checkErrors);
        }
        if (!wasRelaxed) {
            this.setStrict();
        }
        return errors;
    }

    public List<Throwable> delete(List<Throwable> errors, SchemaObject schemaObject) throws LdapException {
        boolean wasRelaxed = this.isRelaxed;
        this.setRelaxed();
        SchemaObject removed = this.unregister(errors, schemaObject);
        this.dissociateFromSchema(errors, removed);
        this.removeReference(errors, removed);
        if (errors.isEmpty()) {
            List<Throwable> checkErrors = this.checkRefInteg();
            errors.addAll(checkErrors);
        }
        if (!wasRelaxed) {
            this.setStrict();
        }
        return errors;
    }

    @Override
    public void schemaLoaded(Schema schema) {
        this.loadedSchemas.put(Strings.toLowerCase(schema.getSchemaName()), schema);
    }

    @Override
    public void schemaUnloaded(Schema schema) {
        this.loadedSchemas.remove(Strings.toLowerCase(schema.getSchemaName()));
    }

    public Map<String, Schema> getLoadedSchemas() {
        return Collections.unmodifiableMap(this.loadedSchemas);
    }

    public Map<String, Set<SchemaObjectWrapper>> getObjectBySchemaName() {
        return this.schemaObjects;
    }

    private String getSchemaName(SchemaObject schemaObject) {
        String schemaName = Strings.toLowerCase(schemaObject.getSchemaName());
        if (this.loadedSchemas.containsKey(schemaName)) {
            return schemaName;
        }
        return "other";
    }

    public boolean contains(SchemaObject schemaObject) {
        String schemaName = schemaObject.getSchemaName();
        Set<SchemaObjectWrapper> setSchemaObjects = this.schemaObjects.get(schemaName);
        if (setSchemaObjects == null || setSchemaObjects.isEmpty()) {
            return false;
        }
        SchemaObjectWrapper wrapper = new SchemaObjectWrapper(schemaObject);
        return setSchemaObjects.contains(wrapper);
    }

    public Set<SchemaObjectWrapper> addSchema(String schemaName) {
        HashSet<SchemaObjectWrapper> content = new HashSet<SchemaObjectWrapper>();
        this.schemaObjects.put(schemaName, content);
        return content;
    }

    private void register(List<Throwable> errors, SchemaObject schemaObject) throws LdapException {
        LOG.debug("Registering {}:{}", (Object)schemaObject.getObjectType(), (Object)schemaObject.getOid());
        if (!(schemaObject instanceof LoadableSchemaObject) && this.globalOidRegistry.contains(schemaObject.getOid())) {
            String msg = I18n.err(I18n.ERR_04301, new Object[]{schemaObject.getObjectType(), schemaObject.getOid()});
            LOG.error(msg);
            LdapUnwillingToPerformException error = new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
            errors.add(error);
            return;
        }
        try {
            switch (schemaObject.getObjectType()) {
                case ATTRIBUTE_TYPE: {
                    this.attributeTypeRegistry.register((AttributeType)schemaObject);
                    break;
                }
                case COMPARATOR: {
                    this.comparatorRegistry.register((LdapComparator)schemaObject);
                    break;
                }
                case DIT_CONTENT_RULE: {
                    this.ditContentRuleRegistry.register((DitContentRule)schemaObject);
                    break;
                }
                case DIT_STRUCTURE_RULE: {
                    this.ditStructureRuleRegistry.register((DitStructureRule)schemaObject);
                    break;
                }
                case LDAP_SYNTAX: {
                    this.ldapSyntaxRegistry.register((LdapSyntax)schemaObject);
                    break;
                }
                case MATCHING_RULE: {
                    this.matchingRuleRegistry.register((MatchingRule)schemaObject);
                    break;
                }
                case MATCHING_RULE_USE: {
                    this.matchingRuleUseRegistry.register((MatchingRuleUse)schemaObject);
                    break;
                }
                case NAME_FORM: {
                    this.nameFormRegistry.register((NameForm)schemaObject);
                    break;
                }
                case NORMALIZER: {
                    this.normalizerRegistry.register((Normalizer)schemaObject);
                    break;
                }
                case OBJECT_CLASS: {
                    this.objectClassRegistry.register((ObjectClass)schemaObject);
                    break;
                }
                case SYNTAX_CHECKER: {
                    this.syntaxCheckerRegistry.register((SyntaxChecker)schemaObject);
                }
            }
        }
        catch (Exception e) {
            errors.add(e);
        }
    }

    public void associateWithSchema(List<Throwable> errors, SchemaObject schemaObject) {
        SchemaObjectWrapper schemaObjectWrapper;
        LOG.debug("Registering {}:{}", (Object)schemaObject.getObjectType(), (Object)schemaObject.getOid());
        if (!(schemaObject instanceof LoadableSchemaObject) && this.globalOidRegistry.contains(schemaObject.getOid())) {
            String msg = I18n.err(I18n.ERR_04301, new Object[]{schemaObject.getObjectType(), schemaObject.getOid()});
            LOG.error(msg);
            LdapUnwillingToPerformException error = new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
            errors.add(error);
            return;
        }
        String schemaName = this.getSchemaName(schemaObject);
        Set<SchemaObjectWrapper> content = this.schemaObjects.get(schemaName);
        if (content == null) {
            content = new HashSet<SchemaObjectWrapper>();
            this.schemaObjects.put(Strings.toLowerCase(schemaName), content);
        }
        if (content.contains(schemaObjectWrapper = new SchemaObjectWrapper(schemaObject))) {
            LOG.info("Registering of {}:{} failed, is already present in the Registries", (Object)schemaObject.getObjectType(), (Object)schemaObject.getOid());
        } else {
            content.add(schemaObjectWrapper);
            if (!(schemaObject instanceof LoadableSchemaObject)) {
                try {
                    this.globalOidRegistry.register(schemaObject);
                }
                catch (LdapException ne) {
                    errors.add(ne);
                    return;
                }
            }
            LOG.debug("registered {} for OID {}", (Object)schemaObject.getName(), (Object)schemaObject.getOid());
        }
    }

    public void dissociateFromSchema(List<Throwable> errors, SchemaObject schemaObject) throws LdapException {
        SchemaObjectWrapper schemaObjectWrapper;
        LOG.debug("Unregistering {}:{}", (Object)schemaObject.getObjectType(), (Object)schemaObject.getOid());
        if (!(schemaObject instanceof LoadableSchemaObject) && !this.globalOidRegistry.contains(schemaObject.getOid())) {
            String msg = I18n.err(I18n.ERR_04302, new Object[]{schemaObject.getObjectType(), schemaObject.getOid()});
            LOG.error(msg);
            LdapUnwillingToPerformException error = new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
            errors.add(error);
            return;
        }
        String schemaName = this.getSchemaName(schemaObject);
        String oid = schemaObject.getOid();
        Set<SchemaObjectWrapper> content = this.schemaObjects.get(schemaName);
        if (!content.contains(schemaObjectWrapper = new SchemaObjectWrapper(schemaObject))) {
            LOG.info("Unregistering of {}:{} failed, is not present in the Registries", (Object)schemaObject.getObjectType(), (Object)schemaObject.getOid());
        } else {
            content.remove(schemaObjectWrapper);
            if (!(schemaObject instanceof LoadableSchemaObject)) {
                try {
                    this.globalOidRegistry.unregister(oid);
                }
                catch (LdapException ne) {
                    errors.add(ne);
                    return;
                }
            }
            LOG.debug("Unregistered {} for OID {}", (Object)schemaObject.getName(), (Object)schemaObject.getOid());
        }
    }

    private SchemaObject unregister(List<Throwable> errors, SchemaObject schemaObject) throws LdapException {
        LOG.debug("Unregistering {}:{}", (Object)schemaObject.getObjectType(), (Object)schemaObject.getOid());
        if (!(schemaObject instanceof LoadableSchemaObject) && !this.globalOidRegistry.contains(schemaObject.getOid())) {
            String msg = I18n.err(I18n.ERR_04302, new Object[]{schemaObject.getObjectType(), schemaObject.getOid()});
            LOG.error(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        AbstractSchemaObject unregistered = null;
        switch (schemaObject.getObjectType()) {
            case ATTRIBUTE_TYPE: {
                unregistered = this.attributeTypeRegistry.unregister((AttributeType)schemaObject);
                break;
            }
            case COMPARATOR: {
                unregistered = this.comparatorRegistry.unregister((LdapComparator)schemaObject);
                break;
            }
            case DIT_CONTENT_RULE: {
                unregistered = this.ditContentRuleRegistry.unregister((DitContentRule)schemaObject);
                break;
            }
            case DIT_STRUCTURE_RULE: {
                unregistered = this.ditStructureRuleRegistry.unregister((DitStructureRule)schemaObject);
                break;
            }
            case LDAP_SYNTAX: {
                unregistered = this.ldapSyntaxRegistry.unregister((LdapSyntax)schemaObject);
                break;
            }
            case MATCHING_RULE: {
                unregistered = this.matchingRuleRegistry.unregister((MatchingRule)schemaObject);
                break;
            }
            case MATCHING_RULE_USE: {
                unregistered = this.matchingRuleUseRegistry.unregister((MatchingRuleUse)schemaObject);
                break;
            }
            case NAME_FORM: {
                unregistered = this.nameFormRegistry.unregister((NameForm)schemaObject);
                break;
            }
            case NORMALIZER: {
                unregistered = this.normalizerRegistry.unregister((Normalizer)schemaObject);
                break;
            }
            case OBJECT_CLASS: {
                unregistered = this.objectClassRegistry.unregister((ObjectClass)schemaObject);
                break;
            }
            case SYNTAX_CHECKER: {
                unregistered = this.syntaxCheckerRegistry.unregister((SyntaxChecker)schemaObject);
            }
        }
        return unregistered;
    }

    public void dissociateFromSchema(SchemaObject schemaObject) throws LdapException {
        Set<SchemaObjectWrapper> content = this.schemaObjects.get(Strings.toLowerCase(schemaObject.getSchemaName()));
        if (content != null) {
            SchemaObjectWrapper schemaObjectWrapper = new SchemaObjectWrapper(schemaObject);
            if (content.contains(schemaObjectWrapper)) {
                content.remove(schemaObjectWrapper);
                if (!(schemaObject instanceof LoadableSchemaObject)) {
                    this.globalOidRegistry.unregister(schemaObject.getOid());
                }
                LOG.debug("Unregistered {}:{}", (Object)schemaObject.getObjectType(), (Object)schemaObject.getOid());
            } else {
                LOG.debug("Unregistering of {}:{} failed, not found in Registries", (Object)schemaObject.getObjectType(), (Object)schemaObject.getOid());
            }
        }
    }

    public boolean isReferenced(SchemaObject schemaObject) {
        boolean referenced;
        SchemaObjectWrapper wrapper = new SchemaObjectWrapper(schemaObject);
        Set<SchemaObjectWrapper> set = this.usedBy.get(wrapper);
        boolean bl = referenced = set != null && set.size() != 0;
        if (LOG.isDebugEnabled()) {
            if (referenced) {
                LOG.debug("The {}:{} is referenced", (Object)schemaObject.getObjectType(), (Object)schemaObject.getOid());
            } else {
                LOG.debug("The {}:{} is not referenced", (Object)schemaObject.getObjectType(), (Object)schemaObject.getOid());
            }
        }
        return referenced;
    }

    public Set<SchemaObjectWrapper> getUsedBy(SchemaObject schemaObject) {
        SchemaObjectWrapper wrapper = new SchemaObjectWrapper(schemaObject);
        return this.usedBy.get(wrapper);
    }

    public String dumpUsedBy() {
        StringBuilder sb = new StringBuilder();
        sb.append("USED BY :\n");
        try {
            for (SchemaObjectWrapper wrapper : this.usedBy.keySet()) {
                sb.append((Object)wrapper.get().getObjectType()).append('[').append(wrapper.get().getOid()).append("] : {");
                boolean isFirst = true;
                for (SchemaObjectWrapper uses : this.usedBy.get(wrapper)) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append((Object)uses.get().getObjectType()).append('[').append(wrapper.get().getOid()).append("]");
                }
                sb.append("}\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public String dumpUsing() {
        StringBuilder sb = new StringBuilder();
        sb.append("USING :\n");
        try {
            for (SchemaObjectWrapper wrapper : this.using.keySet()) {
                sb.append((Object)wrapper.get().getObjectType()).append('[').append(wrapper.get().getOid()).append("] : {");
                boolean isFirst = true;
                for (SchemaObjectWrapper uses : this.using.get(wrapper)) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append((Object)uses.get().getObjectType()).append('[').append(wrapper.get().getOid()).append("]");
                }
                sb.append("}\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public Set<SchemaObjectWrapper> getUsing(SchemaObject schemaObject) {
        SchemaObjectWrapper wrapper = new SchemaObjectWrapper(schemaObject);
        return this.using.get(wrapper);
    }

    private void addUsing(SchemaObject reference, SchemaObject referee) {
        if (reference == null || referee == null) {
            return;
        }
        SchemaObjectWrapper wrapper = new SchemaObjectWrapper(reference);
        Set<SchemaObjectWrapper> uses = this.getUsing(reference);
        if (uses == null) {
            uses = new HashSet<SchemaObjectWrapper>();
        }
        uses.add(new SchemaObjectWrapper(referee));
        this.using.put(wrapper, uses);
    }

    public void addReference(SchemaObject base, SchemaObject referenced) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.dump("add", base, referenced));
        }
        this.addUsing(base, referenced);
        this.addUsedBy(referenced, base);
        if (LOG.isTraceEnabled()) {
            LOG.trace(this.dumpUsedBy());
            LOG.trace(this.dumpUsing());
        }
    }

    private void addUsedBy(SchemaObject referee, SchemaObject reference) {
        if (reference == null || referee == null) {
            return;
        }
        SchemaObjectWrapper wrapper = new SchemaObjectWrapper(referee);
        Set<SchemaObjectWrapper> uses = this.getUsedBy(referee);
        if (uses == null) {
            uses = new HashSet<SchemaObjectWrapper>();
        }
        uses.add(new SchemaObjectWrapper(reference));
        this.usedBy.put(wrapper, uses);
    }

    private void delUsing(SchemaObject reference, SchemaObject referee) {
        if (reference == null || referee == null) {
            return;
        }
        Set<SchemaObjectWrapper> uses = this.getUsing(reference);
        if (uses == null) {
            return;
        }
        uses.remove(new SchemaObjectWrapper(referee));
        SchemaObjectWrapper wrapper = new SchemaObjectWrapper(reference);
        if (uses.size() == 0) {
            this.using.remove(wrapper);
        } else {
            this.using.put(wrapper, uses);
        }
    }

    private void delUsedBy(SchemaObject referee, SchemaObject reference) {
        if (reference == null || referee == null) {
            return;
        }
        Set<SchemaObjectWrapper> uses = this.getUsedBy(referee);
        if (uses == null) {
            return;
        }
        uses.remove(new SchemaObjectWrapper(reference));
        SchemaObjectWrapper wrapper = new SchemaObjectWrapper(referee);
        if (uses.size() == 0) {
            this.usedBy.remove(wrapper);
        } else {
            this.usedBy.put(wrapper, uses);
        }
    }

    public void delReference(SchemaObject base, SchemaObject referenced) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.dump("del", base, referenced));
        }
        this.delUsing(base, referenced);
        this.delUsedBy(referenced, base);
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.dumpUsedBy());
            LOG.debug(this.dumpUsing());
        }
    }

    private String dump(String op, SchemaObject reference, SchemaObject referee) {
        return op + " : " + (Object)((Object)reference.getObjectType()) + "[" + reference.getOid() + "]/[" + (Object)((Object)referee.getObjectType()) + "[" + referee.getOid() + "]";
    }

    private boolean checkReferences(SchemaObject reference, SchemaObject referee, String message) {
        SchemaObjectWrapper referenceWrapper = new SchemaObjectWrapper(reference);
        SchemaObjectWrapper refereeWrapper = new SchemaObjectWrapper(referee);
        if (!this.using.containsKey(referenceWrapper)) {
            LOG.debug("The Syntax {}:{} does not reference any " + message, (Object)reference.getObjectType(), (Object)reference.getOid());
            return false;
        }
        Set<SchemaObjectWrapper> usings = this.using.get(referenceWrapper);
        if (!usings.contains(refereeWrapper)) {
            LOG.debug("The {}:{} does not reference any " + message, (Object)reference.getObjectType(), (Object)reference.getOid());
            return false;
        }
        if (!this.usedBy.containsKey(refereeWrapper)) {
            LOG.debug("The {}:{} is not referenced by any " + message, (Object)referee.getObjectType(), (Object)referee.getOid());
            return false;
        }
        Set<SchemaObjectWrapper> used = this.usedBy.get(refereeWrapper);
        if (!used.contains(referenceWrapper)) {
            LOG.debug("The {}:{} is not referenced by any " + message, (Object)referee.getObjectType(), (Object)referee.getOid());
            return false;
        }
        return true;
    }

    public boolean check() {
        LOG.debug("Checking Syntaxes");
        for (LdapSyntax syntax : this.ldapSyntaxRegistry) {
            if (syntax.getSyntaxChecker() == null) {
                LOG.debug("The Syntax {} has no SyntaxChecker", (Object)syntax);
                return false;
            }
            if (!this.syntaxCheckerRegistry.contains(syntax.getSyntaxChecker().getOid())) {
                LOG.debug("Cannot find the SyntaxChecker {} for the Syntax {}", (Object)syntax.getSyntaxChecker().getOid(), (Object)syntax);
                return false;
            }
            if (this.checkReferences(syntax, syntax.getSyntaxChecker(), "SyntaxChecker")) continue;
            return false;
        }
        LOG.debug("Checking MatchingRules...");
        for (MatchingRule matchingRule : this.matchingRuleRegistry) {
            if (matchingRule.getNormalizer() == null) {
                LOG.debug("The MatchingRule {} has no Normalizer", (Object)matchingRule);
                return false;
            }
            if (!this.normalizerRegistry.contains(matchingRule.getNormalizer().getOid())) {
                LOG.debug("Cannot find the Normalizer {} for the MatchingRule {}", (Object)matchingRule.getNormalizer().getOid(), (Object)matchingRule);
                return false;
            }
            if (matchingRule.getLdapComparator() == null) {
                LOG.debug("The MatchingRule {} has no Comparator", (Object)matchingRule);
                return false;
            }
            if (!this.comparatorRegistry.contains(matchingRule.getLdapComparator().getOid())) {
                LOG.debug("Cannot find the Comparator {} for the MatchingRule {}", (Object)matchingRule.getLdapComparator().getOid(), (Object)matchingRule);
                return false;
            }
            if (matchingRule.getSyntax() == null) {
                LOG.debug("The MatchingRule {} has no Syntax", (Object)matchingRule);
                return false;
            }
            if (!this.ldapSyntaxRegistry.contains(matchingRule.getSyntax().getOid())) {
                LOG.debug("Cannot find the Syntax {} for the MatchingRule {}", (Object)matchingRule.getSyntax().getOid(), (Object)matchingRule);
                return false;
            }
            if (!this.checkReferences(matchingRule, matchingRule.getSyntax(), "Syntax")) {
                return false;
            }
            if (!this.checkReferences(matchingRule, matchingRule.getNormalizer(), "Normalizer")) {
                return false;
            }
            if (this.checkReferences(matchingRule, matchingRule.getLdapComparator(), "Comparator")) continue;
            return false;
        }
        LOG.debug("Checking ObjectClasses...");
        for (ObjectClass objectClass : this.objectClassRegistry) {
            if (objectClass.getMayAttributeTypes() != null) {
                for (AttributeType may : objectClass.getMayAttributeTypes()) {
                    if (!this.attributeTypeRegistry.contains(may.getOid())) {
                        LOG.debug("Cannot find the AttributeType {} for the ObjectClass {} MAY", (Object)may, (Object)objectClass);
                        return false;
                    }
                    if (this.checkReferences(objectClass, may, "AttributeType")) continue;
                    return false;
                }
            }
            if (objectClass.getMustAttributeTypes() != null) {
                for (AttributeType must : objectClass.getMustAttributeTypes()) {
                    if (!this.attributeTypeRegistry.contains(must.getOid())) {
                        LOG.debug("Cannot find the AttributeType {} for the ObjectClass {} MUST", (Object)must, (Object)objectClass);
                        return false;
                    }
                    if (this.checkReferences(objectClass, must, "AttributeType")) continue;
                    return false;
                }
            }
            if (objectClass.getSuperiors() == null) continue;
            for (ObjectClass superior : objectClass.getSuperiors()) {
                if (!this.objectClassRegistry.contains(objectClass.getOid())) {
                    LOG.debug("Cannot find the ObjectClass {} for the ObjectClass {} SUPERIORS", (Object)superior, (Object)objectClass);
                    return false;
                }
                if (this.checkReferences(objectClass, superior, "ObjectClass")) continue;
                return false;
            }
        }
        LOG.debug("Checking AttributeTypes...");
        for (AttributeType attributeType : this.attributeTypeRegistry) {
            if (attributeType.getSyntax() == null) {
                LOG.debug("The AttributeType {} has no Syntax", (Object)attributeType);
                return false;
            }
            if (!this.ldapSyntaxRegistry.contains(attributeType.getSyntax().getOid())) {
                LOG.debug("Cannot find the Syntax {} for the AttributeType {}", (Object)attributeType.getSyntax().getOid(), (Object)attributeType);
                return false;
            }
            if (!this.checkReferences(attributeType, attributeType.getSyntax(), "AttributeType")) {
                return false;
            }
            if (attributeType.getEquality() != null) {
                if (!this.matchingRuleRegistry.contains(attributeType.getEquality().getOid())) {
                    LOG.debug("Cannot find the MatchingRule {} for the AttributeType {}", (Object)attributeType.getEquality().getOid(), (Object)attributeType);
                    return false;
                }
                if (!this.checkReferences(attributeType, attributeType.getEquality(), "AttributeType")) {
                    return false;
                }
            }
            if (attributeType.getOrdering() != null) {
                if (!this.matchingRuleRegistry.contains(attributeType.getOrdering().getOid())) {
                    LOG.debug("Cannot find the MatchingRule {} for the AttributeType {}", (Object)attributeType.getOrdering().getOid(), (Object)attributeType);
                    return false;
                }
                if (!this.checkReferences(attributeType, attributeType.getOrdering(), "AttributeType")) {
                    return false;
                }
            }
            if (attributeType.getSubstring() != null) {
                if (!this.matchingRuleRegistry.contains(attributeType.getSubstring().getOid())) {
                    LOG.debug("Cannot find the MatchingRule {} for the AttributeType {}", (Object)attributeType.getSubstring().getOid(), (Object)attributeType);
                    return false;
                }
                if (!this.checkReferences(attributeType, attributeType.getSubstring(), "AttributeType")) {
                    return false;
                }
            }
            if (attributeType.getSuperior() == null) continue;
            AttributeType superior = attributeType.getSuperior();
            if (!this.attributeTypeRegistry.contains(superior.getOid())) {
                LOG.debug("Cannot find the AttributeType {} for the AttributeType {} SUPERIOR", (Object)superior, (Object)attributeType);
                return false;
            }
            if (this.checkReferences(attributeType, superior, "AttributeType")) continue;
            return false;
        }
        return true;
    }

    public Registries clone() throws CloneNotSupportedException {
        Registries clone = (Registries)super.clone();
        clone.globalOidRegistry = this.globalOidRegistry.copy();
        clone.attributeTypeRegistry = this.attributeTypeRegistry.copy();
        clone.comparatorRegistry = this.comparatorRegistry.copy();
        clone.ditContentRuleRegistry = this.ditContentRuleRegistry.copy();
        clone.ditStructureRuleRegistry = this.ditStructureRuleRegistry.copy();
        clone.ldapSyntaxRegistry = this.ldapSyntaxRegistry.copy();
        clone.matchingRuleRegistry = this.matchingRuleRegistry.copy();
        clone.matchingRuleUseRegistry = this.matchingRuleUseRegistry.copy();
        clone.nameFormRegistry = this.nameFormRegistry.copy();
        clone.normalizerRegistry = this.normalizerRegistry.copy();
        clone.objectClassRegistry = this.objectClassRegistry.copy();
        clone.syntaxCheckerRegistry = this.syntaxCheckerRegistry.copy();
        for (AttributeType attributeType : clone.attributeTypeRegistry) {
            clone.globalOidRegistry.put(attributeType);
        }
        for (DitContentRule ditContentRule : clone.ditContentRuleRegistry) {
            clone.globalOidRegistry.put(ditContentRule);
        }
        for (DitStructureRule ditStructureRule : clone.ditStructureRuleRegistry) {
            clone.globalOidRegistry.put(ditStructureRule);
        }
        for (MatchingRule matchingRule : clone.matchingRuleRegistry) {
            clone.globalOidRegistry.put(matchingRule);
        }
        for (MatchingRuleUse matchingRuleUse : clone.matchingRuleUseRegistry) {
            clone.globalOidRegistry.put(matchingRuleUse);
        }
        for (NameForm nameForm : clone.nameFormRegistry) {
            clone.globalOidRegistry.put(nameForm);
        }
        for (ObjectClass objectClass : clone.objectClassRegistry) {
            clone.globalOidRegistry.put(objectClass);
        }
        for (LdapSyntax syntax : clone.ldapSyntaxRegistry) {
            clone.globalOidRegistry.put(syntax);
        }
        clone.loadedSchemas = new HashMap<String, Schema>();
        for (String schemaName : this.loadedSchemas.keySet()) {
            clone.loadedSchemas.put(schemaName, this.loadedSchemas.get(schemaName));
        }
        clone.using = new HashMap<SchemaObjectWrapper, Set<SchemaObjectWrapper>>();
        clone.usedBy = new HashMap<SchemaObjectWrapper, Set<SchemaObjectWrapper>>();
        clone.buildReferences();
        clone.checkRefInteg();
        clone.schemaObjects = new HashMap<String, Set<SchemaObjectWrapper>>();
        for (String schemaName : this.schemaObjects.keySet()) {
            HashSet<SchemaObjectWrapper> objects = new HashSet<SchemaObjectWrapper>();
            for (SchemaObjectWrapper schemaObjectWrapper : this.schemaObjects.get(schemaName)) {
                SchemaObject original = schemaObjectWrapper.get();
                try {
                    if (!(original instanceof LoadableSchemaObject)) {
                        SchemaObject copy = clone.globalOidRegistry.getSchemaObject(original.getOid());
                        SchemaObjectWrapper newWrapper = new SchemaObjectWrapper(copy);
                        objects.add(newWrapper);
                        continue;
                    }
                    SchemaObjectWrapper newWrapper = new SchemaObjectWrapper(original);
                    objects.add(newWrapper);
                }
                catch (LdapException ne) {}
            }
            clone.schemaObjects.put(schemaName, objects);
        }
        return clone;
    }

    public boolean isRelaxed() {
        return this.isRelaxed;
    }

    public boolean isStrict() {
        return !this.isRelaxed;
    }

    public void setRelaxed() {
        this.isRelaxed = true;
    }

    public void setStrict() {
        this.isRelaxed = false;
    }

    public boolean isDisabledAccepted() {
        return this.disabledAccepted;
    }

    public Set<SchemaObjectWrapper> getReferencing(SchemaObject schemaObject) {
        SchemaObjectWrapper schemaObjectWrapper = new SchemaObjectWrapper(schemaObject);
        return this.usedBy.get(schemaObjectWrapper);
    }

    public void setDisabledAccepted(boolean disabledAccepted) {
        this.disabledAccepted = disabledAccepted;
    }

    public void clear() throws LdapException {
        Set<SchemaObjectWrapper> wrapperSet;
        if (this.attributeTypeRegistry != null) {
            this.attributeTypeRegistry.clear();
        }
        if (this.comparatorRegistry != null) {
            this.comparatorRegistry.clear();
        }
        if (this.ditContentRuleRegistry != null) {
            this.ditContentRuleRegistry.clear();
        }
        if (this.ditStructureRuleRegistry != null) {
            this.ditStructureRuleRegistry.clear();
        }
        if (this.matchingRuleRegistry != null) {
            this.matchingRuleRegistry.clear();
        }
        if (this.matchingRuleUseRegistry != null) {
            this.matchingRuleUseRegistry.clear();
        }
        if (this.nameFormRegistry != null) {
            this.nameFormRegistry.clear();
        }
        if (this.normalizerRegistry != null) {
            this.normalizerRegistry.clear();
        }
        if (this.objectClassRegistry != null) {
            this.objectClassRegistry.clear();
        }
        if (this.ldapSyntaxRegistry != null) {
            this.ldapSyntaxRegistry.clear();
        }
        if (this.syntaxCheckerRegistry != null) {
            this.syntaxCheckerRegistry.clear();
        }
        for (String schemaName : this.schemaObjects.keySet()) {
            wrapperSet = this.schemaObjects.get(schemaName);
            wrapperSet.clear();
        }
        this.schemaObjects.clear();
        for (SchemaObjectWrapper wrapper : this.usedBy.keySet()) {
            wrapperSet = this.usedBy.get(wrapper);
            wrapperSet.clear();
        }
        this.usedBy.clear();
        for (SchemaObjectWrapper wrapper : this.using.keySet()) {
            wrapperSet = this.using.get(wrapper);
            wrapperSet.clear();
        }
        this.using.clear();
        this.globalOidRegistry.clear();
        this.loadedSchemas.clear();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Registries [");
        if (this.isRelaxed) {
            sb.append("RELAXED,");
        } else {
            sb.append("STRICT,");
        }
        if (this.disabledAccepted) {
            sb.append(" Disabled accepted] :\n");
        } else {
            sb.append(" Disabled forbidden] :\n");
        }
        sb.append("loaded schemas [");
        boolean isFirst = true;
        for (String schema : this.loadedSchemas.keySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append(schema);
        }
        sb.append("]\n");
        sb.append("AttributeTypes : ").append(this.attributeTypeRegistry.size()).append("\n");
        sb.append("Comparators : ").append(this.comparatorRegistry.size()).append("\n");
        sb.append("DitContentRules : ").append(this.ditContentRuleRegistry.size()).append("\n");
        sb.append("DitStructureRules : ").append(this.ditStructureRuleRegistry.size()).append("\n");
        sb.append("MatchingRules : ").append(this.matchingRuleRegistry.size()).append("\n");
        sb.append("MatchingRuleUses : ").append(this.matchingRuleUseRegistry.size()).append("\n");
        sb.append("NameForms : ").append(this.nameFormRegistry.size()).append("\n");
        sb.append("Normalizers : ").append(this.normalizerRegistry.size()).append("\n");
        sb.append("ObjectClasses : ").append(this.objectClassRegistry.size()).append("\n");
        sb.append("Syntaxes : ").append(this.ldapSyntaxRegistry.size()).append("\n");
        sb.append("SyntaxCheckers : ").append(this.syntaxCheckerRegistry.size()).append("\n");
        sb.append("GlobalOidRegistry : ").append(this.globalOidRegistry.size()).append('\n');
        return sb.toString();
    }
}

