/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.extended.ads_impl.cancel;

import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.Asn1Object;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.ExtendedRequestDecorator;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.extras.extended.ads_impl.cancel.CancelDecoder;
import org.apache.directory.api.ldap.extras.extended.cancel.CancelRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CancelRequestDecorator
extends ExtendedRequestDecorator<CancelRequest>
implements CancelRequest,
Asn1Object {
    private static final Logger LOG = LoggerFactory.getLogger(CancelRequestDecorator.class);
    private CancelRequest cancelRequest;
    private int cancelSequenceLength;

    public CancelRequestDecorator(LdapApiService codec, CancelRequest decoratedMessage) {
        super(codec, decoratedMessage);
        this.cancelRequest = decoratedMessage;
    }

    @Override
    public int getCancelId() {
        return this.cancelRequest.getCancelId();
    }

    @Override
    public void setCancelId(int cancelId) {
        if (cancelId == this.cancelRequest.getCancelId()) {
            return;
        }
        this.requestValue = null;
        this.cancelRequest.setCancelId(cancelId);
    }

    @Override
    public byte[] getRequestValue() {
        if (this.requestValue == null) {
            try {
                this.requestValue = this.encodeInternal().array();
            }
            catch (EncoderException e) {
                LOG.error(I18n.err(I18n.ERR_04164, new Object[0]), e);
                throw new RuntimeException(e);
            }
        }
        return this.requestValue;
    }

    @Override
    public void setRequestValue(byte[] requestValue) {
        CancelDecoder decoder = new CancelDecoder();
        try {
            CancelRequest cancel = decoder.decode(requestValue);
            if (requestValue != null) {
                this.requestValue = new byte[requestValue.length];
                System.arraycopy(requestValue, 0, this.requestValue, 0, requestValue.length);
            } else {
                this.requestValue = null;
            }
            this.cancelRequest.setCancelId(cancel.getCancelId());
        }
        catch (DecoderException e) {
            LOG.error(I18n.err(I18n.ERR_04165, new Object[0]), e);
            throw new RuntimeException(e);
        }
    }

    int computeLengthInternal() {
        this.cancelSequenceLength = 2 + BerValue.getNbBytes(this.cancelRequest.getCancelId());
        return 2 + this.cancelSequenceLength;
    }

    ByteBuffer encodeInternal() throws EncoderException {
        ByteBuffer bb = ByteBuffer.allocate(this.computeLengthInternal());
        bb.put(UniversalTag.SEQUENCE.getValue());
        bb.put(TLV.getBytes(this.cancelSequenceLength));
        BerValue.encode(bb, this.cancelRequest.getCancelId());
        return bb;
    }
}

