/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import java.io.IOException;
import jdbm.helper.Serializer;
import org.apache.directory.api.util.Strings;

public class StringSerializer
implements Serializer {
    private static final long serialVersionUID = -173163945773783649L;
    public static StringSerializer INSTANCE = new StringSerializer();

    private StringSerializer() {
    }

    @Override
    public Object deserialize(byte[] bytes) throws IOException {
        if (bytes.length == 0) {
            return "";
        }
        char[] strchars = new char[bytes.length >> 1];
        int pos = 0;
        for (int i = 0; i < bytes.length; i += 2) {
            strchars[pos++] = (char)(bytes[i] << 8 & 0xFF00 | bytes[i + 1] & 0xFF);
        }
        return new String(strchars);
    }

    @Override
    public byte[] serialize(Object str) throws IOException {
        if (((String)str).length() == 0) {
            return Strings.EMPTY_BYTES;
        }
        char[] strchars = ((String)str).toCharArray();
        byte[] bites = new byte[strchars.length << 1];
        int pos = 0;
        for (char c : strchars) {
            bites[pos++] = (byte)(c >> 8 & 0xFF);
            bites[pos++] = (byte)(c & 0xFF);
        }
        return bites;
    }
}

