/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import java.io.IOException;
import jdbm.btree.BTree;
import org.apache.directory.api.ldap.model.constants.Loggers;
import org.apache.directory.api.ldap.model.cursor.AbstractCursor;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.api.ldap.model.cursor.Tuple;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.server.core.avltree.ArrayTree;
import org.apache.directory.server.core.avltree.ArrayTreeCursor;
import org.apache.directory.server.core.partition.impl.btree.jdbm.DupsContainer;
import org.apache.directory.server.core.partition.impl.btree.jdbm.DupsContainerCursor;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmTable;
import org.apache.directory.server.core.partition.impl.btree.jdbm.KeyBTreeCursor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DupsCursor<K, V>
extends AbstractCursor<Tuple<K, V>> {
    private static final Logger LOG = LoggerFactory.getLogger(DupsCursor.class);
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger(Loggers.CURSOR_LOG.getName());
    private static final boolean IS_DEBUG = LOG_CURSOR.isDebugEnabled();
    private final JdbmTable<K, V> table;
    private final DupsContainerCursor<K, V> containerCursor;
    private final Tuple<K, DupsContainer<V>> containerTuple = new Tuple();
    private Cursor<V> dupsCursor;
    private final Tuple<K, V> returnedTuple = new Tuple();
    private boolean valueAvailable;

    public DupsCursor(JdbmTable<K, V> table) {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Creating DupsCursor {}", (Object)this);
        }
        this.table = table;
        this.containerCursor = new DupsContainerCursor<K, V>(table);
        LOG.debug("Created on table {}", (Object)table);
    }

    @Override
    public boolean available() {
        return this.valueAvailable;
    }

    public void beforeKey(K key) throws Exception {
        this.beforeValue(key, null);
    }

    public void beforeValue(K key, V value) throws LdapException, CursorException, IOException {
        this.checkNotClosed("beforeValue()");
        this.containerCursor.before(new Tuple<K, Object>(key, null));
        if (this.containerCursor.next()) {
            this.containerTuple.setBoth((Tuple<K, DupsContainer<V>>)this.containerCursor.get());
            DupsContainer<V> values = this.containerTuple.getValue();
            if (values.isArrayTree()) {
                ArrayTree<V> set = values.getArrayTree();
                this.dupsCursor = new ArrayTreeCursor<V>(set);
            } else {
                BTree tree = this.table.getBTree(values.getBTreeRedirect());
                this.dupsCursor = new KeyBTreeCursor(tree, this.table.getValueComparator());
            }
            if (value == null) {
                return;
            }
            if (this.table.getKeyComparator().compare(this.containerTuple.getKey(), key) == 0) {
                this.dupsCursor.before(value);
            }
            return;
        }
        this.clearValue();
        this.containerTuple.setKey(null);
        this.containerTuple.setValue(null);
    }

    public void afterKey(K key) throws Exception {
        this.afterValue(key, null);
    }

    public void afterValue(K key, V value) throws LdapException, CursorException, IOException {
        this.checkNotClosed("afterValue()");
        if (value == null) {
            this.containerCursor.after(new Tuple<K, Object>(key, null));
        } else {
            this.containerCursor.before(new Tuple<K, Object>(key, null));
        }
        if (this.containerCursor.next()) {
            this.containerTuple.setBoth((Tuple<K, DupsContainer<V>>)this.containerCursor.get());
            DupsContainer<V> values = this.containerTuple.getValue();
            if (values.isArrayTree()) {
                ArrayTree<V> set = values.getArrayTree();
                this.dupsCursor = new ArrayTreeCursor<V>(set);
            } else {
                BTree tree = this.table.getBTree(values.getBTreeRedirect());
                this.dupsCursor = new KeyBTreeCursor(tree, this.table.getValueComparator());
            }
            if (value == null) {
                return;
            }
            if (this.table.getKeyComparator().compare(this.containerTuple.getKey(), key) == 0) {
                this.dupsCursor.after(value);
            }
            return;
        }
        this.clearValue();
        this.containerTuple.setKey(null);
        this.containerTuple.setValue(null);
    }

    @Override
    public void before(Tuple<K, V> element) throws LdapException, CursorException, IOException {
        this.beforeValue(element.getKey(), element.getValue());
    }

    @Override
    public void after(Tuple<K, V> element) throws LdapException, CursorException, IOException {
        this.afterValue(element.getKey(), element.getValue());
    }

    @Override
    public void beforeFirst() throws LdapException, CursorException, IOException {
        this.checkNotClosed("beforeFirst()");
        this.clearValue();
        this.containerCursor.beforeFirst();
        this.containerTuple.setKey(null);
        this.containerTuple.setValue(null);
        this.dupsCursor = null;
    }

    @Override
    public void afterLast() throws LdapException, CursorException, IOException {
        this.checkNotClosed("afterLast()");
        this.clearValue();
        this.containerCursor.afterLast();
        this.containerTuple.setKey(null);
        this.containerTuple.setValue(null);
        this.dupsCursor = null;
    }

    @Override
    public boolean first() throws LdapException, CursorException, IOException {
        this.checkNotClosed("first()");
        this.clearValue();
        this.dupsCursor = null;
        if (this.containerCursor.first()) {
            this.containerTuple.setBoth((Tuple<K, DupsContainer<V>>)this.containerCursor.get());
            DupsContainer<V> values = this.containerTuple.getValue();
            if (this.containerTuple.getValue().isArrayTree()) {
                this.dupsCursor = new ArrayTreeCursor<V>(values.getArrayTree());
            } else {
                BTree bt = this.table.getBTree(values.getBTreeRedirect());
                this.dupsCursor = new KeyBTreeCursor(bt, this.table.getValueComparator());
            }
            this.dupsCursor.first();
            this.valueAvailable = true;
            this.returnedTuple.setKey(this.containerTuple.getKey());
            this.returnedTuple.setValue(this.dupsCursor.get());
            return true;
        }
        return false;
    }

    @Override
    public boolean last() throws LdapException, CursorException, IOException {
        this.checkNotClosed("last()");
        this.clearValue();
        this.dupsCursor = null;
        if (this.containerCursor.last()) {
            this.containerTuple.setBoth((Tuple<K, DupsContainer<V>>)this.containerCursor.get());
            DupsContainer<V> values = this.containerTuple.getValue();
            if (values.isArrayTree()) {
                ArrayTree<V> set = values.getArrayTree();
                this.dupsCursor = new ArrayTreeCursor<V>(set);
            } else {
                BTree tree = this.table.getBTree(values.getBTreeRedirect());
                this.dupsCursor = new KeyBTreeCursor(tree, this.table.getValueComparator());
            }
            this.dupsCursor.last();
            this.valueAvailable = true;
            this.returnedTuple.setKey(this.containerTuple.getKey());
            this.returnedTuple.setValue(this.dupsCursor.get());
            return true;
        }
        return false;
    }

    private void clearValue() {
        this.returnedTuple.setKey(null);
        this.returnedTuple.setValue(null);
        this.valueAvailable = false;
    }

    @Override
    public boolean previous() throws LdapException, CursorException, IOException {
        this.checkNotClosed("previous()");
        if (null == this.dupsCursor || !this.dupsCursor.previous()) {
            if (this.dupsCursor != null) {
                this.dupsCursor.close();
            }
            if (this.containerCursor.previous()) {
                this.containerTuple.setBoth((Tuple<K, DupsContainer<V>>)this.containerCursor.get());
                DupsContainer<V> values = this.containerTuple.getValue();
                if (values.isArrayTree()) {
                    ArrayTree<V> set = values.getArrayTree();
                    this.dupsCursor = new ArrayTreeCursor<V>(set);
                } else {
                    BTree tree = this.table.getBTree(values.getBTreeRedirect());
                    this.dupsCursor = new KeyBTreeCursor(tree, this.table.getValueComparator());
                }
                this.dupsCursor.afterLast();
                this.dupsCursor.previous();
            } else {
                this.dupsCursor = null;
                return false;
            }
        }
        this.returnedTuple.setKey(this.containerTuple.getKey());
        this.returnedTuple.setValue(this.dupsCursor.get());
        this.valueAvailable = true;
        return true;
    }

    @Override
    public boolean next() throws LdapException, CursorException, IOException {
        this.checkNotClosed("next()");
        if (null == this.dupsCursor || !this.dupsCursor.next()) {
            if (this.dupsCursor != null) {
                this.dupsCursor.close();
            }
            if (this.containerCursor.next()) {
                this.containerTuple.setBoth((Tuple<K, DupsContainer<V>>)this.containerCursor.get());
                DupsContainer<V> values = this.containerTuple.getValue();
                if (values.isArrayTree()) {
                    ArrayTree<V> set = values.getArrayTree();
                    this.dupsCursor = new ArrayTreeCursor<V>(set);
                } else {
                    BTree tree = this.table.getBTree(values.getBTreeRedirect());
                    this.dupsCursor = new KeyBTreeCursor(tree, this.table.getValueComparator());
                }
                this.dupsCursor.beforeFirst();
                this.dupsCursor.next();
            } else {
                this.dupsCursor = null;
                return false;
            }
        }
        this.returnedTuple.setKey(this.containerTuple.getKey());
        this.returnedTuple.setValue(this.dupsCursor.get());
        this.valueAvailable = true;
        return true;
    }

    @Override
    public Tuple<K, V> get() throws CursorException, IOException {
        this.checkNotClosed("get()");
        if (!this.valueAvailable) {
            throw new InvalidCursorPositionException();
        }
        return this.returnedTuple;
    }

    @Override
    public void close() {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing DupsCursor {}", (Object)this);
        }
        super.close();
        this.containerCursor.close();
        if (this.dupsCursor != null) {
            this.dupsCursor.close();
        }
    }

    @Override
    public void close(Exception cause) {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing DupsCursor {}", (Object)this);
        }
        super.close(cause);
        this.containerCursor.close(cause);
        if (this.dupsCursor != null) {
            this.dupsCursor.close(cause);
        }
    }
}

