/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.ssl;

import java.security.SecureRandom;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.ldap.client.api.NoVerificationTrustManager;
import org.apache.directory.server.i18n.I18n;
import org.apache.mina.core.filterchain.DefaultIoFilterChainBuilder;
import org.apache.mina.core.filterchain.IoFilterChainBuilder;
import org.apache.mina.filter.ssl.SslFilter;

public class LdapsInitializer {
    public static IoFilterChainBuilder init(KeyManagerFactory kmf) throws LdapException {
        SSLContext sslCtx;
        try {
            sslCtx = SSLContext.getInstance("TLS");
            sslCtx.init(kmf.getKeyManagers(), new TrustManager[]{new NoVerificationTrustManager()}, new SecureRandom());
        }
        catch (Exception e) {
            throw new LdapException(I18n.err(I18n.ERR_683, new Object[0]), e);
        }
        DefaultIoFilterChainBuilder chain = new DefaultIoFilterChainBuilder();
        SslFilter sslFilter = new SslFilter(sslCtx);
        sslFilter.setWantClientAuth(true);
        chain.addLast("sslFilter", sslFilter);
        return chain;
    }
}

