/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.util.exception;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeMultiException
extends RuntimeException {
    private static final long serialVersionUID = 8582253398936366771L;
    private Collection<Throwable> nestedExceptions = new ArrayList<Throwable>();

    public RuntimeMultiException() {
    }

    public RuntimeMultiException(String message) {
        super(message);
    }

    public RuntimeMultiException(String message, Throwable t) {
        super(message);
        this.nestedExceptions.add(t);
    }

    public Iterator<Throwable> listNestedExceptions() {
        return this.nestedExceptions.iterator();
    }

    public int size() {
        return this.nestedExceptions.size();
    }

    public boolean isEmpty() {
        return this.nestedExceptions.isEmpty();
    }

    public void addThrowable(Throwable nested) {
        this.nestedExceptions.add(nested);
    }

    @Override
    public void printStackTrace(PrintWriter out) {
        super.printStackTrace(out);
        out.println("Nested exceptions to follow:\n");
        boolean isFirst = true;
        for (Throwable throwable : this.nestedExceptions) {
            if (isFirst) {
                isFirst = false;
            } else {
                out.println("\n\t<<========= Next Nested Exception ========>>\n");
            }
            throwable.printStackTrace();
        }
        out.println("\n\t<<========= Last Nested Exception ========>>\n");
    }

    @Override
    public void printStackTrace(PrintStream out) {
        super.printStackTrace(out);
        out.println("Nested exceptions to follow:\n");
        boolean isFirst = true;
        for (Throwable throwable : this.nestedExceptions) {
            if (isFirst) {
                isFirst = false;
            } else {
                out.println("\n\t<<========= Next Nested Exception ========>>\n");
            }
            throwable.printStackTrace();
        }
        out.println("\n\t<<========= Last Nested Exception ========>>\n");
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }
}

