/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.util;

import java.io.Externalizable;
import org.apache.directory.api.util.SequencedHashMap;

public final class SynchronizedLRUMap
extends SequencedHashMap
implements Externalizable {
    private static final long serialVersionUID = 2197433140769957051L;
    private int maximumSize = 0;

    public SynchronizedLRUMap() {
        this(100);
    }

    public SynchronizedLRUMap(int i) {
        super(i);
        this.maximumSize = i;
    }

    public synchronized Object get(Object key) {
        if (!this.containsKey(key)) {
            return null;
        }
        Object value = this.remove(key);
        super.put(key, value);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object key, Object value) {
        int mapSize = this.size();
        Object retval = null;
        if (mapSize >= this.maximumSize) {
            SynchronizedLRUMap synchronizedLRUMap = this;
            synchronized (synchronizedLRUMap) {
                if (!this.containsKey(key)) {
                    this.removeLRU();
                }
                retval = super.put(key, value);
            }
        }
        SynchronizedLRUMap synchronizedLRUMap = this;
        synchronized (synchronizedLRUMap) {
            retval = super.put(key, value);
        }
        return retval;
    }

    private void removeLRU() {
        Object key = this.getFirstKey();
        super.get(key);
        this.remove(key);
    }

    public int getMaximumSize() {
        return this.maximumSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaximumSize(int maximumSize) {
        SynchronizedLRUMap synchronizedLRUMap = this;
        synchronized (synchronizedLRUMap) {
            this.maximumSize = maximumSize;
            while (this.size() > maximumSize) {
                this.removeLRU();
            }
        }
    }
}

