/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.directory.api.util.Strings;
import org.apache.directory.api.util.exception.NotImplementedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertiesUtils {
    private static final String DOTPROPERTIES = ".properties";

    private PropertiesUtils() {
    }

    public static Properties findUserProperties(String filename) {
        return PropertiesUtils.findProperties(new File(System.getProperty("user.home")), filename);
    }

    public static Properties findProperties(File dir, String filename) {
        File asis = new File(dir, filename);
        if (asis.exists()) {
            return PropertiesUtils.getProperties(asis);
        }
        if (filename.endsWith(DOTPROPERTIES)) {
            String noExt = filename.substring(0, filename.length() - 11);
            if (new File(dir, noExt).exists()) {
                return PropertiesUtils.getProperties(new File(dir, noExt));
            }
            return new Properties();
        }
        File withExt = new File(dir, filename + DOTPROPERTIES);
        if (withExt.exists()) {
            return PropertiesUtils.getProperties(withExt);
        }
        return new Properties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getStaticProperties(Class<?> ref) {
        Properties properties = new Properties();
        String address = ref.toString().replace('.', '/');
        String path = address + DOTPROPERTIES;
        InputStream input = ref.getResourceAsStream(path);
        if (null != input) {
            try {
                properties.load(input);
            }
            catch (IOException e) {
                Properties properties2 = properties;
                return properties2;
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getStaticProperties(Class<?> ref, String path) {
        Properties properties = new Properties();
        InputStream input = ref.getResourceAsStream(path);
        if (input == null) {
            return properties;
        }
        try {
            properties.load(input);
        }
        catch (IOException e) {
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {}
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties(File file) {
        Properties properties = new Properties();
        if (null == file) {
            return properties;
        }
        if (file.exists()) {
            try {
                FileInputStream fis = new FileInputStream(file);
                try {
                    properties.load(fis);
                }
                finally {
                    fis.close();
                }
            }
            catch (IOException e) {
                return properties;
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties(ClassLoader classloader, String path) {
        Properties properties = new Properties();
        InputStream input = classloader.getResourceAsStream(path);
        if (input != null) {
            try {
                properties.load(input);
            }
            catch (IOException e) {
                Properties properties2 = properties;
                return properties2;
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties(Class<?> clazz, String path) {
        Properties properties = new Properties();
        InputStream input = clazz.getResourceAsStream(path);
        if (input != null) {
            try {
                properties.load(input);
            }
            catch (IOException e) {
                Properties properties2 = properties;
                return properties2;
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return properties;
    }

    public static void macroExpand(Properties expanded, Properties[] optionals) {
        if (null == optionals) {
            optionals = new Properties[]{};
        }
        Enumeration<?> list = expanded.propertyNames();
        block0: while (list.hasMoreElements()) {
            int m;
            String key = (String)list.nextElement();
            String macro = expanded.getProperty(key);
            int n = macro.indexOf("${");
            if (n < 0 || (m = macro.indexOf("}", n + 2)) < 0) continue;
            String symbol = macro.substring(n + 2, m);
            if (expanded.containsKey(symbol)) {
                String value = expanded.getProperty(symbol);
                String head = macro.substring(0, n);
                String tail = macro.substring(m + 1);
                String resolved = head + value + tail;
                expanded.put(key, resolved);
                continue;
            }
            for (int ii = 0; ii < optionals.length; ++ii) {
                if (!optionals[ii].containsKey(symbol)) continue;
                String value = optionals[ii].getProperty(symbol);
                String head = macro.substring(0, n);
                String tail = macro.substring(m + 1);
                String resolved = head + value + tail;
                expanded.put(key, resolved);
                continue block0;
            }
        }
    }

    public static String discover(String key, Properties[] sources, boolean haltOnDiscovery) {
        String retval = null;
        for (int ii = 0; ii < sources.length; ++ii) {
            if (!sources[ii].containsKey(key)) continue;
            retval = sources[ii].getProperty(key);
            if (haltOnDiscovery) break;
        }
        return retval;
    }

    public static void discover(Properties keys, Properties[] sources, boolean haltOnDiscovery) {
        if (null == sources || null == keys) {
            return;
        }
        for (Object key : keys.keySet()) {
            String value = PropertiesUtils.discover((String)key, sources, haltOnDiscovery);
            if (value == null) continue;
            keys.setProperty((String)key, value);
        }
    }

    public static boolean get(Properties props, String key, boolean defaultValue) {
        if (props == null || !props.containsKey(key) || props.getProperty(key) == null) {
            return defaultValue;
        }
        String val = Strings.toLowerCase(Strings.trim(props.getProperty(key)));
        return val.equals("true") || val.equals("on") || val.equals("1") || val.equals("yes");
    }

    public static int get(Hashtable<String, Object> ht, Object key, int defval) {
        if (ht == null || !ht.containsKey(key) || ht.get(key) == null) {
            return defval;
        }
        Object obj = ht.get(key);
        if (obj instanceof Byte) {
            return ((Byte)obj).intValue();
        }
        if (obj instanceof Short) {
            return ((Short)obj).intValue();
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        if (obj instanceof Long) {
            return ((Long)obj).intValue();
        }
        if (obj instanceof String) {
            try {
                return Integer.parseInt((String)obj);
            }
            catch (NumberFormatException ne) {
                ne.printStackTrace();
                return defval;
            }
        }
        return defval;
    }

    public static long get(Properties props, String key, long defaultValue) {
        if (props == null || !props.containsKey(key) || props.getProperty(key) == null) {
            return defaultValue;
        }
        throw new NotImplementedException();
    }

    public static byte get(Properties props, String key, byte defaultValue) {
        if (props == null || !props.containsKey(key) || props.getProperty(key) == null) {
            return defaultValue;
        }
        throw new NotImplementedException();
    }

    public static char get(Properties props, String key, char defaultValue) {
        if (props == null || !props.containsKey(key) || props.getProperty(key) == null) {
            return defaultValue;
        }
        throw new NotImplementedException();
    }
}

