/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.extended.ads_impl.certGeneration;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.ExtendedRequestDecorator;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.extras.extended.CertGenerationRequest;
import org.apache.directory.api.ldap.extras.extended.CertGenerationResponse;
import org.apache.directory.api.ldap.extras.extended.ads_impl.certGeneration.CertGenerationDecoder;
import org.apache.directory.api.ldap.extras.extended.ads_impl.certGeneration.CertGenerationObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertGenerationRequestDecorator
extends ExtendedRequestDecorator<CertGenerationRequest, CertGenerationResponse>
implements CertGenerationRequest {
    private static final Logger LOG = LoggerFactory.getLogger(CertGenerationRequestDecorator.class);
    private CertGenerationObject certGenObj;

    public CertGenerationRequestDecorator(LdapApiService codec, CertGenerationRequest decoratedMessage) {
        super(codec, decoratedMessage);
        this.certGenObj = new CertGenerationObject(decoratedMessage);
    }

    public CertGenerationObject getCertGenerationObject() {
        return this.certGenObj;
    }

    @Override
    public void setRequestValue(byte[] requestValue) {
        CertGenerationDecoder decoder = new CertGenerationDecoder();
        try {
            this.certGenObj = (CertGenerationObject)decoder.decode(requestValue);
            if (requestValue != null) {
                this.requestValue = new byte[requestValue.length];
                System.arraycopy(requestValue, 0, this.requestValue, 0, requestValue.length);
            } else {
                this.requestValue = null;
            }
        }
        catch (DecoderException e) {
            LOG.error(I18n.err(I18n.ERR_04165, new Object[0]), e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] getRequestValue() {
        if (this.requestValue == null) {
            try {
                this.requestValue = this.certGenObj.encode().array();
            }
            catch (EncoderException e) {
                LOG.error(I18n.err(I18n.ERR_04167, new Object[0]), e);
                throw new RuntimeException(e);
            }
        }
        if (this.requestValue == null) {
            return null;
        }
        byte[] copy = new byte[this.requestValue.length];
        System.arraycopy(this.requestValue, 0, copy, 0, this.requestValue.length);
        return copy;
    }

    @Override
    public CertGenerationResponse getResultResponse() {
        return (CertGenerationResponse)((CertGenerationRequest)this.getDecorated()).getResultResponse();
    }

    @Override
    public String getTargetDN() {
        return ((CertGenerationRequest)this.getDecorated()).getTargetDN();
    }

    @Override
    public void setTargetDN(String targetDN) {
        ((CertGenerationRequest)this.getDecorated()).setTargetDN(targetDN);
    }

    @Override
    public String getIssuerDN() {
        return ((CertGenerationRequest)this.getDecorated()).getIssuerDN();
    }

    @Override
    public void setIssuerDN(String issuerDN) {
        ((CertGenerationRequest)this.getDecorated()).setIssuerDN(issuerDN);
    }

    @Override
    public String getSubjectDN() {
        return ((CertGenerationRequest)this.getDecorated()).getSubjectDN();
    }

    @Override
    public void setSubjectDN(String subjectDN) {
        ((CertGenerationRequest)this.getDecorated()).setSubjectDN(subjectDN);
    }

    @Override
    public String getKeyAlgorithm() {
        return ((CertGenerationRequest)this.getDecorated()).getKeyAlgorithm();
    }

    @Override
    public void setKeyAlgorithm(String keyAlgorithm) {
        ((CertGenerationRequest)this.getDecorated()).setKeyAlgorithm(keyAlgorithm);
    }
}

