/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.extended;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.ArrayList;
import java.util.List;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoder;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoderException;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.extras.extended.StoredProcedureParameter;
import org.apache.directory.api.ldap.extras.extended.StoredProcedureRequest;
import org.apache.directory.api.ldap.extras.extended.StoredProcedureResponse;
import org.apache.directory.api.ldap.extras.extended.StoredProcedureResponseImpl;
import org.apache.directory.api.ldap.model.message.AbstractExtendedRequest;
import org.apache.directory.api.util.StringConstants;
import org.apache.directory.api.util.Strings;
import org.apache.directory.api.util.exception.NotImplementedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoredProcedureRequestImpl
extends AbstractExtendedRequest<StoredProcedureResponse>
implements StoredProcedureRequest {
    private static final long serialVersionUID = -4682291068700593492L;
    private String language = "Java";
    private byte[] procedure = StringConstants.EMPTY_BYTES;
    private List<StoredProcedureParameter> parameters = new ArrayList<StoredProcedureParameter>();
    private StoredProcedureResponse response;

    public StoredProcedureRequestImpl(int messageId) {
        super(messageId);
        this.setRequestName("1.3.6.1.4.1.18060.0.1.6");
    }

    public StoredProcedureRequestImpl() {
        this.setRequestName("1.3.6.1.4.1.18060.0.1.6");
    }

    public StoredProcedureRequestImpl(int messageId, String procedure, String language) {
        super(messageId);
        this.setRequestName("1.3.6.1.4.1.18060.0.1.6");
        this.language = language;
        this.procedure = Strings.getBytesUtf8(procedure);
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public void setLanguage(String language) {
        this.language = language;
    }

    @Override
    public byte[] getProcedure() {
        if (this.procedure == null) {
            return null;
        }
        byte[] copy = new byte[this.procedure.length];
        System.arraycopy(this.procedure, 0, copy, 0, this.procedure.length);
        return copy;
    }

    @Override
    public void setProcedure(byte[] procedure) {
        if (procedure != null) {
            this.procedure = new byte[procedure.length];
            System.arraycopy(procedure, 0, this.procedure, 0, procedure.length);
        } else {
            this.procedure = null;
        }
    }

    @Override
    public List<StoredProcedureParameter> getParameters() {
        return this.parameters;
    }

    @Override
    public void addParameter(StoredProcedureParameter parameter) {
        this.parameters.add(parameter);
    }

    public void setProcedure(String procedure) {
        this.procedure = Strings.getBytesUtf8(procedure);
    }

    @Override
    public String getProcedureSpecification() {
        return Strings.utf8ToString(this.procedure);
    }

    @Override
    public int size() {
        return this.parameters.size();
    }

    @Override
    public Object getParameterType(int index) {
        if (!this.language.equals("java")) {
            return this.parameters.get(index).getType();
        }
        return this.getJavaParameterType(index);
    }

    @SuppressWarnings(value={"BC_IMPOSSIBLE_INSTANCEOF"}, justification="False positive")
    public Object getParameterTypeString(int index) {
        byte[] obj;
        if (!this.language.equals("java") && (obj = this.parameters.get(index).getType()) instanceof byte[]) {
            return Strings.utf8ToString(obj);
        }
        return this.getJavaParameterType(index);
    }

    @Override
    public Class<?> getJavaParameterType(int index) {
        throw new NotImplementedException(I18n.err(I18n.ERR_04175, new Object[0]));
    }

    @Override
    public Object getParameterValue(int index) {
        if (!this.language.equals("java")) {
            return this.parameters.get(index).getValue();
        }
        return this.getJavaParameterValue(index);
    }

    @SuppressWarnings(value={"BC_IMPOSSIBLE_INSTANCEOF"}, justification="False positive")
    public Object getParameterValueString(int index) {
        byte[] obj;
        if (!this.language.equals("java") && (obj = this.parameters.get(index).getValue()) instanceof byte[]) {
            String str = Strings.utf8ToString(obj);
            String type = (String)this.getParameterTypeString(index);
            if (type.equals("int")) {
                try {
                    return IntegerDecoder.parse(new BerValue(obj));
                }
                catch (IntegerDecoderException e) {
                    throw new RuntimeException("Failed to decode INTEGER: " + Strings.dumpBytes(obj), e);
                }
            }
            return str;
        }
        return this.getJavaParameterValue(index);
    }

    @Override
    public Object getJavaParameterValue(int index) {
        throw new NotImplementedException(I18n.err(I18n.ERR_04176, new Object[0]));
    }

    @Override
    public void addParameter(Object type, Object value) {
        StoredProcedureParameter parameter = new StoredProcedureParameter();
        parameter.setType((byte[])type);
        parameter.setValue((byte[])value);
        this.parameters.add(parameter);
    }

    @Override
    public StoredProcedureResponse getResultResponse() {
        if (this.response == null) {
            StoredProcedureResponseImpl spr = new StoredProcedureResponseImpl(this.getMessageId());
            spr.setResponseName("1.3.6.1.4.1.18060.0.1.6");
            this.response = spr;
        }
        return this.response;
    }
}

