/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.jndi;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.spi.InitialContextFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.server.changepw.ChangePasswordConfiguration;
import org.apache.directory.server.changepw.ChangePasswordServer;
import org.apache.directory.server.configuration.ServerStartupConfiguration;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.jndi.CoreContextFactory;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.dns.DnsConfiguration;
import org.apache.directory.server.dns.DnsServer;
import org.apache.directory.server.dns.store.RecordStore;
import org.apache.directory.server.dns.store.jndi.JndiRecordStoreImpl;
import org.apache.directory.server.kerberos.kdc.KdcConfiguration;
import org.apache.directory.server.kerberos.kdc.KerberosServer;
import org.apache.directory.server.kerberos.shared.store.JndiPrincipalStoreImpl;
import org.apache.directory.server.kerberos.shared.store.PrincipalStore;
import org.apache.directory.server.ldap.ExtendedOperationHandler;
import org.apache.directory.server.ldap.LdapConfiguration;
import org.apache.directory.server.ldap.LdapProtocolProvider;
import org.apache.directory.server.ldap.support.ssl.LdapsInitializer;
import org.apache.directory.server.ntp.NtpConfiguration;
import org.apache.directory.server.ntp.NtpServer;
import org.apache.directory.server.protocol.shared.ServiceConfiguration;
import org.apache.directory.server.protocol.shared.store.LdifFileLoader;
import org.apache.directory.shared.ldap.exception.LdapConfigurationException;
import org.apache.directory.shared.ldap.exception.LdapNamingException;
import org.apache.directory.shared.ldap.message.AttributesImpl;
import org.apache.directory.shared.ldap.message.extended.NoticeOfDisconnect;
import org.apache.directory.shared.ldap.util.StringTools;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.ByteBufferAllocator;
import org.apache.mina.common.DefaultIoFilterChainBuilder;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterChainBuilder;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.SimpleByteBufferAllocator;
import org.apache.mina.common.ThreadModel;
import org.apache.mina.common.WriteFuture;
import org.apache.mina.filter.executor.ExecutorFilter;
import org.apache.mina.transport.socket.nio.DatagramAcceptor;
import org.apache.mina.transport.socket.nio.DatagramAcceptorConfig;
import org.apache.mina.transport.socket.nio.SocketAcceptor;
import org.apache.mina.transport.socket.nio.SocketAcceptorConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerContextFactory
extends CoreContextFactory {
    private static final Logger log = LoggerFactory.getLogger((String)ServerContextFactory.class.getName());
    private static final String LDIF_FILES_DN = "ou=loadedLdifFiles,ou=configuration,ou=system";
    private DirectoryService directoryService;
    private static final Map<DirectoryService, DirectoryServiceContext> contexts = Collections.synchronizedMap(new IdentityHashMap());
    private static final String WINDOWSFILE_ATTR = "windowsFilePath";
    private static final String UNIXFILE_ATTR = "unixFilePath";
    private static final String WINDOWSFILE_OC = "windowsFile";
    private static final String UNIXFILE_OC = "unixFile";

    public void beforeStartup(DirectoryService service) {
        ByteBuffer.setAllocator((ByteBufferAllocator)new SimpleByteBufferAllocator());
        ByteBuffer.setUseDirectBuffers((boolean)false);
        DirectoryServiceContext dsc = new DirectoryServiceContext();
        contexts.put(service, dsc);
        int maxThreads = service.getConfiguration().getStartupConfiguration().getMaxThreads();
        dsc.ioExecutor = Executors.newCachedThreadPool();
        dsc.logicExecutor = Executors.newFixedThreadPool(maxThreads);
        dsc.udpAcceptor = new DatagramAcceptor();
        dsc.udpAcceptor.getFilterChain().addLast("executor", (IoFilter)new ExecutorFilter((Executor)dsc.logicExecutor));
        dsc.tcpAcceptor = new SocketAcceptor(Runtime.getRuntime().availableProcessors(), (Executor)dsc.ioExecutor);
        dsc.tcpAcceptor.getFilterChain().addLast("executor", (IoFilter)new ExecutorFilter((Executor)dsc.logicExecutor));
        this.directoryService = service;
    }

    public void afterShutdown(DirectoryService service) {
        ServerStartupConfiguration cfg = (ServerStartupConfiguration)service.getConfiguration().getStartupConfiguration();
        DirectoryServiceContext dsc = contexts.remove(service);
        LdapConfiguration ldapCfg = cfg.getLdapConfiguration();
        LdapConfiguration ldapsCfg = cfg.getLdapsConfiguration();
        if (dsc.ldapStarted) {
            this.stopLDAP0(dsc, ldapCfg.getIpPort());
            dsc.ldapStarted = false;
        }
        if (dsc.ldapsStarted) {
            this.stopLDAP0(dsc, ldapsCfg.getIpPort());
            dsc.ldapsStarted = false;
        }
        if (dsc.tcpKdcServer != null) {
            dsc.tcpKdcServer.destroy();
            if (log.isInfoEnabled()) {
                log.info("Unbind of KRB5 Service (TCP) complete: " + dsc.tcpKdcServer);
            }
            dsc.tcpKdcServer = null;
        }
        if (dsc.udpKdcServer != null) {
            dsc.udpKdcServer.destroy();
            if (log.isInfoEnabled()) {
                log.info("Unbind of KRB5 Service (UDP) complete: " + dsc.udpKdcServer);
            }
            dsc.udpKdcServer = null;
        }
        if (dsc.tcpChangePasswordServer != null) {
            dsc.tcpChangePasswordServer.destroy();
            if (log.isInfoEnabled()) {
                log.info("Unbind of Change Password Service (TCP) complete: " + dsc.tcpChangePasswordServer);
            }
            dsc.tcpChangePasswordServer = null;
        }
        if (dsc.udpChangePasswordServer != null) {
            dsc.udpChangePasswordServer.destroy();
            if (log.isInfoEnabled()) {
                log.info("Unbind of Change Password Service (UDP) complete: " + dsc.udpChangePasswordServer);
            }
            dsc.udpChangePasswordServer = null;
        }
        if (dsc.tcpNtpServer != null) {
            dsc.tcpNtpServer.destroy();
            if (log.isInfoEnabled()) {
                log.info("Unbind of NTP Service (TCP) complete: " + dsc.tcpNtpServer);
            }
            dsc.tcpNtpServer = null;
        }
        if (dsc.udpNtpServer != null) {
            dsc.udpNtpServer.destroy();
            if (log.isInfoEnabled()) {
                log.info("Unbind of NTP Service (UDP) complete: " + dsc.udpNtpServer);
            }
            dsc.udpNtpServer = null;
        }
        if (dsc.tcpDnsServer != null) {
            dsc.tcpDnsServer.destroy();
            if (log.isInfoEnabled()) {
                log.info("Unbind of DNS Service (TCP) complete: " + dsc.tcpDnsServer);
            }
            dsc.tcpDnsServer = null;
        }
        if (dsc.udpDnsServer != null) {
            dsc.udpDnsServer.destroy();
            if (log.isInfoEnabled()) {
                log.info("Unbind of DNS Service (UDP) complete: " + dsc.udpDnsServer);
            }
            dsc.udpDnsServer = null;
        }
        dsc.logicExecutor.shutdown();
        while (true) {
            try {
                while (!dsc.logicExecutor.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS)) {
                }
            }
            catch (InterruptedException e) {
                continue;
            }
            break;
        }
        dsc.ioExecutor.shutdown();
        while (true) {
            try {
                while (!dsc.ioExecutor.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS)) {
                }
            }
            catch (InterruptedException e) {
                continue;
            }
            break;
        }
    }

    public void afterStartup(DirectoryService service) throws NamingException {
        DirectoryServiceContext dsc = contexts.get(service);
        ServerStartupConfiguration cfg = (ServerStartupConfiguration)service.getConfiguration().getStartupConfiguration();
        Hashtable env = service.getConfiguration().getEnvironment();
        LdapConfiguration ldapCfg = cfg.getLdapConfiguration();
        LdapConfiguration ldapsCfg = cfg.getLdapsConfiguration();
        if (!cfg.isAllowAnonymousAccess()) {
            ldapCfg.setAllowAnonymousAccess(false);
            ldapsCfg.setAllowAnonymousAccess(false);
        }
        this.loadLdifs(service);
        if (cfg.isEnableNetworking()) {
            this.startLDAP(dsc, ldapCfg, env);
            this.startLDAPS(dsc, ldapsCfg, env);
            this.startKerberos(dsc, cfg.getKdcConfiguration());
            this.startChangePassword(dsc, cfg.getChangePasswordConfiguration());
            this.startNTP(dsc, cfg.getNtpConfiguration());
            this.startDNS(dsc, cfg.getDnsConfiguration());
        }
    }

    private void ensureLdifFileBase(DirContext root) {
        AttributesImpl entry = new AttributesImpl("ou", (Object)"loadedLdifFiles", true);
        entry.put("objectClass", "top");
        entry.get("objectClass").add("organizationalUnit");
        try {
            root.createSubcontext(LDIF_FILES_DN, (Attributes)entry);
            log.info("Creating ou=loadedLdifFiles,ou=configuration,ou=system");
        }
        catch (NamingException e) {
            log.info("ou=loadedLdifFiles,ou=configuration,ou=system exists");
        }
    }

    private String buildProtectedFileEntry(File ldif) {
        StringBuffer buf = new StringBuffer();
        buf.append(File.separatorChar == '\\' ? WINDOWSFILE_ATTR : UNIXFILE_ATTR);
        buf.append("=");
        buf.append(StringTools.dumpHexPairs((byte[])StringTools.getBytesUtf8((String)this.getCanonical(ldif))));
        buf.append(",");
        buf.append(LDIF_FILES_DN);
        return buf.toString();
    }

    private void addFileEntry(DirContext root, File ldif) throws NamingException {
        String rdnAttr = File.separatorChar == '\\' ? WINDOWSFILE_ATTR : UNIXFILE_ATTR;
        String oc = File.separatorChar == '\\' ? WINDOWSFILE_OC : UNIXFILE_OC;
        AttributesImpl entry = new AttributesImpl(rdnAttr, (Object)this.getCanonical(ldif), true);
        entry.put("objectClass", "top");
        entry.get("objectClass").add(oc);
        root.createSubcontext(this.buildProtectedFileEntry(ldif), (Attributes)entry);
    }

    private Attributes getLdifFileEntry(DirContext root, File ldif) {
        try {
            return root.getAttributes(this.buildProtectedFileEntry(ldif), new String[]{"createTimestamp"});
        }
        catch (NamingException e) {
            return null;
        }
    }

    private String getCanonical(File file) {
        String canonical = null;
        try {
            canonical = file.getCanonicalPath();
        }
        catch (IOException e) {
            log.error("could not get canonical path", (Throwable)e);
            return null;
        }
        return StringUtils.replace((String)canonical, (String)"\\", (String)"\\\\");
    }

    private void loadLdifs(DirectoryService service) throws NamingException {
        ServerStartupConfiguration cfg = (ServerStartupConfiguration)service.getConfiguration().getStartupConfiguration();
        if (cfg.getLdifDirectory() == null) {
            log.info("LDIF load directory not specified.  No LDIF files will be loaded.");
            return;
        }
        if (!cfg.getLdifDirectory().exists()) {
            log.warn("LDIF load directory '" + this.getCanonical(cfg.getLdifDirectory()) + "' does not exist.  No LDIF files will be loaded.");
            return;
        }
        Hashtable env = (Hashtable)service.getConfiguration().getEnvironment().clone();
        env.put("java.naming.provider.url", "");
        DirContext root = (DirContext)this.getInitialContext(env);
        this.ensureLdifFileBase(root);
        if (!cfg.getLdifDirectory().isDirectory()) {
            Attributes fileEntry;
            if (log.isInfoEnabled()) {
                log.info("LDIF load directory '" + this.getCanonical(cfg.getLdifDirectory()) + "' is a file.  Will attempt to load as LDIF.");
            }
            if ((fileEntry = this.getLdifFileEntry(root, cfg.getLdifDirectory())) != null) {
                String time = (String)fileEntry.get("createTimestamp").get();
                if (log.isInfoEnabled()) {
                    log.info("Load of LDIF file '" + this.getCanonical(cfg.getLdifDirectory()) + "' skipped.  It has already been loaded on " + time + ".");
                }
                return;
            }
            LdifFileLoader loader = new LdifFileLoader(root, cfg.getLdifDirectory(), cfg.getLdifFilters());
            loader.execute();
            this.addFileEntry(root, cfg.getLdifDirectory());
            return;
        }
        File[] ldifFiles = cfg.getLdifDirectory().listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                boolean isLdif = pathname.getName().toLowerCase().endsWith(".ldif");
                return pathname.isFile() && pathname.canRead() && isLdif;
            }
        });
        if (ldifFiles == null || ldifFiles.length == 0) {
            log.warn("LDIF load directory '" + this.getCanonical(cfg.getLdifDirectory()) + "' does not contain any LDIF files.  No LDIF files will be loaded.");
            return;
        }
        for (int ii = 0; ii < ldifFiles.length; ++ii) {
            Attributes fileEntry = this.getLdifFileEntry(root, ldifFiles[ii]);
            if (fileEntry != null) {
                String time = (String)fileEntry.get("createTimestamp").get();
                log.info("Load of LDIF file '" + this.getCanonical(ldifFiles[ii]) + "' skipped.  It has already been loaded on " + time + ".");
                continue;
            }
            LdifFileLoader loader = new LdifFileLoader(root, ldifFiles[ii], cfg.getLdifFilters());
            int count = loader.execute();
            log.info("Loaded " + count + " entries from LDIF file '" + this.getCanonical(ldifFiles[ii]) + "'");
            if (fileEntry != null) continue;
            this.addFileEntry(root, ldifFiles[ii]);
        }
    }

    private void startLDAP(DirectoryServiceContext dsc, LdapConfiguration ldapConfig, Hashtable env) throws NamingException {
        if (!ldapConfig.isEnabled()) {
            return;
        }
        DefaultIoFilterChainBuilder chain = new DefaultIoFilterChainBuilder();
        this.startLDAP0(dsc, ldapConfig, env, ldapConfig.getIpPort(), (IoFilterChainBuilder)chain);
    }

    private void startLDAPS(DirectoryServiceContext dsc, LdapConfiguration ldapsConfig, Hashtable env) throws NamingException {
        if (!ldapsConfig.isEnabled() || !ldapsConfig.isEnableLdaps()) {
            return;
        }
        char[] certPasswordChars = ldapsConfig.getLdapsCertificatePassword().toCharArray();
        String storePath = ldapsConfig.getLdapsCertificateFile().getPath();
        IoFilterChainBuilder chain = LdapsInitializer.init((char[])certPasswordChars, (String)storePath);
        dsc.ldapsStarted = true;
        this.startLDAP0(dsc, ldapsConfig, env, ldapsConfig.getIpPort(), chain);
    }

    private void startLDAP0(DirectoryServiceContext dsc, LdapConfiguration ldapConfig, Hashtable env, int port, IoFilterChainBuilder chainBuilder) throws LdapNamingException, LdapConfigurationException {
        LdapProtocolProvider protocolProvider = new LdapProtocolProvider(ldapConfig, (Hashtable)env.clone());
        for (ExtendedOperationHandler h : ldapConfig.getExtendedOperationHandlers()) {
            protocolProvider.addExtendedOperationHandler(h);
            log.info("Added Extended Request Handler: " + h.getOid());
            h.setLdapProvider(protocolProvider);
            PartitionNexus nexus = this.directoryService.getConfiguration().getPartitionNexus();
            nexus.registerSupportedExtensions(h.getExtensionOids());
        }
        try {
            SocketAcceptorConfig acceptorCfg = new SocketAcceptorConfig();
            acceptorCfg.setDisconnectOnUnbind(false);
            acceptorCfg.setReuseAddress(true);
            acceptorCfg.setFilterChainBuilder(chainBuilder);
            acceptorCfg.setThreadModel(ThreadModel.MANUAL);
            acceptorCfg.getSessionConfig().setTcpNoDelay(true);
            dsc.tcpAcceptor.bind((SocketAddress)new InetSocketAddress(port), protocolProvider.getHandler(), (IoServiceConfig)acceptorCfg);
            dsc.ldapStarted = true;
            if (log.isInfoEnabled()) {
                log.info("Successful bind of an LDAP Service (" + port + ") is complete.");
            }
        }
        catch (IOException e) {
            String msg = "Failed to bind an LDAP service (" + port + ") to the service registry.";
            LdapConfigurationException lce = new LdapConfigurationException(msg);
            lce.setRootCause((Throwable)e);
            log.error(msg, (Throwable)e);
            throw lce;
        }
    }

    private void startKerberos(DirectoryServiceContext dsc, KdcConfiguration kdcConfig) {
        if (!kdcConfig.isEnabled()) {
            return;
        }
        try {
            JndiPrincipalStoreImpl kdcStore = new JndiPrincipalStoreImpl((ServiceConfiguration)kdcConfig, (InitialContextFactory)((Object)this));
            DatagramAcceptorConfig udpConfig = new DatagramAcceptorConfig();
            udpConfig.setThreadModel(ThreadModel.MANUAL);
            SocketAcceptorConfig tcpConfig = new SocketAcceptorConfig();
            tcpConfig.setDisconnectOnUnbind(false);
            tcpConfig.setReuseAddress(true);
            tcpConfig.setThreadModel(ThreadModel.MANUAL);
            dsc.tcpKdcServer = new KerberosServer(kdcConfig, dsc.tcpAcceptor, (IoServiceConfig)tcpConfig, (PrincipalStore)kdcStore);
            dsc.udpKdcServer = new KerberosServer(kdcConfig, dsc.udpAcceptor, (IoServiceConfig)udpConfig, (PrincipalStore)kdcStore);
        }
        catch (Throwable t) {
            log.error("Failed to start the Kerberos service", t);
        }
    }

    private void startChangePassword(DirectoryServiceContext dsc, ChangePasswordConfiguration changePasswordConfig) {
        if (!changePasswordConfig.isEnabled()) {
            return;
        }
        try {
            JndiPrincipalStoreImpl store = new JndiPrincipalStoreImpl((ServiceConfiguration)changePasswordConfig, (InitialContextFactory)((Object)this));
            DatagramAcceptorConfig udpConfig = new DatagramAcceptorConfig();
            udpConfig.setThreadModel(ThreadModel.MANUAL);
            SocketAcceptorConfig tcpConfig = new SocketAcceptorConfig();
            tcpConfig.setDisconnectOnUnbind(false);
            tcpConfig.setReuseAddress(true);
            tcpConfig.setThreadModel(ThreadModel.MANUAL);
            dsc.tcpChangePasswordServer = new ChangePasswordServer(changePasswordConfig, dsc.tcpAcceptor, (IoServiceConfig)tcpConfig, (PrincipalStore)store);
            dsc.udpChangePasswordServer = new ChangePasswordServer(changePasswordConfig, dsc.udpAcceptor, (IoServiceConfig)udpConfig, (PrincipalStore)store);
        }
        catch (Throwable t) {
            log.error("Failed to start the Change Password service", t);
        }
    }

    private void startNTP(DirectoryServiceContext dsc, NtpConfiguration ntpConfig) {
        if (!ntpConfig.isEnabled()) {
            return;
        }
        try {
            DatagramAcceptorConfig udpConfig = new DatagramAcceptorConfig();
            udpConfig.setThreadModel(ThreadModel.MANUAL);
            SocketAcceptorConfig tcpConfig = new SocketAcceptorConfig();
            tcpConfig.setDisconnectOnUnbind(false);
            tcpConfig.setReuseAddress(true);
            tcpConfig.setThreadModel(ThreadModel.MANUAL);
            dsc.tcpNtpServer = new NtpServer(ntpConfig, dsc.tcpAcceptor, (IoServiceConfig)tcpConfig);
            dsc.udpNtpServer = new NtpServer(ntpConfig, dsc.udpAcceptor, (IoServiceConfig)udpConfig);
        }
        catch (Throwable t) {
            log.error("Failed to start the NTP service", t);
        }
    }

    private void startDNS(DirectoryServiceContext dsc, DnsConfiguration dnsConfig) {
        if (!dnsConfig.isEnabled()) {
            return;
        }
        try {
            JndiRecordStoreImpl store = new JndiRecordStoreImpl(dnsConfig, (InitialContextFactory)((Object)this));
            DatagramAcceptorConfig udpConfig = new DatagramAcceptorConfig();
            udpConfig.setThreadModel(ThreadModel.MANUAL);
            SocketAcceptorConfig tcpConfig = new SocketAcceptorConfig();
            tcpConfig.setDisconnectOnUnbind(false);
            tcpConfig.setReuseAddress(true);
            tcpConfig.setThreadModel(ThreadModel.MANUAL);
            dsc.tcpDnsServer = new DnsServer(dnsConfig, dsc.tcpAcceptor, (IoServiceConfig)tcpConfig, (RecordStore)store);
            dsc.udpDnsServer = new DnsServer(dnsConfig, dsc.udpAcceptor, (IoServiceConfig)udpConfig, (RecordStore)store);
        }
        catch (Throwable t) {
            log.error("Failed to start the DNS service", t);
        }
    }

    private void stopLDAP0(DirectoryServiceContext dsc, int port) {
        try {
            ArrayList<WriteFuture> writeFutures = new ArrayList<WriteFuture>();
            ArrayList sessions = null;
            try {
                sessions = new ArrayList(dsc.tcpAcceptor.getManagedSessions((SocketAddress)new InetSocketAddress(port)));
            }
            catch (IllegalArgumentException e) {
                log.warn("Seems like the LDAP service (" + port + ") has already been unbound.");
                return;
            }
            dsc.tcpAcceptor.unbind((SocketAddress)new InetSocketAddress(port));
            if (log.isInfoEnabled()) {
                log.info("Unbind of an LDAP service (" + port + ") is complete.");
                log.info("Sending notice of disconnect to existing clients sessions.");
            }
            if (sessions != null) {
                for (IoSession session : sessions) {
                    writeFutures.add(session.write((Object)NoticeOfDisconnect.UNAVAILABLE));
                }
            }
            Iterator sessionIt = sessions.iterator();
            for (WriteFuture future : writeFutures) {
                future.join(1000L);
                ((IoSession)sessionIt.next()).close();
            }
        }
        catch (Exception e) {
            log.warn("Failed to sent NoD.", (Throwable)e);
        }
    }

    private static class DirectoryServiceContext {
        protected IoAcceptor tcpAcceptor;
        protected IoAcceptor udpAcceptor;
        protected ExecutorService ioExecutor;
        protected ExecutorService logicExecutor;
        private boolean ldapStarted;
        private boolean ldapsStarted;
        private KerberosServer tcpKdcServer;
        private KerberosServer udpKdcServer;
        private ChangePasswordServer tcpChangePasswordServer;
        private ChangePasswordServer udpChangePasswordServer;
        private NtpServer tcpNtpServer;
        private NtpServer udpNtpServer;
        private DnsServer tcpDnsServer;
        private DnsServer udpDnsServer;

        private DirectoryServiceContext() {
        }
    }
}

