/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.configuration;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.directory.server.changepw.ChangePasswordConfiguration;
import org.apache.directory.server.core.configuration.StartupConfiguration;
import org.apache.directory.server.dns.DnsConfiguration;
import org.apache.directory.server.kerberos.kdc.KdcConfiguration;
import org.apache.directory.server.ldap.LdapConfiguration;
import org.apache.directory.server.ntp.NtpConfiguration;
import org.apache.directory.server.protocol.shared.store.LdifLoadFilter;

public class ServerStartupConfiguration
extends StartupConfiguration {
    private static final long serialVersionUID = -7138616822614155454L;
    private static final long DEFAULT_SYNC_PERIOD_MILLIS = 20000L;
    private long synchPeriodMillis = 20000L;
    private boolean enableNetworking = true;
    private File ldifDirectory = null;
    private final List ldifFilters = new ArrayList();
    private KdcConfiguration kdcConfiguration = new KdcConfiguration();
    private LdapConfiguration ldapConfiguration = new LdapConfiguration();
    private LdapConfiguration ldapsConfiguration = new LdapConfiguration();
    private ChangePasswordConfiguration changePasswordConfiguration = new ChangePasswordConfiguration();
    private NtpConfiguration ntpConfiguration = new NtpConfiguration();
    private DnsConfiguration dnsConfiguration = new DnsConfiguration();

    protected ServerStartupConfiguration() {
    }

    protected ServerStartupConfiguration(String instanceId) {
        super(instanceId);
    }

    public boolean isEnableNetworking() {
        return this.enableNetworking;
    }

    public void setEnableNetworking(boolean enableNetworking) {
        this.enableNetworking = enableNetworking;
    }

    public File getLdifDirectory() {
        if (this.ldifDirectory == null) {
            return null;
        }
        if (this.ldifDirectory.isAbsolute()) {
            return this.ldifDirectory;
        }
        return new File(this.getWorkingDirectory().getParent(), this.ldifDirectory.toString());
    }

    protected void setLdifDirectory(File ldifDirectory) {
        this.ldifDirectory = ldifDirectory;
    }

    public List getLdifFilters() {
        return new ArrayList(this.ldifFilters);
    }

    protected void setLdifFilters(List filters) {
        for (int ii = 0; ii < filters.size(); ++ii) {
            if (filters.get(ii) instanceof LdifLoadFilter) continue;
            throw new IllegalArgumentException("The specified filter collection contains an element which is not an LdifLoadFilter.");
        }
        this.ldifFilters.clear();
        this.ldifFilters.addAll(filters);
    }

    protected void setSynchPeriodMillis(long synchPeriodMillis) {
        this.synchPeriodMillis = synchPeriodMillis;
    }

    public long getSynchPeriodMillis() {
        return this.synchPeriodMillis;
    }

    protected void setKdcConfiguration(KdcConfiguration kdcConfiguration) {
        this.kdcConfiguration = kdcConfiguration;
    }

    public KdcConfiguration getKdcConfiguration() {
        return this.kdcConfiguration;
    }

    protected void setLdapConfiguration(LdapConfiguration ldapConfiguration) {
        this.ldapConfiguration = ldapConfiguration;
    }

    public LdapConfiguration getLdapConfiguration() {
        return this.ldapConfiguration;
    }

    protected void setLdapsConfiguration(LdapConfiguration ldapsConfiguration) {
        this.ldapsConfiguration = ldapsConfiguration;
    }

    public LdapConfiguration getLdapsConfiguration() {
        return this.ldapsConfiguration;
    }

    protected void setNtpConfiguration(NtpConfiguration ntpConfiguration) {
        this.ntpConfiguration = ntpConfiguration;
    }

    public NtpConfiguration getNtpConfiguration() {
        return this.ntpConfiguration;
    }

    protected void setChangePasswordConfiguration(ChangePasswordConfiguration changePasswordConfiguration) {
        this.changePasswordConfiguration = changePasswordConfiguration;
    }

    public ChangePasswordConfiguration getChangePasswordConfiguration() {
        return this.changePasswordConfiguration;
    }

    protected void setDnsConfiguration(DnsConfiguration dnsConfiguration) {
        this.dnsConfiguration = dnsConfiguration;
    }

    public DnsConfiguration getDnsConfiguration() {
        return this.dnsConfiguration;
    }
}

