/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.jndi;

import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.spi.InitialContextFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.server.changepw.ChangePasswordConfiguration;
import org.apache.directory.server.changepw.ChangePasswordServer;
import org.apache.directory.server.configuration.ServerStartupConfiguration;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.configuration.StartupConfiguration;
import org.apache.directory.server.core.jndi.CoreContextFactory;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.kerberos.kdc.KdcConfiguration;
import org.apache.directory.server.kerberos.kdc.KerberosServer;
import org.apache.directory.server.kerberos.shared.store.JndiPrincipalStoreImpl;
import org.apache.directory.server.kerberos.shared.store.PrincipalStore;
import org.apache.directory.server.ldap.ExtendedOperationHandler;
import org.apache.directory.server.ldap.LdapProtocolProvider;
import org.apache.directory.server.ntp.NtpConfiguration;
import org.apache.directory.server.ntp.NtpServer;
import org.apache.directory.server.protocol.shared.ServiceConfiguration;
import org.apache.directory.server.protocol.shared.store.LdifFileLoader;
import org.apache.directory.shared.ldap.exception.LdapConfigurationException;
import org.apache.directory.shared.ldap.exception.LdapNamingException;
import org.apache.directory.shared.ldap.message.LockableAttributesImpl;
import org.apache.directory.shared.ldap.message.extended.NoticeOfDisconnect;
import org.apache.mina.common.DefaultIoFilterChainBuilder;
import org.apache.mina.common.ExecutorThreadModel;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoFilterChainBuilder;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.ThreadModel;
import org.apache.mina.common.WriteFuture;
import org.apache.mina.transport.socket.nio.DatagramAcceptor;
import org.apache.mina.transport.socket.nio.DatagramAcceptorConfig;
import org.apache.mina.transport.socket.nio.SocketAcceptor;
import org.apache.mina.transport.socket.nio.SocketAcceptorConfig;
import org.apache.mina.transport.socket.nio.SocketSessionConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerContextFactory
extends CoreContextFactory {
    private static final Logger log = LoggerFactory.getLogger((String)ServerContextFactory.class.getName());
    private static final String LDIF_FILES_DN = "ou=loadedLdifFiles,ou=configuration,ou=system";
    protected static IoAcceptor tcpAcceptor;
    protected static IoAcceptor udpAcceptor;
    protected static ThreadPoolExecutor threadPoolExecutor;
    protected static ExecutorThreadModel threadModel;
    private static boolean ldapStarted;
    private static boolean ldapsStarted;
    private static KerberosServer tcpKdcServer;
    private static KerberosServer udpKdcServer;
    private static ChangePasswordServer tcpChangePasswordServer;
    private static ChangePasswordServer udpChangePasswordServer;
    private static NtpServer tcpNtpServer;
    private static NtpServer udpNtpServer;
    private DirectoryService directoryService;
    private static final String WINDOWSFILE_ATTR = "windowsFilePath";
    private static final String UNIXFILE_ATTR = "unixFilePath";
    private static final String WINDOWSFILE_OC = "windowsFile";
    private static final String UNIXFILE_OC = "unixFile";

    public void beforeStartup(DirectoryService service) {
        int maxThreads = service.getConfiguration().getStartupConfiguration().getMaxThreads();
        threadPoolExecutor = new ThreadPoolExecutor(maxThreads, maxThreads, 60L, TimeUnit.SECONDS, (BlockingQueue)new LinkedBlockingQueue());
        threadModel.setExecutor((Executor)threadPoolExecutor);
        udpAcceptor = new DatagramAcceptor();
        tcpAcceptor = new SocketAcceptor();
        this.directoryService = service;
    }

    public void afterShutdown(DirectoryService service) {
        ServerStartupConfiguration cfg = (ServerStartupConfiguration)service.getConfiguration().getStartupConfiguration();
        if (ldapStarted) {
            this.stopLDAP0(cfg.getLdapPort());
            ldapStarted = false;
        }
        if (ldapsStarted) {
            this.stopLDAP0(cfg.getLdapsPort());
            ldapsStarted = false;
        }
        if (tcpKdcServer != null) {
            tcpKdcServer.destroy();
            if (log.isInfoEnabled()) {
                log.info("Unbind of KRB5 Service (TCP) complete: " + tcpKdcServer);
            }
            tcpKdcServer = null;
        }
        if (udpKdcServer != null) {
            udpKdcServer.destroy();
            if (log.isInfoEnabled()) {
                log.info("Unbind of KRB5 Service (UDP) complete: " + udpKdcServer);
            }
            udpKdcServer = null;
        }
        if (tcpChangePasswordServer != null) {
            tcpChangePasswordServer.destroy();
            if (log.isInfoEnabled()) {
                log.info("Unbind of Change Password Service (TCP) complete: " + tcpChangePasswordServer);
            }
            tcpChangePasswordServer = null;
        }
        if (udpChangePasswordServer != null) {
            udpChangePasswordServer.destroy();
            if (log.isInfoEnabled()) {
                log.info("Unbind of Change Password Service (UDP) complete: " + udpChangePasswordServer);
            }
            udpChangePasswordServer = null;
        }
        if (tcpNtpServer != null) {
            tcpNtpServer.destroy();
            if (log.isInfoEnabled()) {
                log.info("Unbind of NTP Service (TCP) complete: " + tcpNtpServer);
            }
            tcpNtpServer = null;
        }
        if (udpNtpServer != null) {
            udpNtpServer.destroy();
            if (log.isInfoEnabled()) {
                log.info("Unbind of NTP Service complete: " + udpNtpServer);
            }
            udpNtpServer = null;
        }
    }

    public void afterStartup(DirectoryService service) throws NamingException {
        ServerStartupConfiguration cfg = (ServerStartupConfiguration)service.getConfiguration().getStartupConfiguration();
        Hashtable env = service.getConfiguration().getEnvironment();
        this.loadLdifs(service);
        if (cfg.isEnableNetworking()) {
            this.startLDAP(cfg, env);
            this.startLDAPS(cfg, env);
            this.startKerberos(cfg, env);
            this.startChangePassword(cfg, env);
            this.startNTP(cfg, env);
        }
    }

    private void ensureLdifFileBase(DirContext root) {
        LockableAttributesImpl entry = new LockableAttributesImpl("ou", (Object)"loadedLdifFiles", true);
        entry.put("objectClass", "top");
        entry.get("objectClass").add("organizationalUnit");
        try {
            root.createSubcontext(LDIF_FILES_DN, (Attributes)entry);
            log.info("Creating ou=loadedLdifFiles,ou=configuration,ou=system");
        }
        catch (NamingException e) {
            log.info("ou=loadedLdifFiles,ou=configuration,ou=system exists");
        }
    }

    private void addFileEntry(DirContext root, File ldif) throws NamingException {
        String rdnAttr = File.separatorChar == '\\' ? WINDOWSFILE_ATTR : UNIXFILE_ATTR;
        String oc = File.separatorChar == '\\' ? WINDOWSFILE_OC : UNIXFILE_OC;
        StringBuffer buf = new StringBuffer();
        buf.append(rdnAttr);
        buf.append("=");
        buf.append(this.getCanonical(ldif));
        buf.append(",");
        buf.append(LDIF_FILES_DN);
        LockableAttributesImpl entry = new LockableAttributesImpl(rdnAttr, (Object)this.getCanonical(ldif), true);
        entry.put("objectClass", "top");
        entry.get("objectClass").add(oc);
        root.createSubcontext(buf.toString(), (Attributes)entry);
    }

    private Attributes getLdifFileEntry(DirContext root, File ldif) {
        String rdnAttr = File.separatorChar == '\\' ? WINDOWSFILE_ATTR : UNIXFILE_ATTR;
        StringBuffer buf = new StringBuffer();
        buf.append(rdnAttr);
        buf.append("=");
        buf.append(this.getCanonical(ldif));
        buf.append(",");
        buf.append(LDIF_FILES_DN);
        try {
            return root.getAttributes(buf.toString(), new String[]{"createTimestamp"});
        }
        catch (NamingException e) {
            return null;
        }
    }

    private String getCanonical(File file) {
        String canonical = null;
        try {
            canonical = file.getCanonicalPath();
        }
        catch (IOException e) {
            log.error("could not get canonical path", (Throwable)e);
            return null;
        }
        return StringUtils.replace((String)canonical, (String)"\\", (String)"\\\\");
    }

    private void loadLdifs(DirectoryService service) throws NamingException {
        ServerStartupConfiguration cfg = (ServerStartupConfiguration)service.getConfiguration().getStartupConfiguration();
        if (cfg.getLdifDirectory() == null) {
            log.info("LDIF load directory not specified.  No LDIF files will be loaded.");
            return;
        }
        if (!cfg.getLdifDirectory().exists()) {
            log.warn("LDIF load directory '" + this.getCanonical(cfg.getLdifDirectory()) + "' does not exist.  No LDIF files will be loaded.");
            return;
        }
        Hashtable env = (Hashtable)service.getConfiguration().getEnvironment().clone();
        env.put("java.naming.provider.url", "");
        DirContext root = (DirContext)this.getInitialContext(env);
        this.ensureLdifFileBase(root);
        if (!cfg.getLdifDirectory().isDirectory()) {
            log.info("LDIF load directory '" + this.getCanonical(cfg.getLdifDirectory()) + "' is a file.  Will attempt to load as LDIF.");
            Attributes fileEntry = this.getLdifFileEntry(root, cfg.getLdifDirectory());
            if (fileEntry != null) {
                String time = (String)fileEntry.get("createTimestamp").get();
                log.info("Load of LDIF file '" + this.getCanonical(cfg.getLdifDirectory()) + "' skipped.  It has already been loaded on " + time + ".");
                return;
            }
            LdifFileLoader loader = new LdifFileLoader(root, cfg.getLdifDirectory(), cfg.getLdifFilters());
            loader.execute();
            this.addFileEntry(root, cfg.getLdifDirectory());
            return;
        }
        File[] ldifFiles = cfg.getLdifDirectory().listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                boolean isLdif = pathname.getName().toLowerCase().endsWith(".ldif");
                return pathname.isFile() && pathname.canRead() && isLdif;
            }
        });
        if (ldifFiles == null || ldifFiles.length == 0) {
            log.warn("LDIF load directory '" + this.getCanonical(cfg.getLdifDirectory()) + "' does not contain any LDIF files.  No LDIF files will be loaded.");
            return;
        }
        for (int ii = 0; ii < ldifFiles.length; ++ii) {
            Attributes fileEntry = this.getLdifFileEntry(root, ldifFiles[ii]);
            if (fileEntry != null) {
                String time = (String)fileEntry.get("createTimestamp").get();
                log.info("Load of LDIF file '" + this.getCanonical(ldifFiles[ii]) + "' skipped.  It has already been loaded on " + time + ".");
                continue;
            }
            LdifFileLoader loader = new LdifFileLoader(root, ldifFiles[ii], cfg.getLdifFilters());
            int count = loader.execute();
            log.info("Loaded " + count + " entries from LDIF file '" + this.getCanonical(ldifFiles[ii]) + "'");
            if (fileEntry != null) continue;
            this.addFileEntry(root, ldifFiles[ii]);
        }
    }

    private void startLDAP(ServerStartupConfiguration cfg, Hashtable env) throws NamingException {
        int port = cfg.getLdapPort();
        if (port < 0) {
            return;
        }
        this.startLDAP0(cfg, env, port, (IoFilterChainBuilder)new DefaultIoFilterChainBuilder());
    }

    private void startLDAPS(ServerStartupConfiguration cfg, Hashtable env) throws NamingException {
        IoFilterChainBuilder chain;
        if (!cfg.isEnableLdaps()) {
            return;
        }
        try {
            chain = (IoFilterChainBuilder)Class.forName("org.apache.directory.server.ssl.LdapsInitializer", true, ServerContextFactory.class.getClassLoader()).getMethod("init", ServerStartupConfiguration.class).invoke(null, new Object[]{cfg});
            ldapsStarted = true;
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof NamingException) {
                throw (NamingException)e.getCause();
            }
            throw (NamingException)new NamingException("Failed to load LDAPS initializer.").initCause(e.getCause());
        }
        catch (Exception e) {
            throw (NamingException)new NamingException("Failed to load LDAPS initializer.").initCause(e);
        }
        this.startLDAP0(cfg, env, cfg.getLdapsPort(), chain);
    }

    private void startLDAP0(ServerStartupConfiguration cfg, Hashtable env, int port, IoFilterChainBuilder chainBuilder) throws LdapNamingException, LdapConfigurationException {
        LdapProtocolProvider protocolProvider = new LdapProtocolProvider((StartupConfiguration)cfg, (Hashtable)env.clone());
        Iterator i = cfg.getExtendedOperationHandlers().iterator();
        while (i.hasNext()) {
            ExtendedOperationHandler h = (ExtendedOperationHandler)i.next();
            protocolProvider.addExtendedOperationHandler(h);
            log.info("Added Extended Request Handler: " + h.getOid());
            h.setLdapProvider(protocolProvider);
            PartitionNexus nexus = this.directoryService.getConfiguration().getPartitionNexus();
            nexus.registerSupportedExtensions(h.getExtensionOids());
        }
        try {
            SocketAcceptorConfig acceptorCfg = new SocketAcceptorConfig();
            acceptorCfg.setDisconnectOnUnbind(false);
            acceptorCfg.setReuseAddress(true);
            acceptorCfg.setFilterChainBuilder(chainBuilder);
            acceptorCfg.setThreadModel((ThreadModel)threadModel);
            ((SocketSessionConfig)acceptorCfg.getSessionConfig()).setTcpNoDelay(true);
            tcpAcceptor.bind((SocketAddress)new InetSocketAddress(port), protocolProvider.getHandler(), (IoServiceConfig)acceptorCfg);
            ldapStarted = true;
            if (log.isInfoEnabled()) {
                log.info("Successful bind of an LDAP Service (" + port + ") is complete.");
            }
        }
        catch (IOException e) {
            String msg = "Failed to bind an LDAP service (" + port + ") to the service registry.";
            LdapConfigurationException lce = new LdapConfigurationException(msg);
            lce.setRootCause((Throwable)e);
            log.error(msg, (Throwable)e);
            throw lce;
        }
    }

    private void startKerberos(ServerStartupConfiguration cfg, Hashtable env) {
        if (cfg.isEnableKerberos()) {
            try {
                KdcConfiguration kdcConfiguration = new KdcConfiguration((Map)env, 2);
                JndiPrincipalStoreImpl kdcStore = new JndiPrincipalStoreImpl((ServiceConfiguration)kdcConfiguration, (InitialContextFactory)((Object)this));
                DatagramAcceptorConfig udpConfig = new DatagramAcceptorConfig();
                udpConfig.setThreadModel((ThreadModel)threadModel);
                SocketAcceptorConfig tcpConfig = new SocketAcceptorConfig();
                tcpConfig.setDisconnectOnUnbind(false);
                tcpConfig.setReuseAddress(true);
                tcpConfig.setFilterChainBuilder((IoFilterChainBuilder)new DefaultIoFilterChainBuilder());
                tcpConfig.setThreadModel((ThreadModel)threadModel);
                tcpKdcServer = new KerberosServer(kdcConfiguration, tcpAcceptor, (IoServiceConfig)tcpConfig, (PrincipalStore)kdcStore);
                udpKdcServer = new KerberosServer(kdcConfiguration, udpAcceptor, (IoServiceConfig)udpConfig, (PrincipalStore)kdcStore);
            }
            catch (Throwable t) {
                log.error("Failed to start the Kerberos service", t);
            }
        }
    }

    private void startChangePassword(ServerStartupConfiguration cfg, Hashtable env) {
        if (cfg.isEnableChangePassword()) {
            try {
                ChangePasswordConfiguration changePasswordConfiguration = new ChangePasswordConfiguration((Map)env, 2);
                JndiPrincipalStoreImpl store = new JndiPrincipalStoreImpl((ServiceConfiguration)changePasswordConfiguration, (InitialContextFactory)((Object)this));
                DatagramAcceptorConfig udpConfig = new DatagramAcceptorConfig();
                udpConfig.setThreadModel((ThreadModel)threadModel);
                SocketAcceptorConfig tcpConfig = new SocketAcceptorConfig();
                tcpConfig.setDisconnectOnUnbind(false);
                tcpConfig.setReuseAddress(true);
                tcpConfig.setFilterChainBuilder((IoFilterChainBuilder)new DefaultIoFilterChainBuilder());
                tcpConfig.setThreadModel((ThreadModel)threadModel);
                tcpChangePasswordServer = new ChangePasswordServer(changePasswordConfiguration, tcpAcceptor, (IoServiceConfig)tcpConfig, (PrincipalStore)store);
                udpChangePasswordServer = new ChangePasswordServer(changePasswordConfiguration, udpAcceptor, (IoServiceConfig)udpConfig, (PrincipalStore)store);
            }
            catch (Throwable t) {
                log.error("Failed to start the Change Password service", t);
            }
        }
    }

    private void startNTP(ServerStartupConfiguration cfg, Hashtable env) {
        if (cfg.isEnableNtp()) {
            try {
                NtpConfiguration ntpConfig = new NtpConfiguration((Map)env, 2);
                DatagramAcceptorConfig udpConfig = new DatagramAcceptorConfig();
                udpConfig.setThreadModel((ThreadModel)threadModel);
                SocketAcceptorConfig tcpConfig = new SocketAcceptorConfig();
                tcpConfig.setDisconnectOnUnbind(false);
                tcpConfig.setReuseAddress(true);
                tcpConfig.setFilterChainBuilder((IoFilterChainBuilder)new DefaultIoFilterChainBuilder());
                tcpConfig.setThreadModel((ThreadModel)threadModel);
                tcpNtpServer = new NtpServer(ntpConfig, tcpAcceptor, (IoServiceConfig)tcpConfig);
                udpNtpServer = new NtpServer(ntpConfig, udpAcceptor, (IoServiceConfig)udpConfig);
            }
            catch (Throwable t) {
                log.error("Failed to start the NTP service", t);
            }
        }
    }

    private void stopLDAP0(int port) {
        try {
            ArrayList<WriteFuture> writeFutures = new ArrayList<WriteFuture>();
            ArrayList sessions = null;
            try {
                sessions = new ArrayList(tcpAcceptor.getManagedSessions((SocketAddress)new InetSocketAddress(port)));
            }
            catch (IllegalArgumentException e) {
                log.warn("Seems like the LDAP service (" + port + ") has already been unbound.");
                return;
            }
            tcpAcceptor.unbind((SocketAddress)new InetSocketAddress(port));
            if (log.isInfoEnabled()) {
                log.info("Unbind of an LDAP service (" + port + ") is complete.");
                log.info("Sending notice of disconnect to existing clients sessions.");
            }
            if (sessions != null) {
                Iterator i = sessions.iterator();
                while (i.hasNext()) {
                    IoSession session = (IoSession)i.next();
                    writeFutures.add(session.write((Object)NoticeOfDisconnect.UNAVAILABLE));
                }
            }
            Iterator sessionIt = sessions.iterator();
            Iterator i = writeFutures.iterator();
            while (i.hasNext()) {
                WriteFuture future = (WriteFuture)i.next();
                future.join(1000L);
                ((IoSession)sessionIt.next()).close();
            }
        }
        catch (Exception e) {
            log.warn("Failed to sent NoD.", (Throwable)e);
        }
    }

    static {
        threadModel = ExecutorThreadModel.getInstance((String)"ApacheDS");
    }
}

