/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.integ;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.directory.server.core.integ.Level;
import org.apache.directory.server.core.integ.SetupMode;
import org.apache.directory.server.core.integ.annotations.ApplyLdifFiles;
import org.apache.directory.server.core.integ.annotations.ApplyLdifs;
import org.apache.directory.server.core.integ.annotations.CleanupLevel;
import org.apache.directory.server.core.integ.annotations.Factory;
import org.apache.directory.server.core.integ.annotations.Mode;
import org.apache.directory.server.integ.LdapServerFactory;
import org.junit.runner.Description;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InheritableServerSettings {
    public static final SetupMode DEFAULT_MODE = SetupMode.ROLLBACK;
    public static final LdapServerFactory DEFAULT_FACTORY = LdapServerFactory.DEFAULT;
    private final InheritableServerSettings parent;
    private final Description description;
    private static final Level DEFAULT_CLEANUP_LEVEL = Level.SUITE;

    public InheritableServerSettings(Description description) {
        this.description = description;
        this.parent = null;
    }

    public InheritableServerSettings(Description description, InheritableServerSettings parent) {
        this.description = description;
        this.parent = parent;
        if (description.isSuite() && !this.isSuiteLevel()) {
            throw new IllegalStateException(String.format("The parent must be null for %s suite", description.getDisplayName()));
        }
    }

    public Description getDescription() {
        return this.description;
    }

    public InheritableServerSettings getParent() {
        return this.parent;
    }

    public boolean isSuiteLevel() {
        return this.parent == null;
    }

    public boolean isClassLevel() {
        return this.parent != null && this.parent.getParent() == null;
    }

    public boolean isMethodLevel() {
        return this.parent != null && this.parent.getParent() != null;
    }

    public SetupMode getMode() {
        Mode annotation;
        SetupMode parentMode = DEFAULT_MODE;
        if (this.parent != null) {
            parentMode = this.parent.getMode();
        }
        if ((annotation = (Mode)this.description.getAnnotation(Mode.class)) == null) {
            return parentMode;
        }
        return annotation.value();
    }

    public LdapServerFactory getFactory() throws IllegalAccessException, InstantiationException {
        Factory annotation;
        LdapServerFactory parentFactory = DEFAULT_FACTORY;
        if (this.parent != null) {
            parentFactory = this.parent.getFactory();
        }
        if ((annotation = (Factory)this.description.getAnnotation(Factory.class)) == null) {
            return parentFactory;
        }
        return (LdapServerFactory)annotation.value().newInstance();
    }

    public List<String> getLdifs(List<String> ldifs) {
        ApplyLdifs annotation;
        if (ldifs == null) {
            ldifs = new ArrayList<String>();
        }
        if (this.parent != null) {
            this.parent.getLdifs(ldifs);
        }
        if ((annotation = (ApplyLdifs)this.description.getAnnotation(ApplyLdifs.class)) != null && annotation.value() != null) {
            ldifs.addAll(Arrays.asList(annotation.value()));
        }
        return ldifs;
    }

    public List<String> getLdifFiles(List<String> ldifFiles) {
        ApplyLdifFiles annotation;
        if (ldifFiles == null) {
            ldifFiles = new ArrayList<String>();
        }
        if (this.parent != null) {
            this.parent.getLdifFiles(ldifFiles);
        }
        if ((annotation = (ApplyLdifFiles)this.description.getAnnotation(ApplyLdifFiles.class)) != null && annotation.value() != null) {
            ldifFiles.addAll(Arrays.asList(annotation.value()));
        }
        return ldifFiles;
    }

    public Level getCleanupLevel() {
        CleanupLevel annotation;
        Level parentCleanupLevel = DEFAULT_CLEANUP_LEVEL;
        if (this.parent != null) {
            parentCleanupLevel = this.parent.getCleanupLevel();
        }
        if ((annotation = (CleanupLevel)this.description.getAnnotation(CleanupLevel.class)) == null) {
            return parentCleanupLevel;
        }
        return annotation.value();
    }
}

