/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.config;

import java.io.InputStream;
import java.util.Iterator;
import java.util.UUID;
import javax.naming.InvalidNameException;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.api.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.partition.ldif.AbstractLdifPartition;
import org.apache.directory.shared.ldap.model.entry.DefaultEntry;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.ldif.LdifEntry;
import org.apache.directory.shared.ldap.model.ldif.LdifReader;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;

public class ReadOnlyConfigurationPartition
extends AbstractLdifPartition {
    private InputStream inputStream;

    public ReadOnlyConfigurationPartition(InputStream inputStream, SchemaManager schemaManager) {
        super(schemaManager);
        this.inputStream = inputStream;
        this.id = "config";
        try {
            this.suffixDn = new Dn(schemaManager, new String[]{"ou=config"});
        }
        catch (LdapInvalidDnException ldapInvalidDnException) {
            // empty catch block
        }
    }

    protected void doInit() throws InvalidNameException, Exception {
        if (!this.initialized) {
            super.doInit();
            this.loadLdifEntries();
        }
    }

    private void loadLdifEntries() throws Exception {
        if (this.inputStream != null) {
            LdifReader reader = new LdifReader(this.inputStream);
            Iterator itr = reader.iterator();
            if (!itr.hasNext()) {
                return;
            }
            LdifEntry ldifEntry = (LdifEntry)itr.next();
            DefaultEntry contextEntry = new DefaultEntry(this.schemaManager, ldifEntry.getEntry());
            if (this.suffixDn.equals((Object)contextEntry.getDn())) {
                this.addMandatoryOpAt((Entry)contextEntry);
                super.add(new AddOperationContext(null, (Entry)contextEntry));
            } else {
                throw new LdapException("The given LDIF file doesn't contain the context entry");
            }
            while (itr.hasNext()) {
                DefaultEntry entry = new DefaultEntry(this.schemaManager, ((LdifEntry)itr.next()).getEntry());
                this.addMandatoryOpAt((Entry)entry);
                super.add(new AddOperationContext(null, (Entry)entry));
            }
            reader.close();
        }
    }

    private void addMandatoryOpAt(Entry entry) throws LdapException {
        if (entry.get("entryCSN") == null) {
            entry.add("entryCSN", new String[]{defaultCSNFactory.newInstance().toString()});
        }
        if (entry.get("entryUUID") == null) {
            String uuid = UUID.randomUUID().toString();
            entry.add("entryUUID", new String[]{uuid});
        }
    }

    public void add(AddOperationContext arg0) throws LdapException {
    }

    public void delete(Long arg0) throws LdapException {
    }

    public void modify(ModifyOperationContext arg0) throws LdapException {
    }

    public void move(MoveOperationContext arg0) throws LdapException {
    }

    public void moveAndRename(MoveAndRenameOperationContext arg0) throws LdapException {
    }

    public void rename(RenameOperationContext arg0) throws LdapException {
    }
}

