/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.config;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.directory.api.ldap.model.cursor.SetCursor;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.StringValue;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.filter.EqualityNode;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.message.AliasDerefMode;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.server.config.ConfigSchemaConstants;
import org.apache.directory.server.config.ConfigurationElement;
import org.apache.directory.server.config.ConfigurationException;
import org.apache.directory.server.config.beans.AdsBaseBean;
import org.apache.directory.server.config.beans.ConfigBean;
import org.apache.directory.server.core.api.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.partition.impl.btree.AbstractBTreePartition;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.search.PartitionSearchResult;
import org.apache.directory.server.xdbm.search.SearchEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigPartitionReader {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigPartitionReader.class);
    private AbstractBTreePartition configPartition;
    private SearchEngine se;
    private SchemaManager schemaManager;
    private static final String ADS_PREFIX = "ads-";
    private static final String ADS_SUFFIX = "Bean";

    public ConfigPartitionReader(AbstractBTreePartition configPartition) {
        if (configPartition == null) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_503, (Object[])new Object[0]));
        }
        if (!configPartition.isInitialized()) {
            throw new IllegalStateException(I18n.err((I18n)I18n.ERR_504, (Object[])new Object[0]));
        }
        this.configPartition = configPartition;
        this.se = configPartition.getSearchEngine();
        this.schemaManager = configPartition.getSchemaManager();
    }

    private ObjectClass findObjectClass(Attribute objectClass) throws Exception {
        ObjectClass oc;
        String ocOid;
        String ocName;
        HashSet<ObjectClass> candidates = new HashSet<ObjectClass>();
        for (Value ocValue : objectClass) {
            ocName = ocValue.getString();
            ocOid = this.schemaManager.getObjectClassRegistry().getOidByName(ocName);
            oc = (ObjectClass)this.schemaManager.getObjectClassRegistry().get(ocOid);
            if (!oc.isStructural()) continue;
            candidates.add(oc);
        }
        for (Value ocValue : objectClass) {
            ocName = ocValue.getString();
            ocOid = this.schemaManager.getObjectClassRegistry().getOidByName(ocName);
            oc = (ObjectClass)this.schemaManager.getObjectClassRegistry().get(ocOid);
            for (ObjectClass superior : oc.getSuperiors()) {
                if (!oc.isStructural() || !candidates.contains(superior)) continue;
                candidates.remove(superior);
            }
        }
        ObjectClass result = candidates.toArray(new ObjectClass[0])[0];
        LOG.debug("The top level object class is {}", (Object)result.getName());
        return result;
    }

    private AdsBaseBean createBean(ObjectClass objectClass) throws ConfigurationException {
        String objectClassName = objectClass.getName();
        String beanName = this.getClass().getPackage().getName() + ".beans." + Character.toUpperCase(objectClassName.charAt(ADS_PREFIX.length())) + objectClassName.substring(ADS_PREFIX.length() + 1) + ADS_SUFFIX;
        try {
            Class<?> clazz = Class.forName(beanName);
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            AdsBaseBean bean = (AdsBaseBean)constructor.newInstance(new Object[0]);
            LOG.debug("Bean {} created for ObjectClass {}", (Object)beanName, (Object)objectClassName);
            return bean;
        }
        catch (ClassNotFoundException cnfe) {
            String message = "Cannot find a Bean class for the ObjectClass name " + objectClassName;
            LOG.error(message);
            throw new ConfigurationException(message);
        }
        catch (SecurityException se) {
            String message = "Cannot access to the class " + beanName;
            LOG.error(message);
            throw new ConfigurationException(message);
        }
        catch (NoSuchMethodException nsme) {
            String message = "Cannot find a constructor for the class " + beanName;
            LOG.error(message);
            throw new ConfigurationException(message);
        }
        catch (InvocationTargetException ite) {
            String message = "Cannot invoke the class " + beanName + ", " + ite.getMessage();
            LOG.error(message);
            throw new ConfigurationException(message);
        }
        catch (IllegalAccessException iae) {
            String message = "Cannot access to the constructor for class " + beanName;
            LOG.error(message);
            throw new ConfigurationException(message);
        }
        catch (InstantiationException ie) {
            String message = "Cannot instantiate the class " + beanName + ", " + ie.getMessage();
            LOG.error(message);
            throw new ConfigurationException(message);
        }
    }

    private void readSingleValueField(AdsBaseBean bean, Field beanField, Attribute fieldAttr) throws ConfigurationException {
        block11: {
            if (fieldAttr == null) {
                return;
            }
            Value value = fieldAttr.get();
            String valueStr = value.getString();
            Class<?> type = beanField.getType();
            try {
                if (type == String.class) {
                    beanField.set(bean, valueStr);
                    break block11;
                }
                if (type == byte[].class) {
                    beanField.set(bean, value.getBytes());
                    break block11;
                }
                if (type == Integer.TYPE) {
                    beanField.setInt(bean, Integer.parseInt(valueStr));
                    break block11;
                }
                if (type == Long.TYPE) {
                    beanField.setLong(bean, Long.parseLong(valueStr));
                    break block11;
                }
                if (type == Boolean.TYPE) {
                    beanField.setBoolean(bean, Boolean.parseBoolean(valueStr));
                    break block11;
                }
                if (type != Dn.class) break block11;
                try {
                    Dn dn = new Dn(new String[]{valueStr});
                    beanField.set(bean, dn);
                }
                catch (LdapInvalidDnException lide) {
                    String message = "The Dn '" + valueStr + "' for attribute " + fieldAttr.getId() + " is not a valid Dn";
                    LOG.error(message);
                    throw new ConfigurationException(message);
                }
            }
            catch (IllegalArgumentException iae) {
                String message = "Cannot store '" + valueStr + "' into attribute " + fieldAttr.getId();
                LOG.error(message);
                throw new ConfigurationException(message);
            }
            catch (IllegalAccessException e) {
                String message = "Cannot store '" + valueStr + "' into attribute " + fieldAttr.getId();
                LOG.error(message);
                throw new ConfigurationException(message);
            }
        }
    }

    private void readMultiValuedField(AdsBaseBean bean, Field field, Attribute attribute) throws ConfigurationException {
        if (attribute == null) {
            return;
        }
        Class<?> type = field.getType();
        String fieldName = field.getName();
        String addMethodName = "add" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
        for (Value value : attribute) {
            String message;
            String valueStr = value.getString();
            try {
                Method method;
                Type[] fieldArgTypes;
                ParameterizedType parameterizedType;
                Class fieldArgClass;
                Type genericFieldType;
                if (type == String.class) {
                    field.set(bean, valueStr);
                    continue;
                }
                if (type == Integer.TYPE) {
                    field.setInt(bean, Integer.parseInt(valueStr));
                    continue;
                }
                if (type == Long.TYPE) {
                    field.setLong(bean, Long.parseLong(valueStr));
                    continue;
                }
                if (type == Boolean.TYPE) {
                    field.setBoolean(bean, Boolean.parseBoolean(valueStr));
                    continue;
                }
                if (type == Dn.class) {
                    try {
                        Dn dn = new Dn(new String[]{valueStr});
                        field.set(bean, dn);
                        continue;
                    }
                    catch (LdapInvalidDnException lide) {
                        message = "The Dn '" + valueStr + "' for attribute " + attribute.getId() + " is not a valid Dn";
                        LOG.error(message);
                        throw new ConfigurationException(message);
                    }
                }
                if (type == Set.class) {
                    genericFieldType = field.getGenericType();
                    fieldArgClass = null;
                    if (genericFieldType instanceof ParameterizedType) {
                        parameterizedType = (ParameterizedType)genericFieldType;
                        for (Type fieldArgType : fieldArgTypes = parameterizedType.getActualTypeArguments()) {
                            fieldArgClass = (Class)fieldArgType;
                        }
                    }
                    method = bean.getClass().getMethod(addMethodName, Array.newInstance(fieldArgClass, 0).getClass());
                    method.invoke((Object)bean, new Object[]{new String[]{valueStr}});
                    continue;
                }
                if (type != List.class) continue;
                genericFieldType = field.getGenericType();
                fieldArgClass = null;
                if (genericFieldType instanceof ParameterizedType) {
                    parameterizedType = (ParameterizedType)genericFieldType;
                    for (Type fieldArgType : fieldArgTypes = parameterizedType.getActualTypeArguments()) {
                        fieldArgClass = (Class)fieldArgType;
                    }
                }
                method = bean.getClass().getMethod(addMethodName, Array.newInstance(fieldArgClass, 0).getClass());
                method.invoke((Object)bean, new Object[]{new String[]{valueStr}});
            }
            catch (IllegalArgumentException iae) {
                message = "Cannot store '" + valueStr + "' into attribute " + attribute.getId();
                LOG.error(message);
                throw new ConfigurationException(message);
            }
            catch (IllegalAccessException e) {
                message = "Cannot store '" + valueStr + "' into attribute " + attribute.getId();
                LOG.error(message);
                throw new ConfigurationException(message);
            }
            catch (SecurityException se) {
                message = "Cannot access to the class " + bean.getClass().getName();
                LOG.error(message);
                throw new ConfigurationException(message);
            }
            catch (NoSuchMethodException nsme) {
                message = "Cannot find a method " + addMethodName + " in the class " + bean.getClass().getName();
                LOG.error(message);
                throw new ConfigurationException(message);
            }
            catch (InvocationTargetException ite) {
                message = "Cannot invoke the class " + bean.getClass().getName() + ", " + ite.getMessage();
                LOG.error(message);
                throw new ConfigurationException(message);
            }
            catch (NegativeArraySizeException negativeArraySizeException) {
            }
        }
    }

    private void readFieldValue(AdsBaseBean bean, Field field, Entry entry, String attributeTypeName, boolean mandatory) throws ConfigurationException {
        Attribute attribute = entry.get(attributeTypeName);
        if (attribute != null && attribute.size() > 0) {
            if (!this.isMultiple(field.getType())) {
                this.readSingleValueField(bean, field, attribute);
            } else {
                this.readMultiValuedField(bean, field, attribute);
            }
        } else if (mandatory) {
            String message = "No value was configured for entry with DN '" + entry.getDn() + "' and attribute type '" + attributeTypeName + "'.";
            LOG.error(message);
            throw new ConfigurationException(message);
        }
    }

    public List<AdsBaseBean> read(Dn baseDn, String name, SearchScope scope, boolean mandatory) throws ConfigurationException {
        LOG.debug("Reading from '{}', objectClass '{}'", (Object)baseDn, (Object)name);
        EqualityNode filter = new EqualityNode(this.schemaManager.getAttributeType("objectClass"), (Value)new StringValue(name));
        SetCursor cursor = null;
        ArrayList<AdsBaseBean> beansList = new ArrayList<AdsBaseBean>();
        try {
            SearchOperationContext searchContext = new SearchOperationContext(null);
            searchContext.setAliasDerefMode(AliasDerefMode.NEVER_DEREF_ALIASES);
            searchContext.setDn(baseDn);
            searchContext.setFilter((ExprNode)filter);
            searchContext.setScope(scope);
            PartitionSearchResult searchResult = this.se.computeResult(this.schemaManager, searchContext);
            cursor = searchResult.getResultSet();
            if (!cursor.next()) {
                if (mandatory) {
                    cursor.close();
                    String message = "No instance was configured under the DN '" + baseDn + "' for the objectClass '" + name + "'.";
                    LOG.error(message);
                    throw new ConfigurationException(message);
                }
                List<AdsBaseBean> message = null;
                return message;
            }
            do {
                IndexEntry forwardEntry = (IndexEntry)cursor.get();
                Entry entry = this.configPartition.fetch((String)forwardEntry.getId());
                LOG.debug("Entry read : {}", (Object)entry);
                AdsBaseBean bean = this.readConfig(entry);
                beansList.add(bean);
            } while (cursor.next());
        }
        catch (ConfigurationException ce) {
            throw ce;
        }
        catch (Exception e) {
            String message = "An error occured while reading the configuration DN '" + baseDn + "' for the objectClass '" + name + "':\n" + e.getMessage();
            LOG.error(message);
            throw new ConfigurationException(message, e);
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (Exception e) {
                    throw new ConfigurationException(e.getMessage(), e.getCause());
                }
            }
        }
        return beansList;
    }

    public AdsBaseBean readConfig(Entry entry) throws Exception {
        ObjectClass objectClass = this.findObjectClass(entry.get("objectClass"));
        AdsBaseBean bean = this.createBean(objectClass);
        bean.setDn(entry.getDn());
        Class<?> beanClass = bean.getClass();
        boolean adsBaseBeanClassFound = false;
        while (!adsBaseBeanClassFound) {
            Field[] fields;
            if (beanClass == AdsBaseBean.class) {
                adsBaseBeanClassFound = true;
            }
            for (Field field : fields = beanClass.getDeclaredFields()) {
                field.setAccessible(true);
                Class<?> fieldClass = field.getType();
                ConfigurationElement configurationElement = field.getAnnotation(ConfigurationElement.class);
                if (configurationElement == null) continue;
                String fieldAttributeType = configurationElement.attributeType();
                String fieldObjectClass = configurationElement.objectClass();
                String container = configurationElement.container();
                boolean isOptional = configurationElement.isOptional();
                if (fieldAttributeType != null && !"".equals(fieldAttributeType)) {
                    this.readFieldValue(bean, field, entry, fieldAttributeType, !isOptional);
                    continue;
                }
                if (fieldObjectClass == null || "".equals(fieldObjectClass)) continue;
                if (this.isMultiple(fieldClass) && container != null && !"".equals(container)) {
                    Dn newBase = entry.getDn().add("ou=" + container);
                    List<AdsBaseBean> fieldValues = this.read(newBase, fieldObjectClass, SearchScope.ONELEVEL, !isOptional);
                    if (fieldValues == null || fieldValues.size() <= 0) continue;
                    field.set(bean, fieldValues);
                    continue;
                }
                List<AdsBaseBean> fieldValues = this.read(entry.getDn(), fieldObjectClass, SearchScope.ONELEVEL, !isOptional);
                if (fieldValues == null || fieldValues.size() <= 0) continue;
                field.set(bean, fieldValues.get(0));
            }
            beanClass = beanClass.getSuperclass();
        }
        return bean;
    }

    private boolean isMultiple(Class<?> clazz) {
        return Collection.class.isAssignableFrom(clazz);
    }

    public ConfigBean readConfig() throws LdapException {
        return this.readConfig(new Dn(new Rdn[]{new Rdn("ou", "config")}));
    }

    public ConfigBean readConfig(String baseDn) throws LdapException {
        return this.readConfig(new Dn(new String[]{baseDn}));
    }

    public ConfigBean readConfig(Dn baseDn) throws ConfigurationException {
        return this.readConfig(baseDn, ConfigSchemaConstants.ADS_DIRECTORY_SERVICE_OC.getValue());
    }

    public ConfigBean readConfig(String baseDn, String objectClass) throws LdapException {
        return this.readConfig(new Dn(new String[]{baseDn}), objectClass);
    }

    public ConfigBean readConfig(Dn baseDn, String objectClass) throws ConfigurationException {
        LOG.debug("Reading configuration for the {} element, from {} ", (Object)objectClass, (Object)baseDn);
        ConfigBean configBean = new ConfigBean();
        if (baseDn == null) {
            baseDn = this.configPartition.getSuffixDn();
        }
        List<AdsBaseBean> beans = this.read(baseDn, objectClass, SearchScope.ONELEVEL, true);
        if (LOG.isDebugEnabled()) {
            if (beans == null || beans.size() == 0) {
                LOG.debug("No {} element to read", (Object)objectClass);
            } else {
                LOG.debug(beans.get(0).toString());
            }
        }
        configBean.setDirectoryServiceBeans(beans);
        return configBean;
    }
}

