/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.config;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.directory.server.config.ConfigurationElement;
import org.apache.directory.server.config.ConfigurationException;
import org.apache.directory.server.config.beans.AdsBaseBean;
import org.apache.directory.server.config.beans.ConfigBean;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.DefaultAttribute;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.ldif.LdifEntry;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.name.Rdn;
import org.apache.directory.shared.ldap.model.schema.ObjectClass;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigWriter {
    private SchemaManager schemaManager;
    private ConfigBean configBean;
    private List<LdifEntry> entries;

    public ConfigWriter(SchemaManager schemaManager, ConfigBean configBean) {
        this.schemaManager = schemaManager;
        this.configBean = configBean;
    }

    private void convertConfigurationBeanToLdifEntries() throws ConfigurationException {
        try {
            if (this.entries == null) {
                this.entries = new ArrayList<LdifEntry>();
                LdifEntry configRootEntry = new LdifEntry();
                configRootEntry.setDn(new Dn(new String[]{"ou=config"}));
                this.addObjectClassAttribute(this.schemaManager, configRootEntry, "organizationalUnit");
                this.addAttributeTypeValues("ou", "config", configRootEntry);
                this.entries.add(configRootEntry);
                List<AdsBaseBean> directoryServiceBeans = this.configBean.getDirectoryServiceBeans();
                for (AdsBaseBean adsBaseBean : directoryServiceBeans) {
                    this.addBean(configRootEntry.getDn(), this.schemaManager, adsBaseBean, this.entries);
                }
            }
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to convert the configuration bean to LDIF entries", e);
        }
    }

    public void writeToPath(String path) throws ConfigurationException, IOException {
        this.writeToFile(new File(path));
    }

    public void writeToFile(File file) throws ConfigurationException, IOException {
        FileWriter writer = new FileWriter(file);
        writer.append(this.writeToString());
        writer.close();
    }

    public String writeToString() throws ConfigurationException {
        this.convertConfigurationBeanToLdifEntries();
        StringBuilder sb = new StringBuilder();
        sb.append("version: 1\n");
        for (LdifEntry entry : this.entries) {
            sb.append(entry.toString());
        }
        return sb.toString();
    }

    public List<LdifEntry> getConvertedLdifEntries() throws ConfigurationException {
        this.convertConfigurationBeanToLdifEntries();
        return this.entries;
    }

    private void addObjectClassAttribute(SchemaManager schemaManager, LdifEntry entry, String objectClass) throws LdapException {
        ObjectClass objectClassObject = (ObjectClass)schemaManager.getObjectClassRegistry().lookup(objectClass);
        if (objectClassObject != null) {
            HashSet<String> objectClassAttributeValues = new HashSet<String>();
            this.computeObjectClassAttributeValues(schemaManager, objectClassAttributeValues, objectClassObject);
            this.addAttributeTypeValues("objectClass", objectClassAttributeValues, entry);
        }
    }

    private void computeObjectClassAttributeValues(SchemaManager schemaManager, Set<String> objectClassAttributeValues, ObjectClass objectClass) throws LdapException {
        ObjectClass topObjectClass = (ObjectClass)schemaManager.getObjectClassRegistry().lookup("top");
        if (topObjectClass != null) {
            // empty if block
        }
        if (topObjectClass.equals((Object)objectClass)) {
            objectClassAttributeValues.add(objectClass.getName());
        } else {
            objectClassAttributeValues.add(objectClass.getName());
            List superiors = objectClass.getSuperiors();
            if (superiors != null && superiors.size() > 0) {
                for (ObjectClass superior : superiors) {
                    this.computeObjectClassAttributeValues(schemaManager, objectClassAttributeValues, superior);
                }
            } else {
                objectClassAttributeValues.add(topObjectClass.getName());
            }
        }
    }

    private void addBean(Dn rootDn, SchemaManager schemaManager, AdsBaseBean bean, List<LdifEntry> entries) throws Exception {
        this.addBean(rootDn, schemaManager, bean, entries, null, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addBean(Dn rootDn, SchemaManager schemaManager, AdsBaseBean bean, List<LdifEntry> entries, LdifEntry parentEntry, String attributeTypeForParentEntry) throws Exception {
        if (bean == null) return;
        Class<?> beanClass = bean.getClass();
        LdifEntry entry = new LdifEntry();
        entry.setDn(this.getDn(rootDn, bean));
        this.addObjectClassAttribute(schemaManager, entry, this.getObjectClassNameForBean(beanClass));
        entries.add(entry);
        boolean adsBaseBeanClassFound = false;
        while (!adsBaseBeanClassFound) {
            Field[] fields;
            if (beanClass == AdsBaseBean.class) {
                adsBaseBeanClassFound = true;
            }
            for (Field field : fields = beanClass.getDeclaredFields()) {
                field.setAccessible(true);
                Class<?> fieldClass = field.getType();
                Object fieldValue = field.get(bean);
                ConfigurationElement configurationElement = field.getAnnotation(ConfigurationElement.class);
                if (configurationElement == null) continue;
                String attributeType = configurationElement.attributeType();
                if (attributeType != null && !"".equals(attributeType)) {
                    String container = configurationElement.container();
                    if (container != null && !"".equals(container)) {
                        LdifEntry containerEntry = new LdifEntry();
                        containerEntry.setDn(entry.getDn().add(new Rdn("ou", container)));
                        this.addObjectClassAttribute(schemaManager, containerEntry, "organizationalUnit");
                        this.addAttributeTypeValues("ou", container, containerEntry);
                        entries.add(containerEntry);
                        if (!Collection.class.isAssignableFrom(fieldClass)) throw new Exception();
                        Collection collection = (Collection)fieldValue;
                        for (Object object : collection) {
                            if (!(object instanceof AdsBaseBean)) throw new Exception();
                            this.addBean(containerEntry.getDn(), schemaManager, (AdsBaseBean)object, entries, entry, attributeType);
                        }
                    } else {
                        if (configurationElement.isRdn() && parentEntry != null && attributeTypeForParentEntry != null) {
                            this.addAttributeTypeValues(attributeTypeForParentEntry, fieldValue, parentEntry);
                        }
                        if (configurationElement.isOptional() && configurationElement.defaultValue().equalsIgnoreCase(fieldValue.toString())) continue;
                        this.addAttributeTypeValues(configurationElement.attributeType(), fieldValue, entry);
                        continue;
                    }
                }
                if (!AdsBaseBean.class.isAssignableFrom(fieldClass)) continue;
                this.addBean(entry.getDn(), schemaManager, (AdsBaseBean)fieldValue, entries);
            }
            beanClass = beanClass.getSuperclass();
        }
    }

    private String getObjectClassNameForBean(Class<?> c) {
        String classNameWithPackage = this.getClassNameWithoutPackageName(c);
        return "ads-" + classNameWithPackage.substring(0, classNameWithPackage.length() - 4);
    }

    private String getClassNameWithoutPackageName(Class<?> c) {
        String className = c.getName();
        int firstChar = className.lastIndexOf(46) + 1;
        if (firstChar > 0) {
            return className.substring(firstChar);
        }
        return className;
    }

    private boolean isMultiple(Class<?> clazz) {
        return Collection.class.isAssignableFrom(clazz);
    }

    private Dn getDn(Dn baseDn, AdsBaseBean bean) throws LdapInvalidDnException, IllegalArgumentException, IllegalAccessException {
        Class<?> beanClass = bean.getClass();
        boolean adsBaseBeanClassFound = false;
        while (!adsBaseBeanClassFound) {
            Field[] fields;
            if (beanClass == AdsBaseBean.class) {
                adsBaseBeanClassFound = true;
            }
            for (Field field : fields = beanClass.getDeclaredFields()) {
                field.setAccessible(true);
                ConfigurationElement configurationElement = field.getAnnotation(ConfigurationElement.class);
                if (configurationElement == null || !configurationElement.isRdn()) continue;
                return baseDn.add(new Rdn(configurationElement.attributeType(), field.get(bean).toString()));
            }
            beanClass = beanClass.getSuperclass();
        }
        return Dn.EMPTY_DN;
    }

    private void addAttributeTypeValues(String attributeType, Object o, LdifEntry entry) throws LdapException {
        if (o != null) {
            if (this.isMultiple(o.getClass())) {
                Collection values = (Collection)o;
                if (values != null) {
                    for (Object value : values) {
                        this.addAttributeTypeValue(attributeType, value, entry);
                    }
                }
            } else {
                this.addAttributeTypeValue(attributeType, o, entry);
            }
        }
    }

    private void addAttributeTypeValue(String attributeType, Object value, LdifEntry entry) throws LdapException {
        if (value != null) {
            Attribute attribute = entry.get(attributeType);
            if (attribute == null) {
                attribute = new DefaultAttribute(attributeType);
                entry.addAttribute(attribute);
            }
            if (value instanceof byte[]) {
                attribute.add((byte[][])new byte[][]{(byte[])value});
            } else if (value instanceof Boolean) {
                attribute.add(new String[]{value.toString().toUpperCase()});
            } else {
                attribute.add(new String[]{value.toString()});
            }
        }
    }
}

