/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.schema.registries;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.NamingException;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.server.schema.registries.SyntaxRegistry;
import org.apache.directory.shared.asn1.primitives.OID;
import org.apache.directory.shared.ldap.schema.Syntax;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSyntaxRegistry
implements SyntaxRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSyntaxRegistry.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private final Map<String, Syntax> byOidSyntax;
    private final OidRegistry oidRegistry;

    public DefaultSyntaxRegistry(OidRegistry registry) {
        this.oidRegistry = registry;
        this.byOidSyntax = new ConcurrentHashMap<String, Syntax>();
    }

    @Override
    public Syntax lookup(String id) throws NamingException {
        Syntax syntax = this.byOidSyntax.get(id = this.oidRegistry.getOid(id));
        if (syntax != null) {
            if (IS_DEBUG) {
                LOG.debug("looked up using id '{}' : {}", (Object)id, (Object)syntax);
            }
            return syntax;
        }
        String msg = "Unknown syntax OID " + id;
        LOG.error(msg);
        throw new NamingException(msg);
    }

    @Override
    public void register(Syntax syntax) throws NamingException {
        String oid = syntax.getOid();
        if (this.byOidSyntax.containsKey(oid)) {
            String msg = "syntax " + syntax + " w/ OID " + oid + " has already been registered!";
            LOG.warn(msg);
            throw new NamingException(msg);
        }
        if (syntax.getName() != null) {
            this.oidRegistry.register(syntax.getName(), oid);
        }
        this.oidRegistry.register(oid, oid);
        this.byOidSyntax.put(oid, syntax);
        if (IS_DEBUG) {
            LOG.debug("registered syntax: {}", (Object)syntax);
        }
    }

    @Override
    public boolean hasSyntax(String id) {
        try {
            String oid = this.oidRegistry.getOid(id);
            if (oid != null) {
                return this.byOidSyntax.containsKey(oid);
            }
            return false;
        }
        catch (NamingException e) {
            return false;
        }
    }

    @Override
    public String getSchemaName(String id) throws NamingException {
        if (!OID.isOID((String)id)) {
            String msg = "Looks like the arg is not a numeric OID";
            LOG.warn(msg);
            throw new NamingException(msg);
        }
        String oid = this.oidRegistry.getOid(id);
        Syntax syntax = this.byOidSyntax.get(oid);
        if (syntax != null) {
            return syntax.getSchema();
        }
        String msg = "OID " + oid + " not found in oid to Syntax map!";
        LOG.error(msg);
        throw new NamingException(msg);
    }

    @Override
    public Iterator<Syntax> iterator() {
        return this.byOidSyntax.values().iterator();
    }

    @Override
    public void unregister(String numericOid) throws NamingException {
        if (!OID.isOID((String)numericOid)) {
            String msg = "Looks like the arg " + numericOid + " is not a numeric OID";
            LOG.error(msg);
            throw new NamingException(msg);
        }
        this.byOidSyntax.remove(numericOid);
    }
}

