/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.schema.registries;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.NamingException;
import org.apache.directory.server.schema.registries.ObjectClassRegistry;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.shared.asn1.primitives.OID;
import org.apache.directory.shared.ldap.schema.ObjectClass;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultObjectClassRegistry
implements ObjectClassRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultObjectClassRegistry.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private final Map<String, ObjectClass> byOidOC = new ConcurrentHashMap<String, ObjectClass>();
    private final OidRegistry oidRegistry;

    public DefaultObjectClassRegistry(OidRegistry oidRegistry) {
        this.oidRegistry = oidRegistry;
    }

    @Override
    public void register(ObjectClass objectClass) throws NamingException {
        String oid = objectClass.getOid();
        if (this.byOidOC.containsKey(oid)) {
            String msg = "objectClass " + objectClass.getName() + " w/ OID " + oid + " has already been registered!";
            LOG.warn(msg);
            throw new NamingException(msg);
        }
        String name = objectClass.getName();
        if (!StringTools.isEmpty((String)name)) {
            this.oidRegistry.register(name, oid);
        }
        this.oidRegistry.register(oid, oid);
        this.byOidOC.put(oid, objectClass);
        if (IS_DEBUG) {
            LOG.debug("registered objectClass: {}", (Object)objectClass);
        }
    }

    @Override
    public ObjectClass lookup(String id) throws NamingException {
        String ocId = StringTools.trim((String)id).toLowerCase();
        if (StringTools.isEmpty((String)ocId)) {
            String msg = "Lookup in the OC registry : name should not be empty";
            LOG.error(msg);
            throw new NamingException(msg);
        }
        String oid = this.oidRegistry.getOid(ocId);
        ObjectClass objectClass = this.byOidOC.get(oid);
        if (objectClass == null) {
            String msg = "objectClass " + id + " w/ OID " + oid + " not registered!";
            LOG.warn(msg);
            throw new NamingException(msg);
        }
        if (IS_DEBUG) {
            LOG.debug("looked objectClass with OID '{}' and got back {}", (Object)oid, (Object)objectClass);
        }
        return objectClass;
    }

    @Override
    public boolean hasObjectClass(String id) {
        try {
            String oid = this.oidRegistry.getOid(id);
            if (oid == null) {
                return false;
            }
            return this.byOidOC.containsKey(oid);
        }
        catch (NamingException e) {
            return false;
        }
    }

    @Override
    public String getSchemaName(String id) throws NamingException {
        String ocOid = this.oidRegistry.getOid(id);
        if (ocOid == null) {
            String msg = "Element " + id + " not found in the OID registry !";
            LOG.warn(msg);
            throw new NamingException(msg);
        }
        ObjectClass oc = this.byOidOC.get(ocOid);
        if (oc != null) {
            return oc.getSchema();
        }
        String msg = "OID " + id + " not found in oid to " + "ObjectClass map!";
        LOG.warn(msg);
        throw new NamingException(msg);
    }

    @Override
    public Iterator<ObjectClass> iterator() {
        return this.byOidOC.values().iterator();
    }

    @Override
    public void unregister(String numericOid) throws NamingException {
        if (!OID.isOID((String)numericOid)) {
            String msg = "Looks like the arg " + numericOid + " is not a numeric OID";
            LOG.warn(msg);
            throw new NamingException(msg);
        }
        this.byOidOC.remove(numericOid);
    }
}

