/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.schema;

import javax.naming.NamingException;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.ClientStringValue;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.util.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameAndOptionalUIDNormalizer
implements Normalizer {
    private static final long serialVersionUID = 1L;
    private AttributeTypeRegistry attrRegistry;
    public static final NameAndOptionalUIDNormalizer INSTANCE = new NameAndOptionalUIDNormalizer();

    public NameAndOptionalUIDNormalizer() {
    }

    public NameAndOptionalUIDNormalizer(AttributeTypeRegistry attrRegistry) {
        this.attrRegistry = attrRegistry;
    }

    public void setRegistries(Registries registries) {
        this.attrRegistry = registries.getAttributeTypeRegistry();
    }

    public Value<?> normalize(Value<?> value) throws NamingException {
        String nameAndUid = value.getString();
        if (nameAndUid.length() == 0) {
            return null;
        }
        int sharpPos = nameAndUid.lastIndexOf(35);
        if (sharpPos != -1) {
            if (nameAndUid.indexOf(35) != sharpPos) {
                return null;
            }
            String uid = nameAndUid.substring(sharpPos + 1);
            if (sharpPos > 0) {
                LdapDN dn = new LdapDN(nameAndUid.substring(0, sharpPos));
                dn.normalize(this.attrRegistry.getNormalizerMapping());
                return new ClientStringValue(dn.getNormName() + '#' + uid);
            }
            throw new IllegalStateException("I do not know how to handle NameAndOptionalUID normalization with objects of class: " + value.getClass());
        }
        return new ClientStringValue(new LdapDN(nameAndUid).getNormName());
    }

    public String normalize(String value) throws NamingException {
        if (StringTools.isEmpty((String)value)) {
            return null;
        }
        int sharpPos = value.lastIndexOf(35);
        if (sharpPos != -1) {
            if (value.indexOf(35) != sharpPos) {
                return null;
            }
            String uid = value.substring(sharpPos + 1);
            if (sharpPos > 0) {
                LdapDN dn = new LdapDN(value.substring(0, sharpPos));
                dn.normalize(this.attrRegistry.getNormalizerMapping());
                return dn.getNormName() + '#' + uid;
            }
            throw new IllegalStateException("I do not know how to handle NameAndOptionalUID normalization with objects of class: " + value.getClass());
        }
        return new LdapDN(value).getNormName();
    }
}

