/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.schema.registries;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.directory.server.schema.registries.MatchingRuleUseRegistry;
import org.apache.directory.shared.ldap.schema.MatchingRuleUse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMatchingRuleUseRegistry
implements MatchingRuleUseRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMatchingRuleUseRegistry.class);
    private final Map<String, MatchingRuleUse> byName = new HashMap<String, MatchingRuleUse>();

    @Override
    public void register(MatchingRuleUse matchingRuleUse) throws NamingException {
        if (this.byName.containsKey(matchingRuleUse.getName())) {
            throw new NamingException("matchingRuleUse w/ name " + matchingRuleUse.getName() + " has already been registered!");
        }
        this.byName.put(matchingRuleUse.getName(), matchingRuleUse);
        if (LOG.isDebugEnabled()) {
            LOG.debug("registed matchingRuleUse: " + matchingRuleUse);
        }
    }

    @Override
    public MatchingRuleUse lookup(String name) throws NamingException {
        if (!this.byName.containsKey(name)) {
            throw new NamingException("matchingRuleUse w/ name " + name + " not registered!");
        }
        MatchingRuleUse matchingRuleUse = this.byName.get(name);
        if (LOG.isDebugEnabled()) {
            LOG.debug("lookup with name '" + name + "' of matchingRuleUse: " + matchingRuleUse);
        }
        return matchingRuleUse;
    }

    @Override
    public boolean hasMatchingRuleUse(String name) {
        return this.byName.containsKey(name);
    }

    @Override
    public String getSchemaName(String id) throws NamingException {
        MatchingRuleUse mru = this.byName.get(id);
        if (mru != null) {
            return mru.getSchema();
        }
        throw new NamingException("Name " + id + " not found in name to " + "MatchingRuleUse map!");
    }

    @Override
    public Iterator<MatchingRuleUse> iterator() {
        return this.byName.values().iterator();
    }

    @Override
    public void unregister(String name) throws NamingException {
        this.byName.remove(name);
    }
}

