/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.schema.registries;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.server.schema.registries.SyntaxRegistry;
import org.apache.directory.shared.ldap.schema.Syntax;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSyntaxRegistry
implements SyntaxRegistry {
    private static final Logger log = LoggerFactory.getLogger(DefaultSyntaxRegistry.class);
    private final Map<String, Syntax> byOid;
    private final OidRegistry oidRegistry;

    public DefaultSyntaxRegistry(OidRegistry registry) {
        this.oidRegistry = registry;
        this.byOid = new HashMap<String, Syntax>();
    }

    @Override
    public Syntax lookup(String id) throws NamingException {
        if (this.byOid.containsKey(id = this.oidRegistry.getOid(id))) {
            Syntax syntax = this.byOid.get(id);
            if (log.isDebugEnabled()) {
                log.debug("looked up using id '" + id + "': " + syntax);
            }
            return syntax;
        }
        NamingException fault = new NamingException("Unknown syntax OID " + id);
        throw fault;
    }

    @Override
    public void register(Syntax syntax) throws NamingException {
        if (this.byOid.containsKey(syntax.getOid())) {
            NamingException e = new NamingException("syntax w/ OID " + syntax.getOid() + " has already been registered!");
            throw e;
        }
        if (syntax.getName() != null) {
            this.oidRegistry.register(syntax.getName(), syntax.getOid());
        } else {
            this.oidRegistry.register(syntax.getOid(), syntax.getOid());
        }
        this.byOid.put(syntax.getOid(), syntax);
        if (log.isDebugEnabled()) {
            log.debug("registered syntax: " + syntax);
        }
    }

    @Override
    public boolean hasSyntax(String id) {
        if (this.oidRegistry.hasOid(id)) {
            try {
                return this.byOid.containsKey(this.oidRegistry.getOid(id));
            }
            catch (NamingException e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public String getSchemaName(String id) throws NamingException {
        if (!Character.isDigit(id.charAt(0))) {
            throw new NamingException("Looks like the arg is not a numeric OID");
        }
        Syntax syntax = this.byOid.get(id = this.oidRegistry.getOid(id));
        if (syntax != null) {
            return syntax.getSchema();
        }
        throw new NamingException("OID " + id + " not found in oid to " + "Syntax map!");
    }

    @Override
    public Iterator<Syntax> iterator() {
        return this.byOid.values().iterator();
    }

    @Override
    public void unregister(String numericOid) throws NamingException {
        if (!Character.isDigit(numericOid.charAt(0))) {
            throw new NamingException("Looks like the arg is not a numeric OID");
        }
        this.byOid.remove(numericOid);
        this.oidRegistry.unregister(numericOid);
    }
}

