/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.schema.registries;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOidRegistry
implements OidRegistry {
    private static final Logger log = LoggerFactory.getLogger(DefaultOidRegistry.class);
    private Map byOid = new HashMap();
    private Map<String, String> byName = new HashMap<String, String>();

    public String getOid(String name) throws NamingException {
        if (StringTools.isEmpty((String)name)) {
            throw new NamingException("name should not be empty");
        }
        if (StringTools.isDigit((char)name.charAt(0))) {
            return name;
        }
        if (this.byName.containsKey(name)) {
            String oid = this.byName.get(name);
            if (log.isDebugEnabled()) {
                log.debug("looked up OID '" + oid + "' with id '" + name + "'");
            }
            return oid;
        }
        String lowerCase = name.trim().toLowerCase();
        if (!name.equals(lowerCase) && this.byName.containsKey(lowerCase)) {
            String oid = this.byName.get(lowerCase);
            if (log.isDebugEnabled()) {
                log.debug("looked up OID '" + oid + "' with id '" + name + "'");
            }
            this.byName.put(name, oid);
            return oid;
        }
        NamingException fault = new NamingException("OID for name '" + name + "' was not " + "found within the OID registry");
        throw fault;
    }

    public boolean hasOid(String name) {
        if (this.byName.containsKey(name) || this.byOid.containsKey(name)) {
            return true;
        }
        String normalized = name.toLowerCase();
        return this.byName.containsKey(normalized) || this.byOid.containsKey(normalized);
    }

    public String getPrimaryName(String oid) throws NamingException {
        Object value = this.byOid.get(oid);
        if (null == value) {
            NamingException fault = new NamingException("OID '" + oid + "' was not found within the OID registry");
            throw fault;
        }
        if (value instanceof String) {
            if (log.isDebugEnabled()) {
                log.debug("looked up primary name '" + value + "' with OID '" + oid + "'");
            }
            return (String)value;
        }
        String name = (String)((List)value).get(0);
        if (log.isDebugEnabled()) {
            log.debug("looked up primary name '" + name + "' with OID '" + oid + "'");
        }
        return name;
    }

    public List getNameSet(String oid) throws NamingException {
        Object value = this.byOid.get(oid);
        if (null == value) {
            NamingException fault = new NamingException("OID '" + oid + "' was not found within the OID registry");
            throw fault;
        }
        if (value instanceof String) {
            List list = Collections.singletonList(value);
            if (log.isDebugEnabled()) {
                log.debug("looked up names '" + list + "' for OID '" + oid + "'");
            }
            return list;
        }
        if (log.isDebugEnabled()) {
            log.debug("looked up names '" + value + "' for OID '" + oid + "'");
        }
        return (List)value;
    }

    public Iterator list() {
        return Collections.unmodifiableSet(this.byOid.keySet()).iterator();
    }

    public Map getOidByName() {
        return this.byName;
    }

    public Map getNameByOid() {
        return this.byOid;
    }

    public void register(String name, String oid) {
        Object value;
        if (!Character.isDigit(oid.charAt(0))) {
            throw new RuntimeException("Swap the parameter order: the oid does not start with a digit!");
        }
        String lowerCase = name.toLowerCase();
        if (!lowerCase.equals(name)) {
            this.byName.put(lowerCase, oid);
        }
        this.byName.put(name, oid);
        this.byName.put(oid, oid);
        if (!this.byOid.containsKey(oid)) {
            value = name;
        } else {
            value = this.byOid.get(oid);
            if (value instanceof String) {
                Object existingName = value;
                if (((String)existingName).equalsIgnoreCase(name)) {
                    return;
                }
                ArrayList<String> list = new ArrayList<String>();
                list.add(name);
                list.add((String)value);
                value = list;
            } else if (value instanceof ArrayList) {
                ArrayList list = (ArrayList)value;
                for (int ii = 0; ii < list.size(); ++ii) {
                    if (name.equalsIgnoreCase((String)list.get(ii))) continue;
                    return;
                }
                list.add(name);
            }
        }
        this.byOid.put(oid, value);
        if (log.isDebugEnabled()) {
            log.debug("registed name '" + name + "' with OID: " + oid);
        }
    }

    public void unregister(String numericOid) throws NamingException {
        this.byOid.remove(numericOid);
        Iterator<String> names = this.byName.keySet().iterator();
        ArrayList<String> namesToRemove = new ArrayList<String>();
        while (names.hasNext()) {
            String name = names.next();
            if (!numericOid.equals(this.byName.get(name))) continue;
            namesToRemove.add(name);
        }
        for (String name : namesToRemove) {
            this.byName.remove(name);
        }
    }
}

