
/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *  
 *    http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License. 
 *  
 */
package org.apache.directory.server.schema.bootstrap;


import java.util.ArrayList;
import javax.naming.NamingException;
import org.apache.directory.shared.ldap.schema.ObjectClassTypeEnum;
import org.apache.directory.server.schema.registries.Registries;


/**
 * A producer of schema objectClass definations for the cosine schema.  This
 * code has been automatically generated using schema files in the OpenLDAP
 * format along with the directory plugin for maven.  This has been done
 * to facilitate OpenLDAP schema interoperability.
 *
 * @author <a href="mailto:dev@directory.apache.org">Apache Directory Project</a>
 */
public class CosineObjectClassProducer extends AbstractBootstrapProducer
{

    public CosineObjectClassProducer()
    {
        super( ProducerTypeEnum.OBJECT_CLASS_PRODUCER );
    }


    // ------------------------------------------------------------------------
    // BootstrapProducer Methods
    // ------------------------------------------------------------------------


    /**
     * @see BootstrapProducer#produce(Registries, ProducerCallback)
     */
    public void produce( Registries registries, ProducerCallback cb )
        throws NamingException
    {
        ArrayList<String> array = new ArrayList<String>();
        BootstrapObjectClass objectClass;

        // --------------------------------------------------------------------
        // ObjectClass 0.9.2342.19200300.100.4.4 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "0.9.2342.19200300.100.4.4", registries );
        objectClass.setObsolete( false );

        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );

        // set superior objectClasses
        array.clear();
        array.add( "person" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );

        // set must list
        array.clear();
        objectClass.setMustListIds( array.toArray( EMPTY ) );

        // set may list
        array.clear();
        array.add( "userid" );
        array.add( "textEncodedORAddress" );
        array.add( "rfc822Mailbox" );
        array.add( "favouriteDrink" );
        array.add( "roomNumber" );
        array.add( "userClass" );
        array.add( "homeTelephoneNumber" );
        array.add( "homePostalAddress" );
        array.add( "secretary" );
        array.add( "personalTitle" );
        array.add( "preferredDeliveryMethod" );
        array.add( "businessCategory" );
        array.add( "janetMailbox" );
        array.add( "otherMailbox" );
        array.add( "mobileTelephoneNumber" );
        array.add( "pagerTelephoneNumber" );
        array.add( "organizationalStatus" );
        array.add( "mailPreferenceOption" );
        array.add( "personalSignature" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );

        // set names
        array.clear();
        array.add( "pilotPerson" );
        array.add( "newPilotPerson" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.4.4", objectClass );
        // --------------------------------------------------------------------
        // ObjectClass 0.9.2342.19200300.100.4.5 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "0.9.2342.19200300.100.4.5", registries );
        objectClass.setObsolete( false );

        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );

        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );

        // set must list
        array.clear();
        array.add( "userid" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );

        // set may list
        array.clear();
        array.add( "description" );
        array.add( "seeAlso" );
        array.add( "localityName" );
        array.add( "organizationName" );
        array.add( "organizationalUnitName" );
        array.add( "host" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );

        // set names
        array.clear();
        array.add( "account" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.4.5", objectClass );
        // --------------------------------------------------------------------
        // ObjectClass 0.9.2342.19200300.100.4.6 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "0.9.2342.19200300.100.4.6", registries );
        objectClass.setObsolete( false );

        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );

        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );

        // set must list
        array.clear();
        array.add( "documentIdentifier" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );

        // set may list
        array.clear();
        array.add( "commonName" );
        array.add( "description" );
        array.add( "seeAlso" );
        array.add( "localityName" );
        array.add( "organizationName" );
        array.add( "organizationalUnitName" );
        array.add( "documentTitle" );
        array.add( "documentVersion" );
        array.add( "documentAuthor" );
        array.add( "documentLocation" );
        array.add( "documentPublisher" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );

        // set names
        array.clear();
        array.add( "document" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.4.6", objectClass );
        // --------------------------------------------------------------------
        // ObjectClass 0.9.2342.19200300.100.4.7 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "0.9.2342.19200300.100.4.7", registries );
        objectClass.setObsolete( false );

        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );

        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );

        // set must list
        array.clear();
        array.add( "commonName" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );

        // set may list
        array.clear();
        array.add( "roomNumber" );
        array.add( "description" );
        array.add( "seeAlso" );
        array.add( "telephoneNumber" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );

        // set names
        array.clear();
        array.add( "room" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.4.7", objectClass );
        // --------------------------------------------------------------------
        // ObjectClass 0.9.2342.19200300.100.4.9 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "0.9.2342.19200300.100.4.9", registries );
        objectClass.setObsolete( false );

        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );

        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );

        // set must list
        array.clear();
        array.add( "commonName" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );

        // set may list
        array.clear();
        array.add( "description" );
        array.add( "seeAlso" );
        array.add( "telephonenumber" );
        array.add( "localityName" );
        array.add( "organizationName" );
        array.add( "organizationalUnitName" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );

        // set names
        array.clear();
        array.add( "documentSeries" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.4.9", objectClass );
        // --------------------------------------------------------------------
        // ObjectClass 0.9.2342.19200300.100.4.13 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "0.9.2342.19200300.100.4.13", registries );
        objectClass.setObsolete( false );

        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );

        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );

        // set must list
        array.clear();
        array.add( "domainComponent" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );

        // set may list
        array.clear();
        array.add( "associatedName" );
        array.add( "organizationName" );
        array.add( "description" );
        array.add( "businessCategory" );
        array.add( "seeAlso" );
        array.add( "searchGuide" );
        array.add( "userPassword" );
        array.add( "localityName" );
        array.add( "stateOrProvinceName" );
        array.add( "streetAddress" );
        array.add( "physicalDeliveryOfficeName" );
        array.add( "postalAddress" );
        array.add( "postalCode" );
        array.add( "postOfficeBox" );
        array.add( "streetAddress" );
        array.add( "facsimileTelephoneNumber" );
        array.add( "internationalISDNNumber" );
        array.add( "telephoneNumber" );
        array.add( "teletexTerminalIdentifier" );
        array.add( "telexNumber" );
        array.add( "preferredDeliveryMethod" );
        array.add( "destinationIndicator" );
        array.add( "registeredAddress" );
        array.add( "x121Address" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );

        // set names
        array.clear();
        array.add( "domain" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.4.13", objectClass );
        // --------------------------------------------------------------------
        // ObjectClass 0.9.2342.19200300.100.4.14 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "0.9.2342.19200300.100.4.14", registries );
        objectClass.setObsolete( false );

        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );

        // set superior objectClasses
        array.clear();
        array.add( "domain" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );

        // set must list
        array.clear();
        objectClass.setMustListIds( array.toArray( EMPTY ) );

        // set may list
        array.clear();
        array.add( "commonName" );
        array.add( "surname" );
        array.add( "description" );
        array.add( "seeAlso" );
        array.add( "telephoneNumber" );
        array.add( "physicalDeliveryOfficeName" );
        array.add( "postalAddress" );
        array.add( "postalCode" );
        array.add( "postOfficeBox" );
        array.add( "streetAddress" );
        array.add( "facsimileTelephoneNumber" );
        array.add( "internationalISDNNumber" );
        array.add( "telephoneNumber" );
        array.add( "teletexTerminalIdentifier" );
        array.add( "telexNumber" );
        array.add( "preferredDeliveryMethod" );
        array.add( "destinationIndicator" );
        array.add( "registeredAddress" );
        array.add( "x121Address" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );

        // set names
        array.clear();
        array.add( "RFC822localPart" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.4.14", objectClass );
        // --------------------------------------------------------------------
        // ObjectClass 0.9.2342.19200300.100.4.15 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "0.9.2342.19200300.100.4.15", registries );
        objectClass.setObsolete( false );

        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );

        // set superior objectClasses
        array.clear();
        array.add( "domain" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );

        // set must list
        array.clear();
        objectClass.setMustListIds( array.toArray( EMPTY ) );

        // set may list
        array.clear();
        array.add( "ARecord" );
        array.add( "MDRecord" );
        array.add( "MXRecord" );
        array.add( "NSRecord" );
        array.add( "SOARecord" );
        array.add( "CNAMERecord" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );

        // set names
        array.clear();
        array.add( "dNSDomain" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.4.15", objectClass );
        // --------------------------------------------------------------------
        // ObjectClass 0.9.2342.19200300.100.4.17 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "0.9.2342.19200300.100.4.17", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "RFC1274: an object related to an domain" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.AUXILIARY );

        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );

        // set must list
        array.clear();
        array.add( "associatedDomain" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );

        // set may list
        array.clear();
        objectClass.setMayListIds( array.toArray( EMPTY ) );

        // set names
        array.clear();
        array.add( "domainRelatedObject" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.4.17", objectClass );
        // --------------------------------------------------------------------
        // ObjectClass 0.9.2342.19200300.100.4.18 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "0.9.2342.19200300.100.4.18", registries );
        objectClass.setObsolete( false );

        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );

        // set superior objectClasses
        array.clear();
        array.add( "country" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );

        // set must list
        array.clear();
        array.add( "friendlyCountryName" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );

        // set may list
        array.clear();
        objectClass.setMayListIds( array.toArray( EMPTY ) );

        // set names
        array.clear();
        array.add( "friendlyCountry" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.4.18", objectClass );
        // --------------------------------------------------------------------
        // ObjectClass 0.9.2342.19200300.100.4.20 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "0.9.2342.19200300.100.4.20", registries );
        objectClass.setObsolete( false );

        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );

        // set superior objectClasses
        array.clear();
        array.add( "organization" );
        array.add( "organizationalUnit" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );

        // set must list
        array.clear();
        objectClass.setMustListIds( array.toArray( EMPTY ) );

        // set may list
        array.clear();
        array.add( "buildingName" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );

        // set names
        array.clear();
        array.add( "pilotOrganization" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.4.20", objectClass );
        // --------------------------------------------------------------------
        // ObjectClass 0.9.2342.19200300.100.4.21 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "0.9.2342.19200300.100.4.21", registries );
        objectClass.setObsolete( false );

        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );

        // set superior objectClasses
        array.clear();
        array.add( "dsa" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );

        // set must list
        array.clear();
        objectClass.setMustListIds( array.toArray( EMPTY ) );

        // set may list
        array.clear();
        array.add( "dSAQuality" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );

        // set names
        array.clear();
        array.add( "pilotDSA" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.4.21", objectClass );
        // --------------------------------------------------------------------
        // ObjectClass 0.9.2342.19200300.100.4.22 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "0.9.2342.19200300.100.4.22", registries );
        objectClass.setObsolete( false );

        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.AUXILIARY );

        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );

        // set must list
        array.clear();
        array.add( "dsaQuality" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );

        // set may list
        array.clear();
        array.add( "subtreeMinimumQuality" );
        array.add( "subtreeMaximumQuality" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );

        // set names
        array.clear();
        array.add( "qualityLabelledData" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.4.22", objectClass );
    }
}
