/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.schema.bootstrap;

import java.util.Comparator;
import javax.naming.NamingException;
import org.apache.directory.server.schema.bootstrap.BootstrapProducer;
import org.apache.directory.server.schema.bootstrap.ProducerTypeEnum;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.server.schema.registries.ComparatorRegistry;
import org.apache.directory.server.schema.registries.MatchingRuleRegistry;
import org.apache.directory.server.schema.registries.NormalizerRegistry;
import org.apache.directory.server.schema.registries.ObjectClassRegistry;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.server.schema.registries.SyntaxCheckerRegistry;
import org.apache.directory.server.schema.registries.SyntaxRegistry;
import org.apache.directory.shared.ldap.schema.AbstractAttributeType;
import org.apache.directory.shared.ldap.schema.AbstractMatchingRule;
import org.apache.directory.shared.ldap.schema.AbstractSchemaObject;
import org.apache.directory.shared.ldap.schema.AbstractSyntax;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.ObjectClass;
import org.apache.directory.shared.ldap.schema.ObjectClassTypeEnum;
import org.apache.directory.shared.ldap.schema.Syntax;
import org.apache.directory.shared.ldap.schema.UsageEnum;
import org.apache.directory.shared.ldap.schema.syntax.SyntaxChecker;

public abstract class AbstractBootstrapProducer
implements BootstrapProducer {
    protected static final String[] EMPTY = new String[0];
    private final ProducerTypeEnum type;

    protected AbstractBootstrapProducer(ProducerTypeEnum type) {
        this.type = type;
    }

    public ProducerTypeEnum getType() {
        return this.type;
    }

    protected static BootstrapSyntax newSyntax(String oid, Registries registries) {
        return new BootstrapSyntax(oid, registries.getSyntaxCheckerRegistry());
    }

    protected static BootstrapAttributeType newAttributeType(String oid, Registries registries) {
        return new BootstrapAttributeType(oid, registries);
    }

    protected static BootstrapObjectClass newObjectClass(String oid, Registries registries) {
        return new BootstrapObjectClass(oid, registries);
    }

    public static class BootstrapObjectClass
    extends AbstractSchemaObject
    implements ObjectClass {
        private static final long serialVersionUID = 1L;
        private final ObjectClassRegistry objectClassRegistry;
        private final AttributeTypeRegistry attributeTypeRegistry;
        private String[] superClassIds = EMPTY;
        private ObjectClass[] superClasses;
        private ObjectClassTypeEnum type = ObjectClassTypeEnum.STRUCTURAL;
        private String[] mayListIds = EMPTY;
        private AttributeType[] mayList;
        private String[] mustListIds = EMPTY;
        private AttributeType[] mustList;

        public BootstrapObjectClass(String oid, Registries registries) {
            super(oid);
            this.objectClassRegistry = registries.getObjectClassRegistry();
            this.attributeTypeRegistry = registries.getAttributeTypeRegistry();
        }

        public ObjectClass[] getSuperClasses() throws NamingException {
            if (this.superClasses == null) {
                this.superClasses = new ObjectClass[this.superClassIds.length];
            }
            for (int ii = 0; ii < this.superClassIds.length; ++ii) {
                this.superClasses[ii] = this.objectClassRegistry.lookup(this.superClassIds[ii]);
            }
            return this.superClasses;
        }

        public void setSuperClassIds(String[] superClassIds) {
            this.superClassIds = superClassIds;
        }

        public ObjectClassTypeEnum getType() {
            return this.type;
        }

        public boolean isStructural() {
            return this.type == ObjectClassTypeEnum.STRUCTURAL;
        }

        public boolean isAbstract() {
            return this.type == ObjectClassTypeEnum.ABSTRACT;
        }

        public boolean isAuxiliary() {
            return this.type == ObjectClassTypeEnum.AUXILIARY;
        }

        public void setSchema(String schema) {
            super.setSchema(schema);
        }

        public void setType(ObjectClassTypeEnum type) {
            this.type = type;
        }

        public AttributeType[] getMustList() throws NamingException {
            if (this.mustList == null) {
                this.mustList = new AttributeType[this.mustListIds.length];
            }
            for (int ii = 0; ii < this.mustListIds.length; ++ii) {
                this.mustList[ii] = this.attributeTypeRegistry.lookup(this.mustListIds[ii]);
            }
            return this.mustList;
        }

        public void setMustListIds(String[] mustListIds) {
            this.mustListIds = mustListIds;
        }

        public AttributeType[] getMayList() throws NamingException {
            if (this.mayList == null) {
                this.mayList = new AttributeType[this.mayListIds.length];
            }
            for (int ii = 0; ii < this.mayListIds.length; ++ii) {
                this.mayList[ii] = this.attributeTypeRegistry.lookup(this.mayListIds[ii]);
            }
            return this.mayList;
        }

        public void setMayListIds(String[] mayListIds) {
            this.mayListIds = mayListIds;
        }

        public void setObsolete(boolean obsolete) {
            super.setObsolete(obsolete);
        }

        public void setNames(String[] names) {
            super.setNames(names);
        }

        public void setDescription(String description) {
            super.setDescription(description);
        }
    }

    public static class BootstrapAttributeType
    extends AbstractAttributeType {
        private static final long serialVersionUID = 4050205236738471984L;
        private final SyntaxRegistry syntaxRegistry;
        private final MatchingRuleRegistry matchingRuleRegistry;
        private final AttributeTypeRegistry attributeTypeRegistry;
        private String superiorId;
        private String equalityId;
        private MatchingRule equalityMR;
        private String substrId;
        private MatchingRule substrMR;
        private String orderingId;
        private MatchingRule orderingMR;
        private String syntaxId;
        private Syntax syntax;

        public BootstrapAttributeType(String oid, Registries registries) {
            super(oid);
            this.syntaxRegistry = registries.getSyntaxRegistry();
            this.matchingRuleRegistry = registries.getMatchingRuleRegistry();
            this.attributeTypeRegistry = registries.getAttributeTypeRegistry();
        }

        public void setSuperiorId(String superiorId) {
            this.superiorId = superiorId;
        }

        public void setSchema(String schema) {
            super.setSchema(schema);
        }

        public AttributeType getSuperior() throws NamingException {
            if (this.superiorId == null) {
                return null;
            }
            return this.attributeTypeRegistry.lookup(this.superiorId);
        }

        public void setNames(String[] names) {
            super.setNames(names);
        }

        public MatchingRule getEquality() throws NamingException {
            if (this.equalityMR == null) {
                if (this.equalityId != null) {
                    this.equalityMR = this.matchingRuleRegistry.lookup(this.equalityId);
                } else if (this.superiorId != null) {
                    this.equalityMR = this.getSuperior().getEquality();
                }
            }
            return this.equalityMR;
        }

        public void setEqualityId(String equalityId) {
            this.equalityId = equalityId;
        }

        public MatchingRule getSubstr() throws NamingException {
            if (this.substrMR == null) {
                if (this.substrId != null) {
                    this.substrMR = this.matchingRuleRegistry.lookup(this.substrId);
                } else if (this.superiorId != null) {
                    this.substrMR = this.getSuperior().getSubstr();
                }
            }
            return this.substrMR;
        }

        public boolean isAncestorOf(AttributeType attributeType) throws NamingException {
            return false;
        }

        public boolean isDescentantOf(AttributeType attributeType) throws NamingException {
            return false;
        }

        public void setSubstrId(String substrId) {
            this.substrId = substrId;
        }

        public MatchingRule getOrdering() throws NamingException {
            if (this.orderingMR == null) {
                if (this.orderingId != null) {
                    this.orderingMR = this.matchingRuleRegistry.lookup(this.orderingId);
                } else if (this.superiorId != null) {
                    this.orderingMR = this.getSuperior().getOrdering();
                }
            }
            return this.orderingMR;
        }

        public void setOrderingId(String orderingId) {
            this.orderingId = orderingId;
        }

        public void setSyntaxId(String syntaxId) {
            this.syntaxId = syntaxId;
        }

        public Syntax getSyntax() throws NamingException {
            if (this.syntax == null) {
                if (this.syntaxId != null) {
                    this.syntax = this.syntaxRegistry.lookup(this.syntaxId);
                } else if (this.superiorId != null) {
                    this.syntax = this.getSuperior().getSyntax();
                }
            }
            return this.syntax;
        }

        public void setSingleValue(boolean singleValue) {
            super.setSingleValue(singleValue);
        }

        public void setCollective(boolean collective) {
            super.setCollective(collective);
        }

        public void setCanUserModify(boolean canUserModify) {
            super.setCanUserModify(canUserModify);
        }

        public void setObsolete(boolean obsolete) {
            super.setObsolete(obsolete);
        }

        public void setDescription(String description) {
            super.setDescription(description);
        }

        public void setUsage(UsageEnum usage) {
            super.setUsage(usage);
        }

        public void setLength(int length) {
            super.setLength(length);
        }
    }

    public static class BootstrapMatchingRule
    extends AbstractMatchingRule {
        private static final long serialVersionUID = 1L;
        final SyntaxRegistry syntaxRegistry;
        final NormalizerRegistry normalizerRegistry;
        final ComparatorRegistry comparatorRegistry;
        String syntaxOid;

        public BootstrapMatchingRule(String oid, Registries registries) {
            super(oid);
            this.syntaxRegistry = registries.getSyntaxRegistry();
            this.normalizerRegistry = registries.getNormalizerRegistry();
            this.comparatorRegistry = registries.getComparatorRegistry();
        }

        public void setNames(String[] names) {
            super.setNames(names);
        }

        public void setSchema(String schema) {
            super.setSchema(schema);
        }

        public void setSyntaxOid(String syntaxOid) {
            this.syntaxOid = syntaxOid;
        }

        public void setDescription(String description) {
            super.setDescription(description);
        }

        public void setObsolete(boolean isObsolete) {
            super.setObsolete(isObsolete);
        }

        public Syntax getSyntax() throws NamingException {
            return this.syntaxRegistry.lookup(this.syntaxOid);
        }

        public Comparator getComparator() throws NamingException {
            return this.comparatorRegistry.lookup(this.getOid());
        }

        public Normalizer getNormalizer() throws NamingException {
            return this.normalizerRegistry.lookup(this.getOid());
        }
    }

    public static class BootstrapSyntax
    extends AbstractSyntax {
        private static final long serialVersionUID = 1L;
        final SyntaxCheckerRegistry registry;

        public BootstrapSyntax(String oid, SyntaxCheckerRegistry registry) {
            super(oid);
            this.registry = registry;
        }

        public void setSchema(String schema) {
            super.setSchema(schema);
        }

        public void setDescription(String description) {
            super.setDescription(description);
        }

        public void setHumanReadable(boolean isHumanReadable) {
            super.setHumanReadable(isHumanReadable);
        }

        public void setNames(String[] names) {
            super.setNames(names);
        }

        public SyntaxChecker getSyntaxChecker() throws NamingException {
            return this.registry.lookup(this.getOid());
        }

        public boolean isObsolete() {
            return false;
        }
    }
}

