/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.protocol.shared.store;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.protocol.shared.store.LdifLoadFilter;
import org.apache.directory.shared.ldap.model.entry.DefaultEntry;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.ldif.LdifEntry;
import org.apache.directory.shared.ldap.model.ldif.LdifReader;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdifFileLoader {
    private static final Logger log = LoggerFactory.getLogger(LdifFileLoader.class);
    protected CoreSession coreSession;
    protected File ldif;
    protected final List<LdifLoadFilter> filters;
    protected final ClassLoader loader;
    private int count;

    public LdifFileLoader(CoreSession coreSession, String ldif) {
        this(coreSession, new File(ldif), null);
    }

    public LdifFileLoader(CoreSession coreSession, File ldif, List<? extends LdifLoadFilter> filters) {
        this(coreSession, ldif, filters, null);
    }

    public LdifFileLoader(CoreSession coreSession, File ldif, List<? extends LdifLoadFilter> filters, ClassLoader loader) {
        this.coreSession = coreSession;
        this.ldif = ldif;
        this.loader = loader;
        this.filters = filters == null ? Collections.emptyList() : Collections.unmodifiableList(filters);
    }

    private boolean applyFilters(Dn dn, Entry entry) {
        boolean accept = true;
        int limit = this.filters.size();
        if (limit == 0) {
            return true;
        }
        for (int ii = 0; ii < limit; ++ii) {
            try {
                accept &= this.filters.get(ii).filter(this.ldif, dn, entry, this.coreSession);
            }
            catch (LdapException e) {
                log.warn("filter " + this.filters.get(ii) + " was bypassed due to failures", (Throwable)e);
            }
            if (accept) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() {
        InputStream in = null;
        try {
            in = this.getLdifStream();
            for (LdifEntry ldifEntry : new LdifReader(in)) {
                Dn dn = ldifEntry.getDn();
                if (ldifEntry.isEntry()) {
                    Entry entry = ldifEntry.getEntry();
                    boolean filterAccepted = this.applyFilters(dn, entry);
                    if (!filterAccepted) continue;
                    try {
                        this.coreSession.lookup(dn);
                        log.info("Found {}, will not create.", (Object)dn);
                    }
                    catch (Exception e) {
                        try {
                            this.coreSession.add((Entry)new DefaultEntry(this.coreSession.getDirectoryService().getSchemaManager(), entry));
                            ++this.count;
                            log.info("Created {}.", (Object)dn);
                        }
                        catch (LdapException e1) {
                            log.info("Could not create entry " + entry, (Throwable)e1);
                        }
                    }
                    continue;
                }
                List items = ldifEntry.getModifications();
                try {
                    this.coreSession.modify(dn, items);
                    log.info("Modified: " + dn + " with modificationItems: " + items);
                }
                catch (LdapException e) {
                    log.info("Could not modify: " + dn + " with modificationItems: " + items, (Throwable)e);
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            log.error(I18n.err((I18n)I18n.ERR_173, (Object[])new Object[0]));
        }
        catch (Exception ioe) {
            log.error(I18n.err((I18n)I18n.ERR_174, (Object[])new Object[0]), (Throwable)ioe);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    log.error(I18n.err((I18n)I18n.ERR_175, (Object[])new Object[0]), (Throwable)e);
                }
            }
        }
        return this.count;
    }

    private InputStream getLdifStream() throws FileNotFoundException {
        if (!this.ldif.exists()) {
            InputStream in;
            if (this.loader != null && (in = this.loader.getResourceAsStream(this.ldif.getName())) != null) {
                return in;
            }
            in = this.getClass().getResourceAsStream(this.ldif.getName());
            if (in != null) {
                return in;
            }
            in = ClassLoader.getSystemResourceAsStream(this.ldif.getName());
            if (in != null) {
                return in;
            }
            throw new FileNotFoundException(I18n.err((I18n)I18n.ERR_173, (Object[])new Object[0]));
        }
        FileInputStream in = new FileInputStream(this.ldif);
        return in;
    }
}

