/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.protocol.shared;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.CompoundName;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import junit.framework.TestCase;
import org.apache.directory.server.core.configuration.DirectoryPartitionConfiguration;
import org.apache.directory.server.core.configuration.MutableDirectoryPartitionConfiguration;
import org.apache.directory.server.core.configuration.MutableStartupConfiguration;
import org.apache.directory.server.core.configuration.ShutdownConfiguration;
import org.apache.directory.server.core.jndi.CoreContextFactory;
import org.apache.directory.server.core.schema.bootstrap.ApacheSchema;
import org.apache.directory.server.core.schema.bootstrap.ApachednsSchema;
import org.apache.directory.server.core.schema.bootstrap.CoreSchema;
import org.apache.directory.server.core.schema.bootstrap.CosineSchema;
import org.apache.directory.server.core.schema.bootstrap.InetorgpersonSchema;
import org.apache.directory.server.core.schema.bootstrap.Krb5kdcSchema;
import org.apache.directory.server.core.schema.bootstrap.SystemSchema;
import org.apache.directory.shared.ldap.ldif.LdifIterator;
import org.apache.directory.shared.ldap.ldif.LdifParserImpl;
import org.apache.directory.shared.ldap.message.LockableAttributeImpl;
import org.apache.directory.shared.ldap.message.LockableAttributesImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBackingStoreTest
extends TestCase {
    private static final Logger log = LoggerFactory.getLogger((Class)AbstractBackingStoreTest.class);
    protected boolean doDelete = true;
    protected MutableStartupConfiguration config;
    protected CoreContextFactory factory;
    protected Hashtable env;

    protected void setUp() throws Exception {
        this.env = new Hashtable(this.setUpPartition());
        this.env.put("java.naming.security.principal", "uid=admin,ou=system");
        this.env.put("java.naming.security.authentication", "simple");
        this.env.put("java.naming.security.credentials", "secret");
        this.env.put("java.naming.factory.initial", "org.apache.directory.server.core.jndi.CoreContextFactory");
        this.env.put("java.naming.provider.url", "ou=system");
        this.factory = new CoreContextFactory();
    }

    protected void loadPartition(String partition, String ldifFile) throws NamingException {
        this.env.put("java.naming.provider.url", partition);
        DirContext ctx = (DirContext)this.factory.getInitialContext(this.env);
        this.load(ctx, ldifFile);
    }

    protected void doTestSystemPartition() throws Exception {
        this.env.put("java.naming.provider.url", "ou=system");
        DirContext ctx = (DirContext)this.factory.getInitialContext(this.env);
        Attributes attributes = ctx.getAttributes("cn=A,dc=www,dc=apache,dc=org,ou=Zones");
        AbstractBackingStoreTest.assertEquals((int)3, (int)attributes.size());
    }

    protected void doTestApacheZone() throws Exception {
        this.env.put("java.naming.provider.url", "dc=apache,dc=org");
        DirContext ctx = (DirContext)this.factory.getInitialContext(this.env);
        Attributes attributes = ctx.getAttributes("cn=A,dc=www,dc=apache,dc=org,ou=Zones");
        AbstractBackingStoreTest.assertEquals((int)3, (int)attributes.size());
    }

    protected void doTestExampleZone() throws Exception {
        this.env.put("java.naming.provider.url", "dc=example,dc=com");
        DirContext ctx = (DirContext)this.factory.getInitialContext(this.env);
        Attributes attributes = ctx.getAttributes("cn=A,dc=www,dc=example,dc=com,ou=Zones");
        AbstractBackingStoreTest.assertEquals((int)3, (int)attributes.size());
    }

    protected Hashtable setUpPartition() throws NamingException {
        this.config = new MutableStartupConfiguration();
        HashSet<Object> schemas = new HashSet<Object>();
        schemas.add(new CoreSchema());
        schemas.add(new CosineSchema());
        schemas.add(new ApacheSchema());
        schemas.add(new InetorgpersonSchema());
        schemas.add(new Krb5kdcSchema());
        schemas.add(new SystemSchema());
        schemas.add(new ApachednsSchema());
        this.config.setBootstrapSchemas(schemas);
        HashSet<DirectoryPartitionConfiguration> partitions = new HashSet<DirectoryPartitionConfiguration>();
        partitions.add(this.getExamplePartition());
        partitions.add(this.getApachePartition());
        this.config.setContextPartitionConfigurations(Collections.unmodifiableSet(partitions));
        return this.config.toJndiEnvironment();
    }

    private DirectoryPartitionConfiguration getExamplePartition() throws NamingException {
        MutableDirectoryPartitionConfiguration partConfig = new MutableDirectoryPartitionConfiguration();
        partConfig.setName("example");
        HashSet<String> indices = new HashSet<String>();
        indices.add("dc");
        indices.add("ou");
        indices.add("objectClass");
        indices.add("krb5PrincipalName");
        indices.add("uid");
        partConfig.setIndexedAttributes(indices);
        partConfig.setSuffix("dc=example, dc=com");
        LockableAttributesImpl attrs = new LockableAttributesImpl();
        LockableAttributeImpl objectClass = new LockableAttributeImpl("objectClass");
        objectClass.add((Object)"top");
        objectClass.add((Object)"domain");
        attrs.put((Attribute)objectClass);
        attrs.put("dc", (Object)"example");
        partConfig.setContextEntry((Attributes)attrs);
        return partConfig;
    }

    private DirectoryPartitionConfiguration getApachePartition() throws NamingException {
        MutableDirectoryPartitionConfiguration partConfig = new MutableDirectoryPartitionConfiguration();
        partConfig.setName("apache");
        HashSet<String> indices = new HashSet<String>();
        indices.add("dc");
        indices.add("ou");
        indices.add("objectClass");
        indices.add("krb5PrincipalName");
        indices.add("uid");
        partConfig.setIndexedAttributes(indices);
        partConfig.setSuffix("dc=apache, dc=org");
        LockableAttributesImpl attrs = new LockableAttributesImpl();
        LockableAttributeImpl objectClass = new LockableAttributeImpl("objectClass");
        objectClass.add((Object)"top");
        objectClass.add((Object)"domain");
        attrs.put((Attribute)objectClass);
        attrs.put("dc", (Object)"apache");
        partConfig.setContextEntry((Attributes)attrs);
        return partConfig;
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.provider.url", "ou=system");
        env.put("java.naming.factory.initial", CoreContextFactory.class.getName());
        env.putAll(new ShutdownConfiguration().toJndiEnvironment());
        env.put("java.naming.security.principal", "uid=admin,ou=system");
        env.put("java.naming.security.credentials", "secret");
        env.put("java.naming.security.authentication", "simple");
        new InitialContext(env);
        this.doDelete(this.config.getWorkingDirectory());
    }

    protected void doDelete(File wkdir) throws IOException {
        if (this.doDelete) {
            if (wkdir.exists()) {
                this.recursiveRemoveDir(wkdir);
            }
            if (wkdir.exists()) {
                throw new IOException("Failed to delete: " + wkdir);
            }
        }
    }

    private void recursiveRemoveDir(File directory) {
        String[] filelist = directory.list();
        File tmpFile = null;
        for (int ii = 0; ii < filelist.length; ++ii) {
            tmpFile = new File(directory.getAbsolutePath(), filelist[ii]);
            if (tmpFile.isDirectory()) {
                this.recursiveRemoveDir(tmpFile);
                continue;
            }
            if (!tmpFile.isFile()) continue;
            tmpFile.delete();
        }
        directory.delete();
    }

    protected void load(DirContext ctx, String ldifPath) {
        String dn;
        LockableAttributesImpl attributes;
        String ldif;
        LdifParserImpl ldifParser;
        LdifIterator iterator;
        InputStream in;
        Name rdn = null;
        try {
            in = this.getLdifStream(ldifPath);
            iterator = new LdifIterator(in);
            ldifParser = new LdifParserImpl();
            while (iterator.hasNext()) {
                ldif = (String)iterator.next();
                attributes = new LockableAttributesImpl();
                ldifParser.parse((Attributes)attributes, ldif);
                dn = (String)attributes.remove("dn").get();
                if (attributes.get("objectClass").contains("krb5KDCEntry")) {
                    String pw = (String)attributes.get("userpassword").get();
                    String krbPrincipal = (String)attributes.get("krb5PrincipalName").get();
                    KerberosPrincipal principal = new KerberosPrincipal(krbPrincipal);
                    KerberosKey key = new KerberosKey(principal, pw.toCharArray(), "DES");
                    byte[] encodedKey = key.getEncoded();
                    attributes.put("krb5Key", encodedKey);
                    attributes.put("krb5KeyVersionNumber", Integer.toString(key.getVersionNumber()));
                    attributes.put("krb5EncryptionType", Integer.toString(key.getKeyType()));
                }
                rdn = this.getRelativeName(ctx.getNameInNamespace(), dn);
                try {
                    ctx.lookup(rdn);
                    log.info("Found {}, will not create.", (Object)rdn);
                }
                catch (Exception e) {
                    ctx.createSubcontext(rdn, (Attributes)attributes);
                    log.info("Created {}.", (Object)rdn);
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            log.error("LDIF file does not exist.");
            return;
        }
        catch (IOException ioe) {
            log.error("Failed to import LDIF into backing store.", (Throwable)ioe);
            return;
        }
        catch (NamingException ne) {
            log.error("Failed to import LDIF into backing store.", (Throwable)ne);
            return;
        }
        try {
            in = this.getLdifStream(ldifPath);
            iterator = new LdifIterator(in);
            ldifParser = new LdifParserImpl();
            while (iterator.hasNext()) {
                ldif = (String)iterator.next();
                attributes = new LockableAttributesImpl();
                ldifParser.parse((Attributes)attributes, ldif);
                dn = (String)attributes.remove("dn").get();
                rdn = this.getRelativeName(ctx.getNameInNamespace(), dn);
                Object stored = ctx.lookup(rdn);
                log.debug("Lookup for {} returned {}.", (Object)rdn, stored);
                if (stored != null) continue;
                log.error("{} was null.", (Object)rdn);
                throw new IllegalStateException("LDIF entries not being pushed to disk.");
            }
        }
        catch (Exception e) {
            log.error("Failed to find {}", rdn);
            if (log.isDebugEnabled()) {
                log.error("Failed to import LDIF into backing store.", (Throwable)e);
            } else {
                log.error("Failed to import LDIF into backing store.");
            }
            return;
        }
    }

    private InputStream getLdifStream(String ldifPath) throws FileNotFoundException {
        File file = new File(ldifPath);
        InputStream in = null;
        if (file.exists()) {
            in = new FileInputStream(file);
        } else {
            in = ((Object)((Object)this)).getClass().getResourceAsStream(ldifPath);
            if (in == null) {
                throw new FileNotFoundException("LDIF file does not exist.");
            }
        }
        return in;
    }

    protected Name getRelativeName(String nameInNamespace, String baseDn) throws NamingException {
        Properties props = new Properties();
        props.setProperty("jndi.syntax.direction", "right_to_left");
        props.setProperty("jndi.syntax.separator", ",");
        props.setProperty("jndi.syntax.ignorecase", "true");
        props.setProperty("jndi.syntax.trimblanks", "true");
        CompoundName searchBaseDn = null;
        CompoundName ctxRoot = new CompoundName(nameInNamespace, props);
        searchBaseDn = new CompoundName(baseDn, props);
        if (!searchBaseDn.startsWith(ctxRoot)) {
            throw new NamingException("Invalid search base " + baseDn);
        }
        for (int ii = 0; ii < ctxRoot.size(); ++ii) {
            searchBaseDn.remove(0);
        }
        return searchBaseDn;
    }

    protected String escapedValue(String value) {
        StringBuffer escapedBuf = new StringBuffer();
        String specialChars = "*()\\";
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (specialChars.indexOf(c) >= 0) {
                escapedBuf.append('\\');
                String hexString = Integer.toHexString(c);
                if (hexString.length() < 2) {
                    escapedBuf.append('0');
                }
                escapedBuf.append(hexString);
                continue;
            }
            escapedBuf.append(c);
        }
        return escapedBuf.toString();
    }

    protected void printAttr(Attributes attrs, String id) {
        if (attrs == null || id == null) {
            System.out.println("No attribute");
            return;
        }
        try {
            Attribute attr = attrs.get(id);
            String a = attr != null ? (String)attr.get() : null;
            System.out.println(attr.getID() + ":\t" + a);
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
    }

    protected void printAttrs(Attributes attrs) {
        if (attrs == null) {
            System.out.println("No attributes");
            return;
        }
        try {
            NamingEnumeration<? extends Attribute> ae = attrs.getAll();
            while (ae.hasMore()) {
                Attribute attr = ae.next();
                NamingEnumeration<?> e = attr.getAll();
                while (e.hasMore()) {
                    System.out.println(attr.getID() + ":\t" + e.next());
                }
            }
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
    }
}

