/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ntp.messages;

import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.directory.shared.util.DateUtils;

public class NtpTimeStamp {
    private static final long NTP_EPOCH_DIFFERENCE = -2208988800000L;
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS z");
    private long seconds = 0L;
    private long fraction = 0L;

    public NtpTimeStamp() {
        this(new Date());
    }

    public NtpTimeStamp(Date date) {
        long msSinceStartOfNtpEpoch = date.getTime() - -2208988800000L;
        this.seconds = msSinceStartOfNtpEpoch / 1000L;
        this.fraction = msSinceStartOfNtpEpoch % 1000L * 0x100000000L / 1000L;
    }

    public NtpTimeStamp(ByteBuffer data) {
        int ii;
        for (ii = 0; ii < 4; ++ii) {
            this.seconds = 256L * this.seconds + (long)this.makePositive(data.get());
        }
        for (ii = 4; ii < 8; ++ii) {
            this.fraction = 256L * this.fraction + (long)this.makePositive(data.get());
        }
    }

    public void writeTo(ByteBuffer buffer) {
        int ii;
        byte[] bytes = new byte[8];
        long temp = this.seconds;
        for (ii = 3; ii >= 0; --ii) {
            bytes[ii] = (byte)(temp % 256L);
            temp /= 256L;
        }
        temp = this.fraction;
        for (ii = 7; ii >= 4; --ii) {
            bytes[ii] = (byte)(temp % 256L);
            temp /= 256L;
        }
        buffer.put(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        long msSinceStartOfNtpEpoch = this.seconds * 1000L + this.fraction * 1000L / 0x100000000L;
        Date date = new Date(msSinceStartOfNtpEpoch + -2208988800000L);
        SimpleDateFormat simpleDateFormat = dateFormat;
        synchronized (simpleDateFormat) {
            return "org.apache.ntp.message.NtpTimeStamp[ date = " + dateFormat.format(date) + " ]";
        }
    }

    public int hashCode() {
        int hash = 37;
        hash = hash * 17 + Long.valueOf(this.seconds).hashCode();
        hash = hash * 17 + Long.valueOf(this.fraction).hashCode();
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NtpTimeStamp)) {
            return false;
        }
        NtpTimeStamp that = (NtpTimeStamp)o;
        return this.seconds == that.seconds && this.fraction == that.fraction;
    }

    private int makePositive(byte b) {
        int byteAsInt = b;
        return byteAsInt < 0 ? 256 + byteAsInt : byteAsInt;
    }

    static {
        dateFormat.setTimeZone(DateUtils.UTC_TIME_ZONE);
    }
}

