/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ntp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Dictionary;
import org.apache.directory.server.ntp.NtpConfiguration;
import org.apache.directory.server.ntp.protocol.NtpProtocolHandler;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NtpServer {
    private static final Logger log = LoggerFactory.getLogger(NtpServer.class);
    private NtpConfiguration config;
    private IoAcceptor acceptor;
    private IoHandler handler;

    public NtpServer(NtpConfiguration config, IoAcceptor acceptor, IoServiceConfig serviceConfig) {
        this.config = config;
        this.acceptor = acceptor;
        String name = config.getServiceName();
        int port = config.getIpPort();
        try {
            this.handler = new NtpProtocolHandler();
            acceptor.bind((SocketAddress)new InetSocketAddress(port), this.handler, serviceConfig);
            log.debug("{} listening on port {}.", (Object)name, (Object)port);
        }
        catch (IOException ioe) {
            log.error(ioe.getMessage(), (Throwable)ioe);
        }
    }

    public boolean isDifferent(Dictionary newConfig) {
        return this.config.isDifferent(newConfig);
    }

    public void destroy() {
        this.acceptor.unbind((SocketAddress)new InetSocketAddress(this.config.getIpPort()));
        this.acceptor = null;
        this.handler = null;
        log.debug("{} has stopped listening on port {}.", (Object)this.config.getServiceName(), (Object)this.config.getIpPort());
    }
}

