/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ntp;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.apache.directory.server.core.configuration.ConfigurationException;
import org.apache.directory.server.protocol.shared.ServiceConfiguration;

public class NtpConfiguration
extends ServiceConfiguration {
    private static final long serialVersionUID = 2961795205765175775L;
    private static final String DEFAULT_IP_PORT = "123";
    private static final String DEFAULT_PID = "org.apache.ntp";
    private static final String DEFAULT_NAME = "Apache NTP Service";
    private static final String DEFAULT_PREFIX = "ntp.";

    public NtpConfiguration() {
        this(NtpConfiguration.getDefaultConfig(), 1);
    }

    public NtpConfiguration(String instanceId) {
        this(NtpConfiguration.getDefaultConfig(), 1);
        this.setInstanceId(instanceId);
    }

    public NtpConfiguration(Map properties) {
        this(properties, 1);
    }

    public NtpConfiguration(Map properties, int strategy) {
        if (properties == null) {
            this.configuration = NtpConfiguration.getDefaultConfig();
        } else {
            this.loadProperties(DEFAULT_PREFIX, properties, strategy);
        }
        int port = this.getPort();
        if (port < 1 || port > 65535) {
            throw new ConfigurationException("Invalid value:  ipPort=" + port);
        }
    }

    public static Map getDefaultConfig() {
        HashMap<String, String> defaults = new HashMap<String, String>();
        defaults.put("service.pid", DEFAULT_PID);
        defaults.put("ipPort", DEFAULT_IP_PORT);
        return defaults;
    }

    public boolean isDifferent(Dictionary config) {
        int port = this.getPort();
        return port != Integer.parseInt((String)config.get("ipPort"));
    }

    public String getName() {
        return DEFAULT_NAME;
    }

    public int getPort() {
        String key = "ipPort";
        if (this.configuration.containsKey(key)) {
            return Integer.parseInt(this.get(key));
        }
        return Integer.parseInt(DEFAULT_IP_PORT);
    }
}

