/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.replication.provider;

import java.io.IOException;
import java.util.Iterator;
import org.apache.directory.api.ldap.model.cursor.AbstractCursor;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.Tuple;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.message.controls.ChangeType;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmTable;
import org.apache.directory.server.ldap.replication.ReplicaEventMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicaJournalCursor
extends AbstractCursor<ReplicaEventMessage> {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicaJournalCursor.class);
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger((String)"CURSOR");
    private static final boolean IS_DEBUG = LOG_CURSOR.isDebugEnabled();
    private Cursor<Tuple<String, ReplicaEventMessage>> tupleCursor;
    private JdbmTable<String, ReplicaEventMessage> journal;
    private String consumerCsn;
    private ReplicaEventMessage qualifiedEvtMsg;
    private boolean skipQualifying;

    public ReplicaJournalCursor(JdbmTable<String, ReplicaEventMessage> journal, String consumerCsn) throws Exception {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Creating ReplicaJournalCursor {}", (Object)this);
        }
        this.journal = journal;
        this.tupleCursor = journal.cursor();
        this.consumerCsn = consumerCsn;
    }

    public void after(ReplicaEventMessage arg0) throws LdapException, CursorException, IOException {
        throw new UnsupportedOperationException();
    }

    public void afterLast() throws LdapException, CursorException, IOException {
        throw new UnsupportedOperationException();
    }

    public boolean available() {
        return this.qualifiedEvtMsg != null;
    }

    public void before(ReplicaEventMessage arg0) throws LdapException, CursorException, IOException {
        throw new UnsupportedOperationException();
    }

    public void beforeFirst() throws LdapException, CursorException, IOException {
    }

    public boolean first() throws LdapException, CursorException, IOException {
        throw new UnsupportedOperationException();
    }

    public ReplicaEventMessage get() throws CursorException {
        return this.qualifiedEvtMsg;
    }

    private boolean isQualified(String csn, ReplicaEventMessage evtMsg) throws LdapException {
        LOG.debug("ReplicaEventMessage: {}", (Object)evtMsg);
        if (evtMsg.isEventOlderThan(this.consumerCsn)) {
            if (LOG.isDebugEnabled()) {
                String evt = "MODDN";
                ChangeType changeType = evtMsg.getChangeType();
                if (changeType != null) {
                    evt = changeType.name();
                }
                LOG.debug("event {} for dn {} is not qualified for sending", (Object)evt, (Object)evtMsg.getEntry().getDn());
            }
            return false;
        }
        return true;
    }

    public boolean last() throws LdapException, CursorException, IOException {
        throw new UnsupportedOperationException();
    }

    public boolean next() throws LdapException, CursorException, IOException {
        while (this.tupleCursor.next()) {
            Tuple tuple = (Tuple)this.tupleCursor.get();
            String csn = (String)tuple.getKey();
            ReplicaEventMessage message = (ReplicaEventMessage)tuple.getValue();
            if (this.skipQualifying) {
                this.qualifiedEvtMsg = message;
                return true;
            }
            boolean qualified = this.isQualified(csn, message);
            if (qualified) {
                this.qualifiedEvtMsg = message;
                return true;
            }
            this.journal.remove((Object)csn);
        }
        this.qualifiedEvtMsg = null;
        return false;
    }

    public boolean previous() throws LdapException, CursorException, IOException {
        throw new UnsupportedOperationException();
    }

    public void close() {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing ReplicaJournalCursor {}", (Object)this);
        }
        this.tupleCursor.close();
        super.close();
    }

    public void close(Exception cause) {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing ReplicaJournalCursor {}", (Object)this);
        }
        this.tupleCursor.close();
        super.close(cause);
    }

    protected void skipQualifyingWhileFetching() {
        this.skipQualifying = true;
    }

    protected void delete() {
        try {
            if (this.qualifiedEvtMsg != null) {
                this.journal.remove((Object)this.qualifiedEvtMsg.getEntry().get("entryCSN").getString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Iterator<ReplicaEventMessage> iterator() {
        throw new UnsupportedOperationException();
    }
}

