/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.replication.provider;

import java.util.Map;
import org.apache.directory.api.ldap.model.csn.Csn;
import org.apache.directory.api.util.DateUtils;
import org.apache.directory.server.ldap.replication.ReplicaEventMessage;
import org.apache.directory.server.ldap.replication.provider.ReplicaEventLog;
import org.apache.directory.server.ldap.replication.provider.ReplicaJournalCursor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicaEventLogJanitor
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicaEventLogJanitor.class);
    private long thresholdCount;
    private long thresholdTime;
    private Map<Integer, ReplicaEventLog> replicaLogMap;
    private volatile boolean stop = false;

    public ReplicaEventLogJanitor(Map<Integer, ReplicaEventLog> replicaLogMap) {
        this(replicaLogMap, 10000L, 18000000L);
    }

    public ReplicaEventLogJanitor(Map<Integer, ReplicaEventLog> replicaLogMap, long thresholdCount, long thresholdTime) {
        this.replicaLogMap = replicaLogMap;
        this.thresholdCount = thresholdCount;
        this.thresholdTime = thresholdTime;
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.stop) {
            for (ReplicaEventLog log : this.replicaLogMap.values()) {
                if (!log.isRefreshNPersist()) continue;
                ReplicaEventLog replicaEventLog = log;
                synchronized (replicaEventLog) {
                    try {
                        ReplicaEventMessage message;
                        String csnVal;
                        String lastSentCsn = log.getLastSentCsn();
                        if (lastSentCsn == null) {
                            LOG.debug("last sent CSN is null for the replica {}, skipping cleanup", (Object)log.getName());
                            return;
                        }
                        if ((long)log.count() < this.thresholdCount) {
                            return;
                        }
                        LOG.debug("starting to purge the log entries that are older than {} milliseconds", (Object)this.thresholdTime);
                        long now = DateUtils.getDate((String)DateUtils.getGeneralizedTime()).getTime();
                        long deleteCount = 0L;
                        ReplicaJournalCursor cursor = log.getCursor(null);
                        cursor.skipQualifyingWhileFetching();
                        while (cursor.next() && (csnVal = (message = cursor.get()).getEntry().get("entryCSN").getString()).compareTo(lastSentCsn) < 0) {
                            Csn csn = new Csn(csnVal);
                            if (now - csn.getTimestamp() < this.thresholdTime) continue;
                            cursor.delete();
                            ++deleteCount;
                        }
                        cursor.close();
                        LOG.debug("purged {} messages from the log {}", (Object)deleteCount, (Object)log.getName());
                    }
                    catch (Exception e) {
                        LOG.warn("Failed to purge old entries from the log {}", (Object)log.getName(), (Object)e);
                    }
                }
            }
            try {
                Thread.sleep(this.thresholdTime);
            }
            catch (InterruptedException e) {
                LOG.warn("ReplicaEventLogJanitor thread was interrupted, stopping the thread", (Throwable)e);
                this.stop = true;
            }
        }
    }

    public void stopCleaning() {
        this.stop = true;
    }
}

