/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.bind.gssapi;

import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.sasl.AuthorizeCallback;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.LdapPrincipal;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntry;
import org.apache.directory.server.kerberos.shared.store.operations.GetPrincipal;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.bind.AbstractSaslCallbackHandler;
import org.apache.directory.shared.ldap.model.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.message.BindRequest;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.util.StringConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GssapiCallbackHandler
extends AbstractSaslCallbackHandler {
    private static final Logger LOG = LoggerFactory.getLogger(GssapiCallbackHandler.class);

    public GssapiCallbackHandler(LdapSession ldapSession, CoreSession adminSession, BindRequest bindRequest) {
        super(adminSession.getDirectoryService(), bindRequest);
        this.ldapSession = ldapSession;
        this.adminSession = adminSession;
    }

    @Override
    protected Attribute lookupPassword(String username, String password) {
        return null;
    }

    @Override
    protected void authorize(AuthorizeCallback authorizeCB) throws Exception {
        LOG.debug("Processing conversion of principal name to Dn.");
        String username = authorizeCB.getAuthorizationID();
        GetPrincipal getPrincipal = new GetPrincipal(new KerberosPrincipal(username));
        PrincipalStoreEntry entry = (PrincipalStoreEntry)getPrincipal.execute(this.adminSession, new Dn(new String[]{this.ldapSession.getLdapServer().getSearchBaseDn()}));
        String bindDn = entry.getDistinguishedName();
        LOG.debug("Converted username {} to Dn {}.", (Object)username, (Object)bindDn);
        LdapPrincipal ldapPrincipal = new LdapPrincipal(this.adminSession.getDirectoryService().getSchemaManager(), new Dn(new String[]{entry.getDistinguishedName()}), AuthenticationLevel.STRONG, StringConstants.EMPTY_BYTES);
        this.ldapSession.putSaslProperty("saslAuthentUser", ldapPrincipal);
        this.ldapSession.putSaslProperty("java.naming.security.principal", bindDn);
        authorizeCB.setAuthorizedID(bindDn);
        authorizeCB.setAuthorized(true);
    }
}

