/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.replication.provider;

import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.entry.ClonedServerEntry;
import org.apache.directory.server.core.api.event.DirectoryListener;
import org.apache.directory.server.core.api.event.EventType;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.api.interceptor.context.RenameOperationContext;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.ldap.LdapProtocolUtils;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.replication.ReplicaEventMessage;
import org.apache.directory.server.ldap.replication.provider.ReplicaEventLog;
import org.apache.directory.shared.ldap.extras.controls.SyncStateTypeEnum;
import org.apache.directory.shared.ldap.extras.controls.SyncStateValue;
import org.apache.directory.shared.ldap.extras.controls.syncrepl_impl.SyncStateValueDecorator;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.shared.ldap.model.message.AbandonListener;
import org.apache.directory.shared.ldap.model.message.AbandonableRequest;
import org.apache.directory.shared.ldap.model.message.Control;
import org.apache.directory.shared.ldap.model.message.SearchRequest;
import org.apache.directory.shared.ldap.model.message.SearchResultEntry;
import org.apache.directory.shared.ldap.model.message.SearchResultEntryImpl;
import org.apache.directory.shared.ldap.model.message.controls.ChangeType;
import org.apache.directory.shared.util.Strings;
import org.apache.mina.core.future.WriteFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncReplSearchListener
implements DirectoryListener,
AbandonListener {
    private static final Logger LOG = LoggerFactory.getLogger(SyncReplSearchListener.class);
    private LdapSession session;
    private SearchRequest searchRequest;
    private volatile boolean pushInRealTime;
    private final ReplicaEventLog consumerMsgLog;

    SyncReplSearchListener(LdapSession session, SearchRequest searchRequest, ReplicaEventLog consumerMsgLog, boolean pushInRealTime) {
        this.pushInRealTime = pushInRealTime;
        this.setSession(session);
        this.setSearchRequest(searchRequest);
        this.consumerMsgLog = consumerMsgLog;
    }

    public void setSession(LdapSession session) {
        this.session = session;
    }

    public void setSearchRequest(SearchRequest searchRequest) {
        this.searchRequest = searchRequest;
        if (searchRequest != null) {
            searchRequest.addAbandonListener((AbandonListener)this);
        }
    }

    public void requestAbandoned(AbandonableRequest searchRequest) {
        try {
            if (this.session != null) {
                this.session.getCoreSession().getDirectoryService().getEventService().removeListener((DirectoryListener)this);
            }
        }
        catch (Exception e) {
            LOG.error(I18n.err((I18n)I18n.ERR_164, (Object[])new Object[0]), (Throwable)e);
        }
    }

    private SyncStateValue createControl(DirectoryService directoryService, SyncStateTypeEnum operation, Entry entry) throws LdapInvalidAttributeValueException {
        SyncStateValueDecorator syncStateValue = new SyncStateValueDecorator(directoryService.getLdapCodecService());
        syncStateValue.setSyncStateType(operation);
        String uuidStr = entry.get("entryUUID").getString();
        syncStateValue.setEntryUUID(Strings.uuidToBytes((String)uuidStr));
        syncStateValue.setCookie(this.getCookie(entry));
        return syncStateValue;
    }

    private void sendResult(SearchResultEntry searchResultEntry, Entry entry, EventType eventType, SyncStateValue syncStateValue) {
        searchResultEntry.addControl((Control)syncStateValue);
        LOG.debug("sending event {} of entry {}", (Object)eventType, (Object)entry.getDn());
        WriteFuture future = this.session.getIoSession().write((Object)searchResultEntry);
        this.handleWriteFuture(future, entry, eventType);
    }

    public void entryAdded(AddOperationContext addContext) {
        Entry entry = addContext.getEntry();
        try {
            this.consumerMsgLog.log(new ReplicaEventMessage(ChangeType.ADD, ((ClonedServerEntry)entry).getClonedEntry()));
            if (this.pushInRealTime) {
                SearchResultEntryImpl resultEntry = new SearchResultEntryImpl(this.searchRequest.getMessageId());
                resultEntry.setObjectName(entry.getDn());
                resultEntry.setEntry(entry);
                SyncStateValue syncAdd = this.createControl(this.session.getCoreSession().getDirectoryService(), SyncStateTypeEnum.ADD, entry);
                this.sendResult((SearchResultEntry)resultEntry, entry, EventType.ADD, syncAdd);
            }
        }
        catch (LdapInvalidAttributeValueException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public void entryDeleted(DeleteOperationContext deleteContext) {
        Entry entry = deleteContext.getEntry();
        this.sendDeletedEntry(entry);
    }

    private void sendDeletedEntry(Entry entry) {
        try {
            this.consumerMsgLog.log(new ReplicaEventMessage(ChangeType.DELETE, entry));
            if (this.pushInRealTime) {
                SearchResultEntryImpl resultEntry = new SearchResultEntryImpl(this.searchRequest.getMessageId());
                resultEntry.setObjectName(entry.getDn());
                resultEntry.setEntry(entry);
                SyncStateValue syncDelete = this.createControl(this.session.getCoreSession().getDirectoryService(), SyncStateTypeEnum.DELETE, entry);
                this.sendResult((SearchResultEntry)resultEntry, entry, EventType.DELETE, syncDelete);
            }
        }
        catch (LdapInvalidAttributeValueException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public void entryModified(ModifyOperationContext modifyContext) {
        Entry alteredEntry = modifyContext.getAlteredEntry();
        try {
            this.consumerMsgLog.log(new ReplicaEventMessage(ChangeType.MODIFY, alteredEntry));
            if (this.pushInRealTime) {
                SearchResultEntryImpl resultEntry = new SearchResultEntryImpl(this.searchRequest.getMessageId());
                resultEntry.setObjectName(modifyContext.getDn());
                resultEntry.setEntry(alteredEntry);
                SyncStateValue syncModify = this.createControl(this.session.getCoreSession().getDirectoryService(), SyncStateTypeEnum.MODIFY, alteredEntry);
                this.sendResult((SearchResultEntry)resultEntry, alteredEntry, EventType.MODIFY, syncModify);
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public void entryMoved(MoveOperationContext moveContext) {
        Entry entry = moveContext.getModifiedEntry();
        try {
            if (!moveContext.getNewSuperior().isDescendantOf(this.consumerMsgLog.getSearchCriteria().getBase())) {
                this.sendDeletedEntry(entry);
                return;
            }
            this.consumerMsgLog.log(new ReplicaEventMessage(ChangeType.MODDN, entry));
            if (this.pushInRealTime) {
                SearchResultEntryImpl resultEntry = new SearchResultEntryImpl(this.searchRequest.getMessageId());
                resultEntry.setObjectName(moveContext.getDn());
                resultEntry.setEntry(entry);
                SyncStateValue syncModify = this.createControl(this.session.getCoreSession().getDirectoryService(), SyncStateTypeEnum.MODDN, entry);
                this.sendResult((SearchResultEntry)resultEntry, entry, null, syncModify);
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public void entryMovedAndRenamed(MoveAndRenameOperationContext moveAndRenameContext) {
        try {
            if (!moveAndRenameContext.getNewSuperiorDn().isDescendantOf(this.consumerMsgLog.getSearchCriteria().getBase())) {
                this.sendDeletedEntry(moveAndRenameContext.getEntry());
                return;
            }
            Entry entry = moveAndRenameContext.getModifiedEntry();
            this.consumerMsgLog.log(new ReplicaEventMessage(ChangeType.MODDN, entry));
            if (this.pushInRealTime) {
                SearchResultEntryImpl resultEntry = new SearchResultEntryImpl(this.searchRequest.getMessageId());
                resultEntry.setObjectName(entry.getDn());
                resultEntry.setEntry(entry);
                SyncStateValue syncModify = this.createControl(this.session.getCoreSession().getDirectoryService(), SyncStateTypeEnum.MODDN, entry);
                this.sendResult((SearchResultEntry)resultEntry, entry, null, syncModify);
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public void entryRenamed(RenameOperationContext renameContext) {
        Entry entry = renameContext.getModifiedEntry();
        try {
            this.consumerMsgLog.log(new ReplicaEventMessage(ChangeType.MODDN, entry));
            if (this.pushInRealTime) {
                SearchResultEntryImpl resultEntry = new SearchResultEntryImpl(this.searchRequest.getMessageId());
                resultEntry.setObjectName(entry.getDn());
                resultEntry.setEntry(entry);
                SyncStateValue syncModify = this.createControl(this.session.getCoreSession().getDirectoryService(), SyncStateTypeEnum.MODDN, entry);
                syncModify.setCookie(this.getCookie(entry));
                this.sendResult((SearchResultEntry)resultEntry, entry, null, syncModify);
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public boolean isPushInRealTime() {
        return this.pushInRealTime;
    }

    public void setPushInRealTime(boolean pushInRealTime) {
        this.pushInRealTime = pushInRealTime;
    }

    private byte[] getCookie(Entry entry) throws LdapInvalidAttributeValueException {
        String csn = entry.get("entryCSN").getString();
        return LdapProtocolUtils.createCookie(this.consumerMsgLog.getId(), csn);
    }

    private void handleWriteFuture(WriteFuture future, Entry entry, EventType event) {
        future.awaitUninterruptibly(10000L);
        if (!future.isWritten()) {
            LOG.error("Failed to write to the consumer {} during the event {} on entry {}", new Object[]{this.consumerMsgLog.getId(), event, entry.getDn()});
            LOG.error("", future.getException());
            this.pushInRealTime = false;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SyncReplSearchListener : \n");
        sb.append('\'').append(this.searchRequest).append("', ");
        sb.append('\'').append(this.pushInRealTime).append("', \n");
        sb.append(this.consumerMsgLog);
        sb.append('\n');
        return sb.toString();
    }
}

