/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.replication.provider;

import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import jdbm.RecordManager;
import jdbm.helper.Serializer;
import jdbm.recman.BaseRecordManager;
import jdbm.recman.TransactionManager;
import org.apache.directory.api.ldap.model.constants.Loggers;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.comparators.SerializableComparator;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.event.EventType;
import org.apache.directory.server.core.api.event.NotificationCriteria;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmTable;
import org.apache.directory.server.core.partition.impl.btree.jdbm.StringSerializer;
import org.apache.directory.server.ldap.replication.ReplicaEventMessage;
import org.apache.directory.server.ldap.replication.ReplicaEventMessageSerializer;
import org.apache.directory.server.ldap.replication.provider.ReplicaJournalCursor;
import org.apache.directory.server.ldap.replication.provider.SyncReplSearchListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicaEventLog
implements Comparable<ReplicaEventLog> {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicaEventLog.class);
    private static final Logger PROVIDER_LOG = LoggerFactory.getLogger((String)Loggers.PROVIDER_LOG.getName());
    private String hostName;
    private String searchFilter;
    private String lastSentCsn;
    private SyncReplSearchListener persistentListener;
    private NotificationCriteria searchCriteria;
    private int replicaId;
    private boolean refreshNPersist;
    private long maxIdlePeriod = -1L;
    private int purgeThresholdCount = 10000;
    private JdbmTable<String, ReplicaEventMessage> journal;
    private File journalFile;
    private RecordManager recman;
    private volatile boolean dirty;
    private Dn consumerEntryDn;
    public static final String REPLICA_EVENT_LOG_NAME_PREFIX = "REPL_EVENT_LOG.";
    public static final int DEFAULT_PURGE_THRESHOLD_COUNT = 10000;
    public static final int DEFAULT_MAX_IDLE_PERIOD = -1;

    public ReplicaEventLog(DirectoryService directoryService, int replicaId) throws IOException {
        PROVIDER_LOG.debug("Creating the replication queue for replica {}", (Object)replicaId);
        SchemaManager schemaManager = directoryService.getSchemaManager();
        this.replicaId = replicaId;
        this.searchCriteria = new NotificationCriteria();
        this.searchCriteria.setEventMask(EventType.ALL_EVENT_TYPES_MASK);
        File replDir = directoryService.getInstanceLayout().getReplDirectory();
        this.journalFile = new File(replDir, REPLICA_EVENT_LOG_NAME_PREFIX + replicaId);
        this.recman = new BaseRecordManager(this.journalFile.getAbsolutePath());
        TransactionManager transactionManager = ((BaseRecordManager)this.recman).getTransactionManager();
        transactionManager.setMaximumTransactionsInLog(200);
        SerializableComparator comparator = new SerializableComparator("1.3.6.1.4.1.4203.666.11.2.3");
        comparator.setSchemaManager(schemaManager);
        this.journal = new JdbmTable(schemaManager, this.journalFile.getName(), this.recman, (Comparator)comparator, (Serializer)StringSerializer.INSTANCE, (Serializer)new ReplicaEventMessageSerializer(schemaManager));
    }

    public synchronized void log(ReplicaEventMessage message) {
        try {
            LOG.debug("logging entry with Dn {} with the event {}", (Object)message.getEntry().getDn(), (Object)message.getChangeType());
            PROVIDER_LOG.debug("logging entry with Dn {} with the event {}", (Object)message.getEntry().getDn(), (Object)message.getChangeType());
            String entryCsn = message.getEntry().get("entryCSN").getString();
            this.journal.put((Object)entryCsn, (Object)message);
            this.journal.sync();
        }
        catch (Exception e) {
            LOG.warn("Failed to insert the entry into syncrepl log", (Throwable)e);
            PROVIDER_LOG.error("Failed to insert the entry into syncrepl log", (Throwable)e);
        }
    }

    public void truncate() throws Exception {
    }

    public void recreate() throws Exception {
        LOG.debug("recreating the queue for the replica id {}", (Object)this.replicaId);
    }

    public void stop() throws Exception {
        PROVIDER_LOG.debug("Stopping the EventLog for replicaId {}", (Object)this.replicaId);
        if (this.journal != null) {
            this.journal.close();
        }
        this.journal = null;
        if (this.recman != null) {
            this.recman.close();
        }
        this.recman = null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ReplicaEventLog)) {
            return false;
        }
        ReplicaEventLog other = (ReplicaEventLog)obj;
        return this.replicaId == other.getId();
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.searchFilter.hashCode();
        result = 31 * result + this.hostName.hashCode();
        return result;
    }

    @Override
    public int compareTo(ReplicaEventLog o) {
        if (this.equals(o)) {
            return 0;
        }
        return 1;
    }

    public SyncReplSearchListener getPersistentListener() {
        return this.persistentListener;
    }

    public void setPersistentListener(SyncReplSearchListener persistentListener) {
        this.persistentListener = persistentListener;
    }

    public NotificationCriteria getSearchCriteria() {
        return this.searchCriteria;
    }

    public void setSearchCriteria(NotificationCriteria searchCriteria) {
        this.searchCriteria = searchCriteria;
    }

    public boolean isRefreshNPersist() {
        return this.refreshNPersist;
    }

    public void setRefreshNPersist(boolean refreshNPersist) {
        this.refreshNPersist = refreshNPersist;
    }

    public int getId() {
        return this.replicaId;
    }

    public String getLastSentCsn() {
        return this.lastSentCsn;
    }

    public void setLastSentCsn(String lastSentCsn) {
        if (!lastSentCsn.equals(this.lastSentCsn)) {
            this.lastSentCsn = lastSentCsn;
            this.dirty = true;
        }
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getSearchFilter() {
        return this.searchFilter;
    }

    public void setSearchFilter(String searchFilter) {
        this.searchFilter = searchFilter;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public String getQueueName() {
        return "replicaId=" + this.replicaId;
    }

    public ReplicaJournalCursor getCursor(String consumerCsn) throws Exception {
        return new ReplicaJournalCursor(this.journal, consumerCsn);
    }

    public String getName() {
        return this.journal.getName();
    }

    public synchronized long count() {
        try {
            return this.journal.count();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public long getMaxIdlePeriod() {
        return this.maxIdlePeriod;
    }

    public void setMaxIdlePeriod(long maxIdlePeriod) {
        if (maxIdlePeriod <= 0L) {
            maxIdlePeriod = -1L;
        }
        this.maxIdlePeriod = maxIdlePeriod;
    }

    public int getPurgeThresholdCount() {
        return this.purgeThresholdCount;
    }

    public void setPurgeThresholdCount(int purgeThresholdCount) {
        if (purgeThresholdCount <= 0) {
            purgeThresholdCount = 10000;
        }
        this.purgeThresholdCount = purgeThresholdCount;
    }

    public Dn getConsumerEntryDn() {
        return this.consumerEntryDn;
    }

    public void setConsumerEntryDn(Dn consumerEntryDn) {
        this.consumerEntryDn = consumerEntryDn;
    }

    public String toString() {
        return "ReplicaEventLog [hostName=" + this.hostName + ", searchFilter=" + this.searchFilter + ", lastSentCsn=" + this.lastSentCsn + ", searchCriteria=" + this.searchCriteria + ", replicaId=" + this.replicaId + ", refreshNPersist=" + this.refreshNPersist + ", maxInactivePeriod=" + this.maxIdlePeriod + ", purgeThresholdCount=" + this.purgeThresholdCount + ", journalFile=" + this.journalFile + ", dirty=" + this.dirty + ", consumerEntryDn=" + this.consumerEntryDn + "]";
    }
}

