/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.bind.cramMD5;

import java.util.HashSet;
import javax.security.sasl.AuthorizeCallback;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.LdapPrincipal;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.bind.AbstractSaslCallbackHandler;
import org.apache.directory.shared.ldap.model.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.filter.ExprNode;
import org.apache.directory.shared.ldap.model.filter.FilterParser;
import org.apache.directory.shared.ldap.model.message.AliasDerefMode;
import org.apache.directory.shared.ldap.model.message.BindRequest;
import org.apache.directory.shared.ldap.model.message.SearchScope;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.AttributeTypeOptions;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CramMd5CallbackHandler
extends AbstractSaslCallbackHandler {
    private static final Logger LOG = LoggerFactory.getLogger(CramMd5CallbackHandler.class);
    private String bindDn;
    private SchemaManager schemaManager;

    public CramMd5CallbackHandler(LdapSession ldapSession, CoreSession adminSession, BindRequest bindRequest) {
        super(adminSession.getDirectoryService(), bindRequest);
        this.ldapSession = ldapSession;
        this.adminSession = adminSession;
        this.schemaManager = adminSession.getDirectoryService().getSchemaManager();
    }

    @Override
    protected Attribute lookupPassword(String username, String realm) {
        try {
            ExprNode filter = FilterParser.parse((SchemaManager)this.schemaManager, (String)("(uid=" + username + ")"));
            HashSet<AttributeTypeOptions> returningAttributes = new HashSet<AttributeTypeOptions>();
            AttributeType passwordAT = this.adminSession.getDirectoryService().getSchemaManager().lookupAttributeTypeRegistry("userPassword");
            returningAttributes.add(new AttributeTypeOptions(passwordAT));
            this.bindDn = (String)this.ldapSession.getSaslProperty("userBaseDn");
            Dn baseDn = new Dn(new String[]{this.bindDn});
            EntryFilteringCursor cursor = this.adminSession.search(baseDn, SearchScope.SUBTREE, filter, AliasDerefMode.DEREF_ALWAYS, returningAttributes);
            cursor.beforeFirst();
            Entry entry = null;
            while (cursor.next()) {
                entry = (Entry)cursor.get();
                LdapPrincipal ldapPrincipal = new LdapPrincipal(this.schemaManager, entry.getDn(), AuthenticationLevel.STRONG, entry.get("userPassword").getBytes());
                this.ldapSession.putSaslProperty("saslAuthentUser", ldapPrincipal);
            }
            return entry.get(passwordAT);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    protected void authorize(AuthorizeCallback authorizeCB) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Converted username " + this.getUsername() + " to Dn " + this.bindDn);
        }
        this.ldapSession.putSaslProperty("java.naming.security.principal", this.bindDn);
        authorizeCB.setAuthorizedID(this.bindDn);
        authorizeCB.setAuthorized(true);
    }
}

