/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.extended;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.security.TlsKeyGenerator;
import org.apache.directory.server.ldap.ExtendedOperationHandler;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.ldap.codec.extended.operations.certGeneration.CertGenerationContainer;
import org.apache.directory.shared.ldap.codec.extended.operations.certGeneration.CertGenerationDecoder;
import org.apache.directory.shared.ldap.codec.extended.operations.certGeneration.CertGenerationObject;
import org.apache.directory.shared.ldap.entry.ServerEntry;
import org.apache.directory.shared.ldap.message.internal.InternalExtendedRequest;
import org.apache.directory.shared.ldap.name.DN;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertGenerationRequestHandler
implements ExtendedOperationHandler {
    private static final Set<String> EXTENSION_OIDS;
    private static final Logger LOG;

    @Override
    public String getOid() {
        return "1.3.6.1.4.1.18060.0.1.8";
    }

    @Override
    public Set<String> getExtensionOids() {
        return EXTENSION_OIDS;
    }

    @Override
    public void handleExtendedOperation(LdapSession session, InternalExtendedRequest req) throws Exception {
        ByteBuffer bb = ByteBuffer.wrap(req.getPayload());
        CertGenerationDecoder decoder = new CertGenerationDecoder();
        CertGenerationContainer container = new CertGenerationContainer();
        decoder.decode(bb, (IAsn1Container)container);
        CertGenerationObject certGenObj = container.getCertGenerationObject();
        ClonedServerEntry entry = session.getCoreSession().lookup(new DN(certGenObj.getTargetDN()));
        if (entry != null) {
            TlsKeyGenerator.addKeyPair((ServerEntry)entry.getOriginalEntry(), (String)certGenObj.getIssuerDN(), (String)certGenObj.getSubjectDN(), (String)certGenObj.getKeyAlgorithm());
        }
    }

    @Override
    public void setLdapServer(LdapServer ldapServer) {
    }

    static {
        LOG = LoggerFactory.getLogger(CertGenerationRequestHandler.class);
        HashSet<String> set = new HashSet<String>(2);
        set.add("1.3.6.1.4.1.18060.0.1.8");
        set.add("1.3.6.1.4.1.18060.0.1.9");
        EXTENSION_OIDS = Collections.unmodifiableSet(set);
    }
}

