/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers;

import java.util.Map;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.authn.LdapPrincipal;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.ldap.LdapProtocolUtils;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.LdapRequestHandler;
import org.apache.directory.server.ldap.handlers.bind.MechanismHandler;
import org.apache.directory.shared.ldap.exception.LdapAuthenticationException;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.message.InternalBindRequest;
import org.apache.directory.shared.ldap.message.InternalBindResponse;
import org.apache.directory.shared.ldap.message.InternalLdapResult;
import org.apache.directory.shared.ldap.message.InternalRequest;
import org.apache.directory.shared.ldap.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.ExceptionUtils;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindHandler
extends LdapRequestHandler<InternalBindRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(BindHandler.class);
    private Map<String, MechanismHandler> handlers;

    public void setSaslMechanismHandlers(Map<String, MechanismHandler> handlers) {
        this.handlers = handlers;
    }

    public void handleSimpleAuth(LdapSession ldapSession, InternalBindRequest bindRequest) throws Exception {
        if (!ldapSession.isAnonymous()) {
            ldapSession.getCoreSession().unbind();
            ldapSession.setAnonymous();
        }
        BindOperationContext opContext = new BindOperationContext(null);
        opContext.setDn(bindRequest.getName());
        opContext.setCredentials(bindRequest.getCredentials());
        LdapProtocolUtils.setRequestControls((OperationContext)opContext, (InternalRequest)bindRequest);
        try {
            ClonedServerEntry principalEntry = null;
            try {
                principalEntry = this.getLdapServer().getDirectoryService().getAdminSession().lookup(bindRequest.getName());
            }
            catch (NameNotFoundException e) {
                // empty catch block
            }
            if (principalEntry == null) {
                LOG.info("The {} principalDN cannot be found in the server : bind failure.", (Object)bindRequest.getName());
                InternalLdapResult result = bindRequest.getResultResponse().getLdapResult();
                result.setErrorMessage("cannot bind the principalDn.");
                result.setResultCode(ResultCodeEnum.INVALID_CREDENTIALS);
                ldapSession.getIoSession().write((Object)bindRequest.getResultResponse());
                return;
            }
            if (principalEntry.getOriginalEntry().contains("objectClass", new String[]{"referral"})) {
                LOG.info("Bind principalDn points to referral.");
                InternalLdapResult result = bindRequest.getResultResponse().getLdapResult();
                result.setErrorMessage("Bind principalDn points to referral.");
                result.setResultCode(ResultCodeEnum.INVALID_CREDENTIALS);
                ldapSession.getIoSession().write((Object)bindRequest.getResultResponse());
                return;
            }
            this.getLdapServer().getDirectoryService().getOperationManager().bind(opContext);
            ldapSession.setCoreSession(opContext.getSession());
            if (!ldapSession.getCoreSession().isAnonymous()) {
                ldapSession.setAuthenticated();
            }
            this.sendBindSuccess(ldapSession, bindRequest, null);
        }
        catch (Exception e) {
            ResultCodeEnum code = null;
            InternalLdapResult result = bindRequest.getResultResponse().getLdapResult();
            if (e instanceof LdapException) {
                code = ((LdapException)e).getResultCode();
                result.setResultCode(code);
            } else {
                code = ResultCodeEnum.getBestEstimate((Throwable)e, (MessageTypeEnum)bindRequest.getType());
                result.setResultCode(code);
            }
            String msg = code.toString() + ": Bind failed: " + e.getMessage();
            if (LOG.isDebugEnabled()) {
                msg = msg + ":\n" + ExceptionUtils.getStackTrace((Throwable)e);
                msg = msg + "\n\nBindRequest = \n" + bindRequest.toString();
            }
            Name name = null;
            if (e instanceof LdapAuthenticationException) {
                name = ((LdapAuthenticationException)e).getResolvedName();
            }
            if (name != null && (code == ResultCodeEnum.NO_SUCH_OBJECT || code == ResultCodeEnum.ALIAS_PROBLEM || code == ResultCodeEnum.INVALID_DN_SYNTAX || code == ResultCodeEnum.ALIAS_DEREFERENCING_PROBLEM)) {
                result.setMatchedDn(new LdapDN(name));
            }
            result.setErrorMessage(msg);
            ldapSession.getIoSession().write((Object)bindRequest.getResultResponse());
        }
    }

    private boolean checkMechanism(LdapSession ldapSession, String saslMechanism) throws Exception {
        if (!this.ldapServer.getSupportedMechanisms().contains(saslMechanism)) {
            LOG.error("Bind error : {} mechanism not supported. Please check the server.xml configuration file (supportedMechanisms field)", (Object)saslMechanism);
            return false;
        }
        return true;
    }

    private void generateSaslChallengeOrComplete(LdapSession ldapSession, SaslServer ss, InternalBindRequest bindRequest) throws Exception {
        InternalLdapResult result = bindRequest.getResultResponse().getLdapResult();
        if (bindRequest.getCredentials() == null) {
            bindRequest.setCredentials(StringTools.EMPTY_BYTES);
        }
        try {
            byte[] tokenBytes = ss.evaluateResponse(bindRequest.getCredentials());
            if (ss.isComplete()) {
                LdapPrincipal ldapPrincipal;
                if (tokenBytes != null) {
                    ldapSession.putSaslProperty("saslCreds", tokenBytes);
                }
                if ((ldapPrincipal = (LdapPrincipal)ldapSession.getSaslProperty("saslAuthentUser")) != null) {
                    DirectoryService ds = ldapSession.getLdapServer().getDirectoryService();
                    String saslMechanism = bindRequest.getSaslMechanism();
                    CoreSession userSession = ds.getSession(ldapPrincipal.getJndiName(), ldapPrincipal.getUserPassword(), saslMechanism, null);
                    ldapSession.setCoreSession(userSession);
                }
                ldapSession.setAuthenticated();
                MechanismHandler handler = (MechanismHandler)ldapSession.getSaslProperty("saslmechHandler");
                handler.cleanup(ldapSession);
                this.sendBindSuccess(ldapSession, bindRequest, tokenBytes);
            } else {
                LOG.info("Continuation token had length " + tokenBytes.length);
                result.setResultCode(ResultCodeEnum.SASL_BIND_IN_PROGRESS);
                InternalBindResponse resp = (InternalBindResponse)bindRequest.getResultResponse();
                resp.setServerSaslCreds(tokenBytes);
                ldapSession.setAuthPending();
                ldapSession.getIoSession().write((Object)resp);
                LOG.debug("Returning final authentication data to client to complete context.");
            }
        }
        catch (SaslException se) {
            this.sendInvalidCredentials(ldapSession, bindRequest, se);
        }
    }

    private void sendAuthMethNotSupported(LdapSession ldapSession, InternalBindRequest bindRequest) {
        ldapSession.clearSaslProperties();
        ldapSession.setAnonymous();
        InternalLdapResult bindResult = bindRequest.getResultResponse().getLdapResult();
        bindResult.setResultCode(ResultCodeEnum.AUTH_METHOD_NOT_SUPPORTED);
        bindResult.setErrorMessage(ResultCodeEnum.AUTH_METHOD_NOT_SUPPORTED.toString() + ": " + bindRequest.getSaslMechanism() + " is not a supported mechanism.");
        ldapSession.getIoSession().write((Object)bindRequest.getResultResponse());
    }

    private void sendInvalidCredentials(LdapSession ldapSession, InternalBindRequest bindRequest, Exception e) {
        InternalLdapResult result = bindRequest.getResultResponse().getLdapResult();
        String message = "";
        message = e != null ? ResultCodeEnum.INVALID_CREDENTIALS + ": " + e.getMessage() : ResultCodeEnum.INVALID_CREDENTIALS.toString();
        LOG.error(message);
        result.setResultCode(ResultCodeEnum.INVALID_CREDENTIALS);
        result.setErrorMessage(message);
        ldapSession.clearSaslProperties();
        ldapSession.setAnonymous();
        ldapSession.getIoSession().write((Object)bindRequest.getResultResponse());
    }

    private void sendBindSuccess(LdapSession ldapSession, InternalBindRequest bindRequest, byte[] tokenBytes) {
        InternalBindResponse response = (InternalBindResponse)bindRequest.getResultResponse();
        response.getLdapResult().setResultCode(ResultCodeEnum.SUCCESS);
        response.setServerSaslCreds(tokenBytes);
        if (!ldapSession.getCoreSession().isAnonymous()) {
            ldapSession.setAuthenticated();
        } else {
            ldapSession.setAnonymous();
        }
        MechanismHandler handler = (MechanismHandler)ldapSession.getSaslProperty("saslmechHandler");
        if (handler != null) {
            handler.cleanup(ldapSession);
        }
        ldapSession.getIoSession().write((Object)response);
        LOG.debug("Returned SUCCESS message: {}.", (Object)response);
    }

    private void handleSaslAuthPending(LdapSession ldapSession, InternalBindRequest bindRequest, DirectoryService ds) throws Exception {
        String saslMechanism = bindRequest.getSaslMechanism();
        if (StringTools.isEmpty((String)saslMechanism) || !ldapSession.getSaslProperty("saslMech").equals(saslMechanism)) {
            this.sendAuthMethNotSupported(ldapSession, bindRequest);
            return;
        }
        MechanismHandler mechanismHandler = this.handlers.get(saslMechanism);
        if (mechanismHandler == null) {
            String message = "Handler unavailable for " + saslMechanism;
            ldapSession.clearSaslProperties();
            ldapSession.setAnonymous();
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        SaslServer ss = mechanismHandler.handleMechanism(ldapSession, bindRequest);
        this.generateSaslChallengeOrComplete(ldapSession, ss, bindRequest);
    }

    public void handleSaslAuth(LdapSession ldapSession, InternalBindRequest bindRequest) throws Exception {
        String saslMechanism = bindRequest.getSaslMechanism();
        DirectoryService ds = this.getLdapServer().getDirectoryService();
        if (ldapSession.isAuthenticated()) {
            ldapSession.getCoreSession().unbind();
            ldapSession.setAnonymous();
            ldapSession.clearSaslProperties();
        }
        if (ldapSession.isAnonymous()) {
            if (!StringTools.isEmpty((String)saslMechanism)) {
                if (!this.checkMechanism(ldapSession, saslMechanism)) {
                    this.sendAuthMethNotSupported(ldapSession, bindRequest);
                    return;
                }
                ldapSession.putSaslProperty("saslMech", saslMechanism);
                MechanismHandler mechanismHandler = this.handlers.get(saslMechanism);
                ldapSession.putSaslProperty("saslmechHandler", mechanismHandler);
                mechanismHandler.init(ldapSession);
                SaslServer ss = mechanismHandler.handleMechanism(ldapSession, bindRequest);
                this.generateSaslChallengeOrComplete(ldapSession, ss, bindRequest);
                return;
            }
        } else if (ldapSession.isAuthPending()) {
            try {
                this.handleSaslAuthPending(ldapSession, bindRequest, ds);
            }
            catch (SaslException se) {
                this.sendInvalidCredentials(ldapSession, bindRequest, se);
            }
            return;
        }
    }

    @Override
    public void handle(LdapSession ldapSession, InternalBindRequest bindRequest) throws Exception {
        LOG.debug("Received: {}", (Object)bindRequest);
        if (!bindRequest.getVersion3()) {
            LOG.error("Bind error : Only LDAP v3 is supported.");
            InternalLdapResult bindResult = bindRequest.getResultResponse().getLdapResult();
            bindResult.setResultCode(ResultCodeEnum.PROTOCOL_ERROR);
            bindResult.setErrorMessage("Only LDAP v3 is supported.");
            ldapSession.getIoSession().write((Object)bindRequest.getResultResponse());
            return;
        }
        if (bindRequest.isSimple()) {
            this.handleSimpleAuth(ldapSession, bindRequest);
        } else {
            this.handleSaslAuth(ldapSession, bindRequest);
        }
    }
}

