/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreSpi;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.core.security.CoreKeyStoreSpi;
import org.apache.directory.server.ldap.ExtendedOperationHandler;
import org.apache.directory.server.ldap.LdapProtocolCodecFactory;
import org.apache.directory.server.ldap.LdapProtocolHandler;
import org.apache.directory.server.ldap.LdapSessionManager;
import org.apache.directory.server.ldap.handlers.AbandonHandler;
import org.apache.directory.server.ldap.handlers.AddHandler;
import org.apache.directory.server.ldap.handlers.BindHandler;
import org.apache.directory.server.ldap.handlers.CompareHandler;
import org.apache.directory.server.ldap.handlers.DeleteHandler;
import org.apache.directory.server.ldap.handlers.ExtendedHandler;
import org.apache.directory.server.ldap.handlers.LdapRequestHandler;
import org.apache.directory.server.ldap.handlers.ModifyDnHandler;
import org.apache.directory.server.ldap.handlers.ModifyHandler;
import org.apache.directory.server.ldap.handlers.SearchHandler;
import org.apache.directory.server.ldap.handlers.UnbindHandler;
import org.apache.directory.server.ldap.handlers.bind.MechanismHandler;
import org.apache.directory.server.ldap.handlers.ssl.LdapsInitializer;
import org.apache.directory.server.ldap.replication.ReplicationSystem;
import org.apache.directory.server.protocol.shared.DirectoryBackedService;
import org.apache.directory.server.protocol.shared.transport.TcpTransport;
import org.apache.directory.server.protocol.shared.transport.Transport;
import org.apache.directory.server.protocol.shared.transport.UdpTransport;
import org.apache.directory.shared.ldap.exception.LdapConfigurationException;
import org.apache.directory.shared.ldap.message.InternalAbandonRequest;
import org.apache.directory.shared.ldap.message.InternalAddRequest;
import org.apache.directory.shared.ldap.message.InternalBindRequest;
import org.apache.directory.shared.ldap.message.InternalCompareRequest;
import org.apache.directory.shared.ldap.message.InternalDeleteRequest;
import org.apache.directory.shared.ldap.message.InternalExtendedRequest;
import org.apache.directory.shared.ldap.message.InternalModifyDnRequest;
import org.apache.directory.shared.ldap.message.InternalModifyRequest;
import org.apache.directory.shared.ldap.message.InternalSearchRequest;
import org.apache.directory.shared.ldap.message.InternalUnbindRequest;
import org.apache.directory.shared.ldap.message.extended.NoticeOfDisconnect;
import org.apache.directory.shared.ldap.util.StringTools;
import org.apache.mina.core.filterchain.DefaultIoFilterChainBuilder;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterChainBuilder;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IoEventType;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.executor.ExecutorFilter;
import org.apache.mina.filter.executor.UnorderedThreadPoolExecutor;
import org.apache.mina.handler.demux.MessageHandler;
import org.apache.mina.transport.socket.SocketAcceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapServer
extends DirectoryBackedService {
    private static final long serialVersionUID = 3757127143811666817L;
    private static final Logger LOG = LoggerFactory.getLogger((String)LdapServer.class.getName());
    public static final int NO_SIZE_LIMIT = 0;
    public static final int NO_TIME_LIMIT = 0;
    public static final String SERVICE_NAME = "ldap";
    private static final int MAX_SIZE_LIMIT_DEFAULT = 100;
    private static final int MAX_TIME_LIMIT_DEFAULT = 10000;
    private static final String SERVICE_PID_DEFAULT = "org.apache.directory.server.ldap";
    private static final String SERVICE_NAME_DEFAULT = "ApacheDS LDAP Service";
    private static final int DEFAULT_IP_PORT = 389;
    private LdapSessionManager ldapSessionManager = new LdapSessionManager();
    private Set<String> supportedControls;
    private int maxSizeLimit = 100;
    private int maxTimeLimit = 10000;
    private String keystoreFile;
    private String certificatePassword;
    private boolean allowAnonymousAccess = true;
    private final Collection<ExtendedOperationHandler> extendedOperationHandlers = new ArrayList<ExtendedOperationHandler>();
    private Map<String, MechanismHandler> saslMechanismHandlers = new HashMap<String, MechanismHandler>();
    private String saslHost = "ldap.example.com";
    private String saslPrincipal = "ldap/ldap.example.com@EXAMPLE.COM";
    private Set<String> saslQop;
    private String saslQopString;
    private List<String> saslRealms;
    private LdapRequestHandler<InternalAbandonRequest> abandonHandler;
    private LdapRequestHandler<InternalAddRequest> addHandler;
    private LdapRequestHandler<InternalBindRequest> bindHandler;
    private LdapRequestHandler<InternalCompareRequest> compareHandler;
    private LdapRequestHandler<InternalDeleteRequest> deleteHandler;
    private LdapRequestHandler<InternalExtendedRequest> extendedHandler;
    private LdapRequestHandler<InternalModifyRequest> modifyHandler;
    private LdapRequestHandler<InternalModifyDnRequest> modifyDnHandler;
    private LdapRequestHandler<InternalSearchRequest> searchHandler;
    private LdapRequestHandler<InternalUnbindRequest> unbindHandler;
    private ProtocolCodecFactory codecFactory;
    private final LdapProtocolHandler handler = new LdapProtocolHandler(this);
    private boolean started;
    private boolean confidentialityRequired;
    private ReplicationSystem replicationSystem;

    public LdapServer() {
        super.setEnabled(true);
        super.setServiceId(SERVICE_PID_DEFAULT);
        super.setServiceName(SERVICE_NAME_DEFAULT);
        this.saslQop = new HashSet<String>();
        this.saslQop.add("auth");
        this.saslQop.add("auth-int");
        this.saslQop.add("auth-conf");
        this.saslQopString = "auth,auth-int,auth-conf";
        this.saslRealms = new ArrayList<String>();
        this.saslRealms.add("example.com");
        this.supportedControls = new HashSet<String>();
        this.supportedControls.add("2.16.840.1.113730.3.4.3");
        this.supportedControls.add("2.16.840.1.113730.3.4.7");
        this.supportedControls.add("1.3.6.1.4.1.4203.1.10.1");
        this.supportedControls.add("2.16.840.1.113730.3.4.2");
        this.supportedControls.add("1.3.6.1.4.1.18060.0.0.1");
        this.supportedControls.add("1.2.840.113556.1.4.319");
        this.supportedControls.add("1.3.6.1.4.1.4203.1.9.1.3");
        this.supportedControls.add("1.3.6.1.4.1.4203.1.9.1.4");
        this.supportedControls.add("1.3.6.1.4.1.4203.1.9.1.1");
        this.supportedControls.add("1.3.6.1.4.1.4203.1.9.1.2");
    }

    private void installDefaultHandlers() {
        if (this.getAbandonHandler() == null) {
            this.setAbandonHandler(new AbandonHandler());
        }
        if (this.getAddHandler() == null) {
            this.setAddHandler(new AddHandler());
        }
        if (this.getBindHandler() == null) {
            BindHandler handler = new BindHandler();
            handler.setSaslMechanismHandlers(this.saslMechanismHandlers);
            this.setBindHandler(handler);
        }
        if (this.getCompareHandler() == null) {
            this.setCompareHandler(new CompareHandler());
        }
        if (this.getDeleteHandler() == null) {
            this.setDeleteHandler(new DeleteHandler());
        }
        if (this.getExtendedHandler() == null) {
            this.setExtendedHandler(new ExtendedHandler());
        }
        if (this.getModifyHandler() == null) {
            this.setModifyHandler(new ModifyHandler());
        }
        if (this.getModifyDnHandler() == null) {
            this.setModifyDnHandler(new ModifyDnHandler());
        }
        if (this.getSearchHandler() == null) {
            this.setSearchHandler(new SearchHandler());
        }
        if (this.getUnbindHandler() == null) {
            this.setUnbindHandler(new UnbindHandler());
        }
    }

    public void start() throws Exception {
        if (!this.isEnabled()) {
            return;
        }
        for (Transport transport : this.transports) {
            DefaultIoFilterChainBuilder chain;
            if (!(transport instanceof TcpTransport)) {
                LOG.warn("Cannot listen on an UDP transport : {}", (Object)transport);
                continue;
            }
            if (transport.isSSLEnabled()) {
                KeyStore keyStore = null;
                if (StringTools.isEmpty((String)this.keystoreFile)) {
                    Provider provider = Security.getProvider("SUN");
                    LOG.debug("provider = {}", (Object)provider);
                    CoreKeyStoreSpi coreKeyStoreSpi = new CoreKeyStoreSpi(this.getDirectoryService());
                    keyStore = new AdsKeyStore((KeyStoreSpi)coreKeyStoreSpi, provider, "JKS");
                    try {
                        keyStore.load(null, null);
                    }
                    catch (Exception e) {}
                } else {
                    keyStore = AdsKeyStore.getInstance(KeyStore.getDefaultType());
                    FileInputStream fis = new FileInputStream(this.keystoreFile);
                    keyStore.load(fis, null);
                }
                chain = LdapsInitializer.init(keyStore, this.certificatePassword);
            } else {
                chain = new DefaultIoFilterChainBuilder();
            }
            chain.addLast("codec", (IoFilter)new ProtocolCodecFilter(this.getProtocolCodecFactory()));
            chain.addLast("executor", (IoFilter)new ExecutorFilter((Executor)new UnorderedThreadPoolExecutor(transport.getNbThreads()), new IoEventType[]{IoEventType.MESSAGE_RECEIVED}));
            this.installDefaultHandlers();
            this.startNetwork(transport, (IoFilterChainBuilder)chain);
        }
        this.started = true;
        LOG.info("Ldap service started.");
    }

    public void stop() {
        try {
            for (Transport transport : this.transports) {
                ArrayList sessions;
                if (!(transport instanceof TcpTransport)) continue;
                ArrayList<WriteFuture> writeFutures = new ArrayList<WriteFuture>();
                try {
                    sessions = new ArrayList(this.getSocketAcceptor(transport).getManagedSessions().values());
                }
                catch (IllegalArgumentException e) {
                    LOG.warn("Seems like the LDAP service (" + this.getPort() + ") has already been unbound.");
                    return;
                }
                this.getSocketAcceptor(transport).dispose();
                if (LOG.isInfoEnabled()) {
                    LOG.info("Unbind of an LDAP service (" + this.getPort() + ") is complete.");
                    LOG.info("Sending notice of disconnect to existing clients sessions.");
                }
                if (sessions != null) {
                    for (IoSession session : sessions) {
                        writeFutures.add(session.write((Object)NoticeOfDisconnect.UNAVAILABLE));
                    }
                }
                Iterator sessionIt = sessions.iterator();
                for (WriteFuture future : writeFutures) {
                    future.await(1000L);
                    ((IoSession)sessionIt.next()).close(true);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to sent NoD.", (Throwable)e);
        }
        LOG.info("Ldap service stopped.");
    }

    private void startNetwork(Transport transport, IoFilterChainBuilder chainBuilder) throws Exception {
        if (transport.getBackLog() < 0) {
            transport.setBackLog(50);
        }
        PartitionNexus nexus = this.getDirectoryService().getPartitionNexus();
        for (ExtendedOperationHandler h : this.extendedOperationHandlers) {
            LOG.info("Added Extended Request Handler: " + h.getOid());
            h.setLdapServer(this);
            nexus.registerSupportedExtensions(h.getExtensionOids());
        }
        nexus.registerSupportedSaslMechanisms(this.saslMechanismHandlers.keySet());
        try {
            SocketAcceptor acceptor = this.getSocketAcceptor(transport);
            acceptor.setCloseOnDeactivation(false);
            acceptor.setReuseAddress(true);
            acceptor.getSessionConfig().setTcpNoDelay(true);
            acceptor.setFilterChainBuilder(chainBuilder);
            acceptor.setHandler(this.getHandler());
            acceptor.bind();
            this.started = true;
            if (LOG.isInfoEnabled()) {
                LOG.info("Successful bind of an LDAP Service (" + transport.getPort() + ") is completed.");
            }
        }
        catch (IOException e) {
            String msg = "Failed to bind an LDAP service (" + transport.getPort() + ") to the service registry.";
            LdapConfigurationException lce = new LdapConfigurationException(msg);
            lce.setRootCause((Throwable)e);
            LOG.error(msg, (Throwable)e);
            throw lce;
        }
    }

    public String getName() {
        return SERVICE_NAME;
    }

    public IoHandler getHandler() {
        return this.handler;
    }

    public LdapSessionManager getLdapSessionManager() {
        return this.ldapSessionManager;
    }

    public ProtocolCodecFactory getProtocolCodecFactory() {
        return this.codecFactory;
    }

    public void addExtendedOperationHandler(ExtendedOperationHandler eoh) throws Exception {
        if (this.started) {
            eoh.setLdapServer(this);
            PartitionNexus nexus = this.getDirectoryService().getPartitionNexus();
            nexus.registerSupportedExtensions(eoh.getExtensionOids());
        } else {
            this.extendedOperationHandlers.add(eoh);
        }
    }

    public void removeExtendedOperationHandler(String oid) {
        ExtendedOperationHandler handler = null;
        for (ExtendedOperationHandler h : this.extendedOperationHandlers) {
            if (!h.getOid().equals(oid)) continue;
            handler = h;
            break;
        }
        this.extendedOperationHandlers.remove(handler);
    }

    public ExtendedOperationHandler getExtendedOperationHandler(String oid) {
        for (ExtendedOperationHandler h : this.extendedOperationHandlers) {
            if (!h.getOid().equals(oid)) continue;
            return h;
        }
        return null;
    }

    public void setConfidentialityRequired(boolean confidentialityRequired) {
        this.confidentialityRequired = confidentialityRequired;
    }

    public boolean isConfidentialityRequired() {
        return this.confidentialityRequired;
    }

    public boolean isEnableLdaps(Transport transport) {
        return transport.isSSLEnabled();
    }

    public boolean isAllowAnonymousAccess() {
        return this.allowAnonymousAccess;
    }

    public void setAllowAnonymousAccess(boolean enableAnonymousAccess) {
        this.allowAnonymousAccess = enableAnonymousAccess;
    }

    public void setMaxSizeLimit(int maxSizeLimit) {
        this.maxSizeLimit = maxSizeLimit;
    }

    public int getMaxSizeLimit() {
        return this.maxSizeLimit;
    }

    public void setMaxTimeLimit(int maxTimeLimit) {
        this.maxTimeLimit = maxTimeLimit;
    }

    public int getMaxTimeLimit() {
        return this.maxTimeLimit;
    }

    public Collection<ExtendedOperationHandler> getExtendedOperationHandlers() {
        return new ArrayList<ExtendedOperationHandler>(this.extendedOperationHandlers);
    }

    public void setExtendedOperationHandlers(Collection<ExtendedOperationHandler> handlers) {
        this.extendedOperationHandlers.clear();
        this.extendedOperationHandlers.addAll(handlers);
    }

    public String getSaslHost() {
        return this.saslHost;
    }

    public void setSaslHost(String saslHost) {
        this.saslHost = saslHost;
    }

    public String getSaslPrincipal() {
        return this.saslPrincipal;
    }

    public void setSaslPrincipal(String saslPrincipal) {
        this.saslPrincipal = saslPrincipal;
    }

    public String getSaslQopString() {
        return this.saslQopString;
    }

    public Set<String> getSaslQop() {
        return this.saslQop;
    }

    public List<String> getSaslRealms() {
        return this.saslRealms;
    }

    public void setSaslRealms(List<String> saslRealms) {
        this.saslRealms = saslRealms;
    }

    public Map<String, MechanismHandler> getSaslMechanismHandlers() {
        return this.saslMechanismHandlers;
    }

    public void setSaslMechanismHandlers(Map<String, MechanismHandler> saslMechanismHandlers) {
        this.saslMechanismHandlers = saslMechanismHandlers;
    }

    public MechanismHandler addSaslMechanismHandler(String mechanism, MechanismHandler handler) {
        return this.saslMechanismHandlers.put(mechanism, handler);
    }

    public MechanismHandler removeSaslMechanismHandler(String mechanism) {
        return this.saslMechanismHandlers.remove(mechanism);
    }

    public MechanismHandler getMechanismHandler(String mechanism) {
        return this.saslMechanismHandlers.get(mechanism);
    }

    public Set<String> getSupportedMechanisms() {
        return this.saslMechanismHandlers.keySet();
    }

    public void setDirectoryService(DirectoryService directoryService) {
        super.setDirectoryService(directoryService);
        this.codecFactory = new LdapProtocolCodecFactory(directoryService);
    }

    public Set<String> getSupportedControls() {
        return this.supportedControls;
    }

    public void setSupportedControls(Set<String> supportedControls) {
        this.supportedControls = supportedControls;
    }

    public MessageHandler<InternalAbandonRequest> getAbandonHandler() {
        return this.abandonHandler;
    }

    public void setAbandonHandler(LdapRequestHandler<InternalAbandonRequest> abandonHandler) {
        this.handler.removeReceivedMessageHandler(InternalAbandonRequest.class);
        this.abandonHandler = abandonHandler;
        this.abandonHandler.setLdapServer(this);
        this.handler.addReceivedMessageHandler(InternalAbandonRequest.class, this.abandonHandler);
    }

    public LdapRequestHandler<InternalAddRequest> getAddHandler() {
        return this.addHandler;
    }

    public void setAddHandler(LdapRequestHandler<InternalAddRequest> addHandler) {
        this.handler.removeReceivedMessageHandler(InternalAddRequest.class);
        this.addHandler = addHandler;
        this.addHandler.setLdapServer(this);
        this.handler.addReceivedMessageHandler(InternalAddRequest.class, this.addHandler);
    }

    public LdapRequestHandler<InternalBindRequest> getBindHandler() {
        return this.bindHandler;
    }

    public void setBindHandler(LdapRequestHandler<InternalBindRequest> bindHandler) {
        this.bindHandler = bindHandler;
        this.bindHandler.setLdapServer(this);
        this.handler.removeReceivedMessageHandler(InternalBindRequest.class);
        this.handler.addReceivedMessageHandler(InternalBindRequest.class, this.bindHandler);
    }

    public LdapRequestHandler<InternalCompareRequest> getCompareHandler() {
        return this.compareHandler;
    }

    public void setCompareHandler(LdapRequestHandler<InternalCompareRequest> compareHandler) {
        this.handler.removeReceivedMessageHandler(InternalCompareRequest.class);
        this.compareHandler = compareHandler;
        this.compareHandler.setLdapServer(this);
        this.handler.addReceivedMessageHandler(InternalCompareRequest.class, this.compareHandler);
    }

    public LdapRequestHandler<InternalDeleteRequest> getDeleteHandler() {
        return this.deleteHandler;
    }

    public void setDeleteHandler(LdapRequestHandler<InternalDeleteRequest> deleteHandler) {
        this.handler.removeReceivedMessageHandler(InternalDeleteRequest.class);
        this.deleteHandler = deleteHandler;
        this.deleteHandler.setLdapServer(this);
        this.handler.addReceivedMessageHandler(InternalDeleteRequest.class, this.deleteHandler);
    }

    public LdapRequestHandler<InternalExtendedRequest> getExtendedHandler() {
        return this.extendedHandler;
    }

    public void setExtendedHandler(LdapRequestHandler<InternalExtendedRequest> extendedHandler) {
        this.handler.removeReceivedMessageHandler(InternalExtendedRequest.class);
        this.extendedHandler = extendedHandler;
        this.extendedHandler.setLdapServer(this);
        this.handler.addReceivedMessageHandler(InternalExtendedRequest.class, this.extendedHandler);
    }

    public LdapRequestHandler<InternalModifyRequest> getModifyHandler() {
        return this.modifyHandler;
    }

    public void setModifyHandler(LdapRequestHandler<InternalModifyRequest> modifyHandler) {
        this.handler.removeReceivedMessageHandler(InternalModifyRequest.class);
        this.modifyHandler = modifyHandler;
        this.modifyHandler.setLdapServer(this);
        this.handler.addReceivedMessageHandler(InternalModifyRequest.class, this.modifyHandler);
    }

    public LdapRequestHandler<InternalModifyDnRequest> getModifyDnHandler() {
        return this.modifyDnHandler;
    }

    public void setModifyDnHandler(LdapRequestHandler<InternalModifyDnRequest> modifyDnHandler) {
        this.handler.removeReceivedMessageHandler(InternalModifyDnRequest.class);
        this.modifyDnHandler = modifyDnHandler;
        this.modifyDnHandler.setLdapServer(this);
        this.handler.addReceivedMessageHandler(InternalModifyDnRequest.class, this.modifyDnHandler);
    }

    public LdapRequestHandler<InternalSearchRequest> getSearchHandler() {
        return this.searchHandler;
    }

    public void setSearchHandler(LdapRequestHandler<InternalSearchRequest> searchHandler) {
        this.handler.removeReceivedMessageHandler(InternalSearchRequest.class);
        this.searchHandler = searchHandler;
        this.searchHandler.setLdapServer(this);
        this.handler.addReceivedMessageHandler(InternalSearchRequest.class, this.searchHandler);
    }

    public LdapRequestHandler<InternalUnbindRequest> getUnbindHandler() {
        return this.unbindHandler;
    }

    public int getPort() {
        if (this.transports == null) {
            return -1;
        }
        for (Transport transport : this.transports) {
            if (transport instanceof UdpTransport || transport.isSSLEnabled()) continue;
            return transport.getPort();
        }
        return -1;
    }

    public int getPortSSL() {
        if (this.transports == null) {
            return -1;
        }
        for (Transport transport : this.transports) {
            if (transport instanceof UdpTransport || !transport.isSSLEnabled()) continue;
            return transport.getPort();
        }
        return -1;
    }

    public void setUnbindHandler(LdapRequestHandler<InternalUnbindRequest> unbindHandler) {
        this.handler.removeReceivedMessageHandler(InternalUnbindRequest.class);
        this.unbindHandler = unbindHandler;
        this.unbindHandler.setLdapServer(this);
        this.handler.addReceivedMessageHandler(InternalUnbindRequest.class, this.unbindHandler);
    }

    public boolean isStarted() {
        return this.started;
    }

    public void setStarted(boolean started) {
        this.started = started;
    }

    public String getKeystoreFile() {
        return this.keystoreFile;
    }

    public void setKeystoreFile(String keystoreFile) {
        this.keystoreFile = keystoreFile;
    }

    public String getCertificatePassword() {
        return this.certificatePassword;
    }

    public void setCertificatePassword(String certificatePassword) {
        this.certificatePassword = certificatePassword;
    }

    public void setReplicationSystem(ReplicationSystem replicationSystem) {
        this.replicationSystem = replicationSystem;
    }

    public ReplicationSystem getReplicationSystem() {
        return this.replicationSystem;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LdapServer[").append(this.getServiceName()).append("], listening on :").append('\n');
        if (this.getTransports() != null) {
            for (Transport transport : this.getTransports()) {
                sb.append("    ").append(transport).append('\n');
            }
        }
        return sb.toString();
    }

    private class AdsKeyStore
    extends KeyStore {
        public AdsKeyStore(KeyStoreSpi keyStoreSpi, Provider provider, String type) {
            super(keyStoreSpi, provider, type);
        }
    }
}

