/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.bind.ntlm;

import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.directory.server.ldap.handlers.bind.ntlm.NtlmProvider;
import org.apache.directory.shared.ldap.message.BindRequest;
import org.apache.mina.common.IoSession;

public class NtlmSaslServer
implements SaslServer {
    private NegotiationState state = NegotiationState.INITIALIZED;
    private final NtlmProvider provider;
    private final BindRequest request;
    private final IoSession session;

    public NtlmSaslServer(NtlmProvider provider, BindRequest request, IoSession session) {
        this.session = session;
        this.request = request;
        this.provider = provider;
    }

    public String getMechanismName() {
        return "NTLM";
    }

    protected void responseRecieved() {
        switch (this.state) {
            case INITIALIZED: {
                this.state = NegotiationState.TYPE_1_RECEIVED;
                break;
            }
            case TYPE_1_RECEIVED: {
                throw new IllegalStateException("Cannot receive NTLM message before sending Type 2 challenge.");
            }
            case TYPE_2_SENT: {
                this.state = NegotiationState.TYPE_3_RECEIVED;
                break;
            }
            case TYPE_3_RECEIVED: {
                throw new IllegalStateException("Cannot receive NTLM message after Type 3 has been received.");
            }
            case COMPLETED: {
                throw new IllegalStateException("Sasl challenge response already completed.");
            }
        }
    }

    protected void responseSent() {
        switch (this.state) {
            case INITIALIZED: {
                throw new IllegalStateException("Cannot send Type 2 challenge before Type 1 response.");
            }
            case TYPE_1_RECEIVED: {
                this.state = NegotiationState.TYPE_2_SENT;
                break;
            }
            case TYPE_2_SENT: {
                throw new IllegalStateException("Cannot send Type 2 after it's already sent.");
            }
            case TYPE_3_RECEIVED: {
                this.state = NegotiationState.COMPLETED;
                break;
            }
            case COMPLETED: {
                throw new IllegalStateException("Sasl challenge response already completed.");
            }
        }
    }

    public byte[] evaluateResponse(byte[] response) throws SaslException {
        if (response == null) {
            throw new NullPointerException("response was null");
        }
        if (response.length == 0) {
            throw new IllegalArgumentException("response with zero bytes");
        }
        this.responseRecieved();
        byte[] retval = null;
        switch (this.state) {
            case TYPE_1_RECEIVED: {
                try {
                    retval = this.provider.generateChallenge(this.session, response);
                    break;
                }
                catch (Exception e) {
                    throw new SaslException("There was a failure during NTLM Type 1 message handling.", e);
                }
            }
            case TYPE_3_RECEIVED: {
                boolean result;
                try {
                    result = this.provider.authenticate(this.session, response);
                    this.session.setAttribute("java.naming.security.principal", (Object)this.request.getName().toString());
                }
                catch (Exception e) {
                    throw new SaslException("There was a failure during NTLM Type 3 message handling.", e);
                }
                if (result) break;
                throw new SaslException("Authentication occurred but the credentials were invalid.");
            }
        }
        this.responseSent();
        return retval;
    }

    public boolean isComplete() {
        return this.state == NegotiationState.COMPLETED;
    }

    public String getAuthorizationID() {
        return "";
    }

    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        return new byte[0];
    }

    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        return new byte[0];
    }

    public Object getNegotiatedProperty(String propName) {
        return "";
    }

    public void dispose() throws SaslException {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum NegotiationState {
        INITIALIZED,
        TYPE_1_RECEIVED,
        TYPE_2_SENT,
        TYPE_3_RECEIVED,
        COMPLETED;

    }
}

