/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.bind.ntlm;

import javax.security.sasl.SaslServer;
import org.apache.directory.server.ldap.handlers.bind.MechanismHandler;
import org.apache.directory.server.ldap.handlers.bind.ntlm.NtlmProvider;
import org.apache.directory.server.ldap.handlers.bind.ntlm.NtlmSaslServer;
import org.apache.directory.shared.ldap.message.BindRequest;
import org.apache.mina.common.IoSession;

public class NtlmMechanismHandler
implements MechanismHandler {
    private String providerFqcn;
    private NtlmProvider provider;

    public void setNtlmProvider(NtlmProvider provider) {
        this.provider = provider;
    }

    public void setNtlmProviderFqcn(String fqcnProvider) {
        this.providerFqcn = fqcnProvider;
    }

    public SaslServer handleMechanism(IoSession session, BindRequest bindRequest) throws Exception {
        SaslServer ss;
        if (session.containsAttribute("saslContext")) {
            ss = (SaslServer)session.getAttribute("saslContext");
        } else {
            if (this.provider == null) {
                this.initProvider();
            }
            ss = new NtlmSaslServer(this.provider, bindRequest, session);
            session.setAttribute("saslContext", (Object)ss);
        }
        return ss;
    }

    private void initProvider() throws Exception {
        this.provider = (NtlmProvider)Class.forName(this.providerFqcn).newInstance();
    }
}

