/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.bind;

import java.security.PrivilegedExceptionAction;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslServer;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.ldap.handlers.bind.GssapiCallbackHandler;
import org.apache.directory.server.ldap.handlers.bind.MechanismHandler;
import org.apache.directory.shared.ldap.message.BindRequest;
import org.apache.mina.common.IoSession;

public class GssapiMechanismHandler
implements MechanismHandler {
    private DirectoryService directoryService;

    public void setDirectoryService(DirectoryService directoryService) {
        this.directoryService = directoryService;
    }

    public SaslServer handleMechanism(IoSession session, BindRequest bindRequest) throws Exception {
        SaslServer ss;
        if (session.containsAttribute("saslContext")) {
            ss = (SaslServer)session.getAttribute("saslContext");
        } else {
            Subject subject = (Subject)session.getAttribute("saslSubject");
            final Map saslProps = (Map)session.getAttribute("saslProps");
            final String saslHost = (String)session.getAttribute("saslHost");
            final GssapiCallbackHandler callbackHandler = new GssapiCallbackHandler(this.directoryService, session, bindRequest);
            ss = Subject.doAs(subject, new PrivilegedExceptionAction<SaslServer>(){

                @Override
                public SaslServer run() throws Exception {
                    return Sasl.createSaslServer("GSSAPI", "ldap", saslHost, saslProps, callbackHandler);
                }
            });
            session.setAttribute("saslContext", (Object)ss);
        }
        return ss;
    }
}

