/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.bind;

import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchResult;
import org.apache.directory.server.protocol.shared.store.ContextOperation;
import org.apache.directory.shared.ldap.message.AttributeImpl;
import org.apache.directory.shared.ldap.message.AttributesImpl;
import org.apache.directory.shared.ldap.util.StringTools;

public class GetBindDn
implements ContextOperation {
    private static final long serialVersionUID = 4598007518413451945L;
    private String username;
    private String bindDn;
    private String userPassword;

    public GetBindDn(String username) {
        this.username = username;
    }

    public String getBindDn() {
        return this.bindDn;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public Object execute(DirContext ctx, Name base) {
        if (this.username == null) {
            return null;
        }
        String[] attrIDs = new String[]{"userPassword"};
        AttributesImpl matchAttrs = new AttributesImpl(true);
        matchAttrs.put((Attribute)new AttributeImpl("uid", (Object)this.username));
        try {
            NamingEnumeration<SearchResult> answer = ctx.search("", (Attributes)matchAttrs, attrIDs);
            if (answer.hasMore()) {
                Object userPassword;
                SearchResult result = answer.next();
                this.bindDn = result.getName();
                Attributes attrs = result.getAttributes();
                if (attrs == null) {
                    return null;
                }
                Attribute userPasswordAttr = attrs.get("userPassword");
                if (userPasswordAttr == null) {
                    userPassword = "";
                } else {
                    userPassword = userPasswordAttr.get();
                    if (userPassword instanceof byte[]) {
                        userPassword = StringTools.asciiBytesToString((byte[])((byte[])userPassword));
                    }
                }
                this.userPassword = (String)userPassword;
            }
        }
        catch (NamingException e) {
            return null;
        }
        return null;
    }
}

