/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.spi.InitialContextFactory;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.authn.LdapPrincipal;
import org.apache.directory.server.core.jndi.ServerLdapContext;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionType;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionKey;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntry;
import org.apache.directory.server.kerberos.shared.store.operations.GetPrincipal;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ldap.SessionRegistry;
import org.apache.directory.server.ldap.handlers.BindHandler;
import org.apache.directory.server.ldap.handlers.bind.MechanismHandler;
import org.apache.directory.server.ldap.handlers.bind.SaslFilter;
import org.apache.directory.server.protocol.shared.ServiceConfigurationException;
import org.apache.directory.shared.ldap.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.message.BindRequest;
import org.apache.directory.shared.ldap.message.BindResponse;
import org.apache.directory.shared.ldap.message.LdapResult;
import org.apache.directory.shared.ldap.message.Message;
import org.apache.directory.shared.ldap.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.message.MutableControl;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.ExceptionUtils;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBindHandler
extends BindHandler {
    private static final Logger LOG = LoggerFactory.getLogger(BindHandler.class);
    private static final MutableControl[] EMPTY_CONTROL = new MutableControl[0];
    private DirContext ctx = null;
    private Map<String, MechanismHandler> handlers = null;
    private SessionRegistry registry = null;

    public void setSaslMechanismHandlers(Map<String, MechanismHandler> handlers) {
        this.handlers = handlers;
    }

    public void setSessionRegistry(SessionRegistry registry) {
        this.registry = registry;
    }

    @Override
    public void setDirectoryService(DirectoryService directoryService) {
    }

    private Hashtable<String, Object> getEnvironment(BindRequest bindRequest, String authenticationLevel) {
        LdapDN principal = bindRequest.getName();
        byte[] credentials = bindRequest.getCredentials();
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} {}", (Object)"java.naming.security.principal", (Object)principal);
            LOG.debug("{} {}", (Object)"java.naming.security.credentials", (Object)credentials);
            LOG.debug("{} {}", (Object)"java.naming.security.authentication", (Object)authenticationLevel);
        }
        Hashtable<String, Object> env = this.getSessionRegistry().getEnvironmentByCopy();
        env.put("java.naming.security.principal", principal);
        if (credentials != null) {
            env.put("java.naming.security.credentials", credentials);
        }
        env.put("java.naming.security.authentication", authenticationLevel);
        if (bindRequest.getControls().containsKey("2.16.840.1.113730.3.4.2")) {
            env.put("java.naming.referral", "ignore");
        } else {
            env.put("java.naming.referral", "throw");
        }
        return env;
    }

    private LdapContext getLdapContext(IoSession session, BindRequest bindRequest, Hashtable<String, Object> env) {
        LdapResult result = bindRequest.getResultResponse().getLdapResult();
        LdapContext context = null;
        try {
            if (env.containsKey("server.use.factory.instance")) {
                InitialContextFactory factory = (InitialContextFactory)env.get("server.use.factory.instance");
                if (factory == null) {
                    LOG.error("The property 'server.use.factory.instance'  was set in env but was null");
                    throw new NullPointerException("server.use.factory.instance was set in env but was null");
                }
                context = (LdapContext)factory.getInitialContext(env);
            } else {
                MutableControl[] connCtls = bindRequest.getControls().values().toArray(EMPTY_CONTROL);
                context = new InitialLdapContext(env, (Control[])connCtls);
            }
        }
        catch (NamingException e) {
            ResultCodeEnum code = null;
            if (e instanceof LdapException) {
                code = ((LdapException)e).getResultCode();
                result.setResultCode(code);
            } else {
                code = ResultCodeEnum.getBestEstimate((Throwable)e, (MessageTypeEnum)bindRequest.getType());
                result.setResultCode(code);
            }
            String msg = "Bind failed: " + e.getMessage();
            if (LOG.isDebugEnabled()) {
                msg = msg + ":\n" + ExceptionUtils.getStackTrace((Throwable)e);
                msg = msg + "\n\nBindRequest = \n" + bindRequest.toString();
                LOG.debug(msg);
            }
            if (e.getResolvedName() != null && (code == ResultCodeEnum.NO_SUCH_OBJECT || code == ResultCodeEnum.ALIAS_PROBLEM || code == ResultCodeEnum.INVALID_DN_SYNTAX || code == ResultCodeEnum.ALIAS_DEREFERENCING_PROBLEM)) {
                result.setMatchedDn((LdapDN)e.getResolvedName());
            }
            result.setErrorMessage(msg);
            session.write((Object)bindRequest.getResultResponse());
            context = null;
        }
        return context;
    }

    private void handleSimpleAuth(IoSession session, BindRequest bindRequest) throws NamingException {
        LdapResult bindResult = bindRequest.getResultResponse().getLdapResult();
        Hashtable<String, Object> env = this.getEnvironment(bindRequest, AuthenticationLevel.SIMPLE.toString());
        LdapContext context = this.getLdapContext(session, bindRequest, env);
        if (context != null) {
            ServerLdapContext newCtx = (ServerLdapContext)context.lookup("");
            this.setRequestControls((LdapContext)newCtx, (Message)bindRequest);
            this.getSessionRegistry().setLdapContext(session, (LdapContext)newCtx);
            bindResult.setResultCode(ResultCodeEnum.SUCCESS);
            BindResponse response = (BindResponse)bindRequest.getResultResponse();
            response.addAll(newCtx.getResponseControls());
            session.write((Object)response);
            LOG.debug("Returned SUCCESS message.");
        }
    }

    public void handleSaslAuth(IoSession session, Object message) throws Exception {
        LdapServer ldapServer = (LdapServer)((Object)session.getAttribute(LdapServer.class.toString()));
        HashMap<String, String> saslProps = new HashMap<String, String>();
        saslProps.put("javax.security.sasl.qop", ldapServer.getSaslQopString());
        saslProps.put("com.sun.security.sasl.digest.realm", this.getActiveRealms(ldapServer));
        session.setAttribute("saslProps", saslProps);
        session.setAttribute("saslHost", (Object)ldapServer.getSaslHost());
        session.setAttribute("baseDn", (Object)ldapServer.getSearchBaseDn());
        Set<String> activeMechanisms = ldapServer.getSupportedMechanisms();
        if (activeMechanisms.contains("GSSAPI")) {
            try {
                Subject saslSubject = this.getSubject(ldapServer);
                session.setAttribute("saslSubject", (Object)saslSubject);
            }
            catch (ServiceConfigurationException sce) {
                activeMechanisms.remove("GSSAPI");
                LOG.warn(sce.getMessage());
            }
        }
        BindRequest bindRequest = (BindRequest)message;
        if (!ldapServer.getSupportedMechanisms().contains(bindRequest.getSaslMechanism())) {
            LOG.error("Bind error : {} mechanism not supported. Please check the server.xml configuration file (supportedMechanisms field)", (Object)bindRequest.getSaslMechanism());
            LdapResult bindResult = bindRequest.getResultResponse().getLdapResult();
            bindResult.setResultCode(ResultCodeEnum.AUTH_METHOD_NOT_SUPPORTED);
            bindResult.setErrorMessage(bindRequest.getSaslMechanism() + " is not a supported mechanism.");
            session.write((Object)bindRequest.getResultResponse());
            return;
        }
        this.handleSasl(session, bindRequest);
    }

    public void handleSasl(IoSession session, BindRequest bindRequest) throws Exception {
        String sessionMechanism = bindRequest.getSaslMechanism();
        if (sessionMechanism.equals("PLAIN")) {
            session.setAttribute("java.naming.security.principal", (Object)bindRequest.getName());
            session.setAttribute("java.naming.security.credentials", (Object)bindRequest.getCredentials());
            this.getLdapContext(session, bindRequest);
        } else {
            MechanismHandler mechanismHandler = this.handlers.get(sessionMechanism);
            if (mechanismHandler == null) {
                LOG.error("Handler unavailable for " + sessionMechanism);
                throw new IllegalArgumentException("Handler unavailable for " + sessionMechanism);
            }
            SaslServer ss = mechanismHandler.handleMechanism(session, bindRequest);
            LdapResult result = bindRequest.getResultResponse().getLdapResult();
            if (!ss.isComplete()) {
                try {
                    if (bindRequest.getCredentials() == null) {
                        bindRequest.setCredentials(new byte[0]);
                    }
                    byte[] tokenBytes = ss.evaluateResponse(bindRequest.getCredentials());
                    if (ss.isComplete()) {
                        if (tokenBytes != null) {
                            session.setAttribute("saslCreds", (Object)tokenBytes);
                        }
                        this.getLdapContext(session, bindRequest);
                    } else {
                        LOG.info("Continuation token had length " + tokenBytes.length);
                        result.setResultCode(ResultCodeEnum.SASL_BIND_IN_PROGRESS);
                        BindResponse resp = (BindResponse)bindRequest.getResultResponse();
                        resp.setServerSaslCreds(tokenBytes);
                        session.write((Object)resp);
                        LOG.debug("Returning final authentication data to client to complete context.");
                    }
                }
                catch (SaslException se) {
                    LOG.error(se.getMessage());
                    result.setResultCode(ResultCodeEnum.INVALID_CREDENTIALS);
                    result.setErrorMessage(se.getMessage());
                    session.write((Object)bindRequest.getResultResponse());
                }
            }
        }
    }

    private String getActiveRealms(LdapServer ldapServer) {
        StringBuilder realms = new StringBuilder();
        boolean isFirst = true;
        for (String realm : ldapServer.getSaslRealms()) {
            if (isFirst) {
                isFirst = false;
            } else {
                realms.append(' ');
            }
            realms.append(realm);
        }
        return realms.toString();
    }

    private Subject getSubject(LdapServer ldapServer) {
        String servicePrincipalName = ldapServer.getSaslPrincipal();
        KerberosPrincipal servicePrincipal = new KerberosPrincipal(servicePrincipalName);
        GetPrincipal getPrincipal = new GetPrincipal(servicePrincipal);
        PrincipalStoreEntry entry = null;
        try {
            entry = this.findPrincipal(ldapServer, getPrincipal);
        }
        catch (ServiceConfigurationException sce) {
            String message = "Service principal " + servicePrincipalName + " not found at search base DN " + ldapServer.getSearchBaseDn() + ".";
            throw new ServiceConfigurationException(message, (Throwable)sce);
        }
        if (entry == null) {
            String message = "Service principal " + servicePrincipalName + " not found at search base DN " + ldapServer.getSearchBaseDn() + ".";
            throw new ServiceConfigurationException(message);
        }
        Subject subject = new Subject();
        for (EncryptionType encryptionType : entry.getKeyMap().keySet()) {
            EncryptionKey key = (EncryptionKey)entry.getKeyMap().get(encryptionType);
            byte[] keyBytes = key.getKeyValue();
            int type = key.getKeyType().getOrdinal();
            int kvno = key.getKeyVersion();
            KerberosKey serviceKey = new KerberosKey(servicePrincipal, keyBytes, type, kvno);
            subject.getPrivateCredentials().add(serviceKey);
        }
        return subject;
    }

    private PrincipalStoreEntry findPrincipal(LdapServer ldapServer, GetPrincipal getPrincipal) {
        if (this.ctx == null) {
            try {
                LdapDN adminDN = new LdapDN("uid=admin,ou=system");
                adminDN.normalize(ldapServer.getDirectoryService().getRegistries().getAttributeTypeRegistry().getNormalizerMapping());
                LdapPrincipal principal = new LdapPrincipal(adminDN, AuthenticationLevel.SIMPLE);
                this.ctx = ldapServer.getDirectoryService().getJndiContext(principal, ldapServer.getSearchBaseDn());
            }
            catch (NamingException ne) {
                String message = "Failed to get initial context " + ldapServer.getSearchBaseDn();
                throw new ServiceConfigurationException(message, (Throwable)ne);
            }
        }
        return (PrincipalStoreEntry)getPrincipal.execute(this.ctx, null);
    }

    private Hashtable<String, Object> getEnvironment(IoSession session, BindRequest bindRequest) {
        Object principal = session.getAttribute("java.naming.security.principal");
        Object credentials = session.getAttribute("java.naming.security.credentials");
        String sessionMechanism = bindRequest.getSaslMechanism();
        String authenticationLevel = this.getAuthenticationLevel(sessionMechanism);
        LOG.debug("{} {}", (Object)"java.naming.security.principal", principal);
        LOG.debug("{} {}", (Object)"java.naming.security.credentials", credentials);
        LOG.debug("{} {}", (Object)"java.naming.security.authentication", (Object)authenticationLevel);
        Hashtable<String, Object> env = this.registry.getEnvironmentByCopy();
        env.put("java.naming.security.principal", principal);
        if (credentials != null) {
            env.put("java.naming.security.credentials", credentials);
        }
        env.put("java.naming.security.authentication", authenticationLevel);
        if (bindRequest.getControls().containsKey("2.16.840.1.113730.3.4.2")) {
            env.put("java.naming.referral", "ignore");
        } else {
            env.put("java.naming.referral", "throw");
        }
        return env;
    }

    private void getLdapContext(IoSession session, BindRequest bindRequest) {
        Hashtable<String, Object> env = this.getEnvironment(session, bindRequest);
        LdapResult result = bindRequest.getResultResponse().getLdapResult();
        InitialLdapContext context = null;
        try {
            MutableControl[] connCtls = bindRequest.getControls().values().toArray(EMPTY_CONTROL);
            context = new InitialLdapContext(env, (Control[])connCtls);
            this.registry.setLdapContext(session, context);
            bindRequest.getResultResponse().addAll(context.getResponseControls());
            this.returnSuccess(session, bindRequest);
        }
        catch (NamingException e) {
            ResultCodeEnum code = null;
            if (e instanceof LdapException) {
                code = ((LdapException)e).getResultCode();
                result.setResultCode(code);
            } else {
                code = ResultCodeEnum.getBestEstimate((Throwable)e, (MessageTypeEnum)bindRequest.getType());
                result.setResultCode(code);
            }
            String msg = "Bind failed: " + e.getMessage();
            if (LOG.isDebugEnabled()) {
                msg = msg + ":\n" + ExceptionUtils.getStackTrace((Throwable)e);
                msg = msg + "\n\nBindRequest = \n" + bindRequest.toString();
            }
            if (e.getResolvedName() != null && (code == ResultCodeEnum.NO_SUCH_OBJECT || code == ResultCodeEnum.ALIAS_PROBLEM || code == ResultCodeEnum.INVALID_DN_SYNTAX || code == ResultCodeEnum.ALIAS_DEREFERENCING_PROBLEM)) {
                result.setMatchedDn((LdapDN)e.getResolvedName());
            }
            result.setErrorMessage(msg);
            session.write((Object)bindRequest.getResultResponse());
        }
    }

    private void returnSuccess(IoSession session, BindRequest bindRequest) {
        LdapResult result = bindRequest.getResultResponse().getLdapResult();
        byte[] tokenBytes = (byte[])session.getAttribute("saslCreds");
        result.setResultCode(ResultCodeEnum.SUCCESS);
        BindResponse response = (BindResponse)bindRequest.getResultResponse();
        response.setServerSaslCreds(tokenBytes);
        String sessionMechanism = bindRequest.getSaslMechanism();
        if (sessionMechanism.equals("DIGEST-MD5") || sessionMechanism.equals("GSSAPI")) {
            LOG.debug("Inserting SaslFilter to engage negotiated security layer.");
            IoFilterChain chain = session.getFilterChain();
            if (!chain.contains("SASL")) {
                SaslServer saslContext = (SaslServer)session.getAttribute("saslContext");
                chain.addBefore("codec", "SASL", (IoFilter)new SaslFilter(saslContext));
            }
            session.setAttribute(SaslFilter.DISABLE_SECURITY_LAYER_ONCE, (Object)Boolean.TRUE);
        }
        session.write((Object)response);
        LOG.debug("Returned SUCCESS message.");
    }

    private String getAuthenticationLevel(String sessionMechanism) {
        if (sessionMechanism.equals("PLAIN")) {
            return AuthenticationLevel.SIMPLE.toString();
        }
        return AuthenticationLevel.STRONG.toString();
    }

    @Override
    protected void bindMessageReceived(IoSession session, BindRequest bindRequest) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("User {} is binding", (Object)bindRequest.getName());
            if (bindRequest.isSimple()) {
                LOG.debug("Using simple authentication.");
            } else {
                LOG.debug("Using SASL authentication with mechanism:  {}", (Object)bindRequest.getSaslMechanism());
            }
        }
        if (!this.isConfidentialityRequirementSatisfied(session)) {
            LdapResult result = bindRequest.getResultResponse().getLdapResult();
            result.setResultCode(ResultCodeEnum.CONFIDENTIALITY_REQUIRED);
            result.setErrorMessage("Confidentiality (TLS secured connection) is required.");
            session.write((Object)bindRequest.getResultResponse());
            return;
        }
        if (!bindRequest.getVersion3()) {
            LOG.error("Bind error : Only LDAP v3 is supported.");
            LdapResult bindResult = bindRequest.getResultResponse().getLdapResult();
            bindResult.setResultCode(ResultCodeEnum.PROTOCOL_ERROR);
            bindResult.setErrorMessage("Only LDAP v3 is supported.");
            session.write((Object)bindRequest.getResultResponse());
            return;
        }
        if (bindRequest.isSimple()) {
            this.handleSimpleAuth(session, bindRequest);
        } else {
            this.handleSaslAuth(session, bindRequest);
        }
    }
}

