/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.gui;

import java.net.InetSocketAddress;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.apache.mina.common.IoSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionsModel
implements TableModel {
    final String[] columns = new String[]{"client address", "client port", "server address", "server port"};
    final Class<?>[] columnClasses = new Class[]{String.class, Integer.class, String.class, Integer.class};
    final IoSession[] sessions;

    SessionsModel(IoSession[] sessions) {
        this.sessions = sessions;
    }

    IoSession getIoSession(int row) {
        return this.sessions[row];
    }

    @Override
    public int getRowCount() {
        return this.sessions.length;
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columns[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.columnClasses[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        IoSession session = this.sessions[rowIndex];
        switch (columnIndex) {
            case 0: {
                return ((InetSocketAddress)session.getRemoteAddress()).getHostName();
            }
            case 1: {
                return new Integer(((InetSocketAddress)session.getRemoteAddress()).getPort());
            }
            case 2: {
                return ((InetSocketAddress)session.getLocalAddress()).getHostName();
            }
            case 3: {
                return new Integer(((InetSocketAddress)session.getLocalAddress()).getPort());
            }
        }
        throw new IndexOutOfBoundsException("column index max is " + (this.columns.length - 1));
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
    }
}

