/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.KeyStore;
import java.security.KeyStoreSpi;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.ldap.Control;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.core.security.CoreKeyStoreSpi;
import org.apache.directory.server.ldap.ExtendedOperationHandler;
import org.apache.directory.server.ldap.SessionRegistry;
import org.apache.directory.server.ldap.support.AbandonHandler;
import org.apache.directory.server.ldap.support.AddHandler;
import org.apache.directory.server.ldap.support.BindHandler;
import org.apache.directory.server.ldap.support.CompareHandler;
import org.apache.directory.server.ldap.support.DefaultAbandonHandler;
import org.apache.directory.server.ldap.support.DefaultAddHandler;
import org.apache.directory.server.ldap.support.DefaultBindHandler;
import org.apache.directory.server.ldap.support.DefaultCompareHandler;
import org.apache.directory.server.ldap.support.DefaultDeleteHandler;
import org.apache.directory.server.ldap.support.DefaultExtendedHandler;
import org.apache.directory.server.ldap.support.DefaultModifyDnHandler;
import org.apache.directory.server.ldap.support.DefaultModifyHandler;
import org.apache.directory.server.ldap.support.DefaultSearchHandler;
import org.apache.directory.server.ldap.support.DefaultUnbindHandler;
import org.apache.directory.server.ldap.support.DeleteHandler;
import org.apache.directory.server.ldap.support.ExtendedHandler;
import org.apache.directory.server.ldap.support.ModifyDnHandler;
import org.apache.directory.server.ldap.support.ModifyHandler;
import org.apache.directory.server.ldap.support.SearchHandler;
import org.apache.directory.server.ldap.support.UnbindHandler;
import org.apache.directory.server.ldap.support.ssl.LdapsInitializer;
import org.apache.directory.server.protocol.shared.DirectoryBackedService;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.shared.asn1.codec.Asn1CodecDecoder;
import org.apache.directory.shared.asn1.codec.Asn1CodecEncoder;
import org.apache.directory.shared.asn1.codec.stateful.StatefulDecoder;
import org.apache.directory.shared.asn1.codec.stateful.StatefulEncoder;
import org.apache.directory.shared.ldap.exception.LdapConfigurationException;
import org.apache.directory.shared.ldap.exception.LdapNamingException;
import org.apache.directory.shared.ldap.message.AbandonRequest;
import org.apache.directory.shared.ldap.message.AddRequest;
import org.apache.directory.shared.ldap.message.BindRequest;
import org.apache.directory.shared.ldap.message.CompareRequest;
import org.apache.directory.shared.ldap.message.DeleteRequest;
import org.apache.directory.shared.ldap.message.ExtendedRequest;
import org.apache.directory.shared.ldap.message.ExtendedRequestImpl;
import org.apache.directory.shared.ldap.message.MessageDecoder;
import org.apache.directory.shared.ldap.message.MessageEncoder;
import org.apache.directory.shared.ldap.message.ModifyDnRequest;
import org.apache.directory.shared.ldap.message.ModifyRequest;
import org.apache.directory.shared.ldap.message.MutableControl;
import org.apache.directory.shared.ldap.message.Request;
import org.apache.directory.shared.ldap.message.ResponseCarryingMessageException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.message.ResultResponse;
import org.apache.directory.shared.ldap.message.ResultResponseRequest;
import org.apache.directory.shared.ldap.message.SearchRequest;
import org.apache.directory.shared.ldap.message.UnbindRequest;
import org.apache.directory.shared.ldap.message.extended.NoticeOfDisconnect;
import org.apache.directory.shared.ldap.message.spi.BinaryAttributeDetector;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.mina.common.DefaultIoFilterChainBuilder;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoFilterChainBuilder;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.ThreadModel;
import org.apache.mina.common.WriteFuture;
import org.apache.mina.filter.SSLFilter;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.handler.demux.DemuxingIoHandler;
import org.apache.mina.transport.socket.nio.SocketAcceptorConfig;
import org.apache.mina.util.SessionLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapServer
extends DirectoryBackedService {
    private static final long serialVersionUID = 3757127143811666817L;
    private static final Logger LOG = LoggerFactory.getLogger((String)LdapServer.class.getName());
    private static final int MAX_SIZE_LIMIT_DEFAULT = 100;
    private static final int MAX_TIME_LIMIT_DEFAULT = 10000;
    private static final String SERVICE_PID_DEFAULT = "org.apache.directory.server.ldap";
    private static final String SERVICE_NAME_DEFAULT = "ApacheDS LDAP Service";
    private static final int IP_PORT_DEFAULT = 389;
    public static final String SERVICE_NAME = "ldap";
    private Set<String> supportedControls;
    private int maxSizeLimit = 100;
    private int maxTimeLimit = 10000;
    private boolean enableLdaps;
    private boolean allowAnonymousAccess = true;
    private final Collection<ExtendedOperationHandler> extendedOperationHandlers = new ArrayList<ExtendedOperationHandler>();
    private Set<String> supportedMechanisms;
    private String saslHost = "ldap.example.com";
    private String saslPrincipal = "ldap/ldap.example.com@EXAMPLE.COM";
    private Set<String> saslQop;
    private String saslQopString;
    private List<String> saslRealms;
    private AbandonHandler abandonHandler;
    private AddHandler addHandler;
    private BindHandler bindHandler;
    private CompareHandler compareHandler;
    private DeleteHandler deleteHandler;
    private ExtendedHandler extendedHandler;
    private ModifyHandler modifyHandler;
    private ModifyDnHandler modifyDnHandler;
    private SearchHandler searchHandler;
    private UnbindHandler unbindHandler;
    private SessionRegistry registry;
    private ProtocolCodecFactory codecFactory;
    private final LdapProtocolHandler handler = new LdapProtocolHandler();
    private boolean started;

    public LdapServer() {
        super.setIpPort(389);
        super.setEnabled(true);
        super.setServiceId(SERVICE_PID_DEFAULT);
        super.setServiceName(SERVICE_NAME_DEFAULT);
        this.supportedMechanisms = new HashSet<String>();
        this.supportedMechanisms.add("SIMPLE");
        this.supportedMechanisms.add("CRAM-MD5");
        this.supportedMechanisms.add("DIGEST-MD5");
        this.supportedMechanisms.add("GSSAPI");
        this.saslQop = new HashSet<String>();
        this.saslQop.add("auth");
        this.saslQop.add("auth-int");
        this.saslQop.add("auth-conf");
        this.saslQopString = "auth,auth-int,auth-conf";
        this.saslRealms = new ArrayList<String>();
        this.saslRealms.add("example.com");
        this.supportedControls = new HashSet<String>();
        this.supportedControls.add("2.16.840.1.113730.3.4.3");
        this.supportedControls.add("2.16.840.1.113730.3.4.7");
        this.supportedControls.add("1.3.6.1.4.1.4203.1.10.1");
        this.supportedControls.add("2.16.840.1.113730.3.4.2");
        this.supportedControls.add("1.3.6.1.4.1.18060.0.0.1");
    }

    private void installDefaultHandlers() {
        if (this.getAbandonHandler() == null) {
            this.setAbandonHandler(new DefaultAbandonHandler());
        }
        if (this.getAddHandler() == null) {
            this.setAddHandler(new DefaultAddHandler());
        }
        if (this.getBindHandler() == null) {
            this.setBindHandler(new DefaultBindHandler(this.getDirectoryService(), this.registry));
        }
        if (this.getCompareHandler() == null) {
            this.setCompareHandler(new DefaultCompareHandler());
        }
        if (this.getDeleteHandler() == null) {
            this.setDeleteHandler(new DefaultDeleteHandler());
        }
        if (this.getExtendedHandler() == null) {
            this.setExtendedHandler(new DefaultExtendedHandler());
        }
        if (this.getModifyHandler() == null) {
            this.setModifyHandler(new DefaultModifyHandler());
        }
        if (this.getModifyDnHandler() == null) {
            this.setModifyDnHandler(new DefaultModifyDnHandler());
        }
        if (this.getSearchHandler() == null) {
            this.setSearchHandler(new DefaultSearchHandler());
        }
        if (this.getUnbindHandler() == null) {
            this.setUnbindHandler(new DefaultUnbindHandler());
        }
    }

    public void start() throws NamingException, IOException {
        DefaultIoFilterChainBuilder chain;
        if (!this.isEnabled()) {
            return;
        }
        if (this.isEnableLdaps()) {
            Provider provider = Security.getProvider("SUN");
            LOG.debug("provider = {}", (Object)provider);
            CoreKeyStoreSpi coreKeyStoreSpi = new CoreKeyStoreSpi(this.getDirectoryService());
            KeyStore keyStore = new KeyStore((KeyStoreSpi)coreKeyStoreSpi, provider, "JKS"){};
            try {
                keyStore.load(null, null);
            }
            catch (Exception e) {
                // empty catch block
            }
            chain = LdapsInitializer.init(keyStore);
        } else {
            chain = new DefaultIoFilterChainBuilder();
        }
        this.installDefaultHandlers();
        this.startLDAP0(this.getIpPort(), (IoFilterChainBuilder)chain);
        this.started = true;
    }

    public void stop() {
        try {
            ArrayList sessions;
            ArrayList<WriteFuture> writeFutures = new ArrayList<WriteFuture>();
            try {
                sessions = new ArrayList(this.getSocketAcceptor().getManagedSessions((SocketAddress)new InetSocketAddress(this.getIpPort())));
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Seems like the LDAP service (" + this.getIpPort() + ") has already been unbound.");
                return;
            }
            this.getSocketAcceptor().unbind((SocketAddress)new InetSocketAddress(this.getIpPort()));
            if (LOG.isInfoEnabled()) {
                LOG.info("Unbind of an LDAP service (" + this.getIpPort() + ") is complete.");
                LOG.info("Sending notice of disconnect to existing clients sessions.");
            }
            if (sessions != null) {
                for (IoSession session : sessions) {
                    writeFutures.add(session.write((Object)NoticeOfDisconnect.UNAVAILABLE));
                }
            }
            Iterator sessionIt = sessions.iterator();
            for (WriteFuture future : writeFutures) {
                future.join(1000L);
                ((IoSession)sessionIt.next()).close();
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to sent NoD.", (Throwable)e);
        }
    }

    private void startLDAP0(int port, IoFilterChainBuilder chainBuilder) throws LdapNamingException, LdapConfigurationException, NamingException {
        for (ExtendedOperationHandler h : this.getExtendedOperationHandlers()) {
            this.addExtendedOperationHandler(h);
            LOG.info("Added Extended Request Handler: " + h.getOid());
            h.setLdapProvider(this);
            PartitionNexus nexus = this.getDirectoryService().getPartitionNexus();
            nexus.registerSupportedExtensions(h.getExtensionOids());
        }
        try {
            SocketAcceptorConfig acceptorCfg = new SocketAcceptorConfig();
            acceptorCfg.setDisconnectOnUnbind(false);
            acceptorCfg.setReuseAddress(true);
            acceptorCfg.setFilterChainBuilder(chainBuilder);
            acceptorCfg.setThreadModel(ThreadModel.MANUAL);
            acceptorCfg.getSessionConfig().setTcpNoDelay(true);
            this.getSocketAcceptor().bind((SocketAddress)new InetSocketAddress(port), this.getHandler(), (IoServiceConfig)acceptorCfg);
            this.started = true;
            if (LOG.isInfoEnabled()) {
                LOG.info("Successful bind of an LDAP Service (" + port + ") is complete.");
            }
        }
        catch (IOException e) {
            String msg = "Failed to bind an LDAP service (" + port + ") to the service registry.";
            LdapConfigurationException lce = new LdapConfigurationException(msg);
            lce.setRootCause((Throwable)e);
            LOG.error(msg, (Throwable)e);
            throw lce;
        }
    }

    public String getName() {
        return SERVICE_NAME;
    }

    public ProtocolCodecFactory getCodecFactory() {
        return this.codecFactory;
    }

    public IoHandler getHandler() {
        return this.handler;
    }

    public void addExtendedOperationHandler(ExtendedOperationHandler eoh) {
        if (this.extendedHandler == null) {
            this.setExtendedHandler(new DefaultExtendedHandler());
        }
        this.extendedHandler.addHandler(eoh);
    }

    public void removeExtendedOperationHandler(String oid) {
        this.extendedHandler.removeHandler(oid);
    }

    public ExtendedOperationHandler getExtendedOperationHandler(String oid) {
        return this.extendedHandler.getHandler(oid);
    }

    public Map<String, ExtendedOperationHandler> getExtendedOperationHandlerMap() {
        return this.extendedHandler.getHandlerMap();
    }

    public boolean isEnableLdaps() {
        return this.enableLdaps;
    }

    public void setEnableLdaps(boolean enableLdaps) {
        this.enableLdaps = enableLdaps;
    }

    public boolean isAllowAnonymousAccess() {
        return this.allowAnonymousAccess;
    }

    public void setAllowAnonymousAccess(boolean enableAnonymousAccess) {
        this.allowAnonymousAccess = enableAnonymousAccess;
    }

    public void setMaxSizeLimit(int maxSizeLimit) {
        this.maxSizeLimit = maxSizeLimit;
    }

    public int getMaxSizeLimit() {
        return this.maxSizeLimit;
    }

    public void setMaxTimeLimit(int maxTimeLimit) {
        this.maxTimeLimit = maxTimeLimit;
    }

    public int getMaxTimeLimit() {
        return this.maxTimeLimit;
    }

    public Collection<ExtendedOperationHandler> getExtendedOperationHandlers() {
        return new ArrayList<ExtendedOperationHandler>(this.extendedOperationHandlers);
    }

    public void setExtendedOperationHandlers(Collection<ExtendedOperationHandler> handlers) {
        this.extendedOperationHandlers.clear();
        this.extendedOperationHandlers.addAll(handlers);
    }

    public String getSaslHost() {
        return this.saslHost;
    }

    public void setSaslHost(String saslHost) {
        this.saslHost = saslHost;
    }

    public String getSaslPrincipal() {
        return this.saslPrincipal;
    }

    public void setSaslPrincipal(String saslPrincipal) {
        this.saslPrincipal = saslPrincipal;
    }

    public String getSaslQopString() {
        return this.saslQopString;
    }

    public Set<String> getSaslQop() {
        return this.saslQop;
    }

    public void setSaslQop(Set<String> saslQop) {
        StringBuilder qopList = new StringBuilder();
        boolean isFirst = true;
        for (String qop : saslQop) {
            if (isFirst) {
                isFirst = false;
            } else {
                qopList.append(',');
            }
            qopList.append(qop);
        }
        this.saslQopString = qopList.toString();
        this.saslQop = saslQop;
    }

    public List<String> getSaslRealms() {
        return this.saslRealms;
    }

    public void setSaslRealms(List<String> saslRealms) {
        this.saslRealms = saslRealms;
    }

    public Set<String> getSupportedMechanisms() {
        return this.supportedMechanisms;
    }

    public void setSupportedMechanisms(Set<String> supportedMechanisms) {
        this.supportedMechanisms = supportedMechanisms;
    }

    public void setDirectoryService(DirectoryService directoryService) {
        super.setDirectoryService(directoryService);
        this.codecFactory = new ProtocolCodecFactoryImpl(directoryService);
        Hashtable<String, Object> copy = new Hashtable<String, Object>();
        copy.put("java.naming.provider.url", "");
        copy.put("java.naming.factory.initial", "org.apache.directory.server.core.jndi.CoreContextFactory");
        copy.put(DirectoryService.JNDI_KEY, directoryService);
        this.registry = new SessionRegistry(this, copy);
    }

    public Set<String> getSupportedControls() {
        return this.supportedControls;
    }

    public void setSupportedControls(Set<String> supportedControls) {
        this.supportedControls = supportedControls;
    }

    public AbandonHandler getAbandonHandler() {
        return this.abandonHandler;
    }

    public void setAbandonHandler(AbandonHandler abandonHandler) {
        this.handler.removeMessageHandler(AbandonRequest.class);
        this.abandonHandler = abandonHandler;
        this.abandonHandler.setProtocolProvider(this);
        this.handler.addMessageHandler(AbandonRequest.class, this.abandonHandler);
    }

    public AddHandler getAddHandler() {
        return this.addHandler;
    }

    public void setAddHandler(AddHandler addHandler) {
        this.handler.removeMessageHandler(AddRequest.class);
        this.addHandler = addHandler;
        this.addHandler.setProtocolProvider(this);
        this.handler.addMessageHandler(AddRequest.class, this.addHandler);
    }

    public BindHandler getBindHandler() {
        return this.bindHandler;
    }

    public void setBindHandler(BindHandler bindHandler) {
        this.handler.removeMessageHandler(BindRequest.class);
        this.bindHandler = bindHandler;
        this.bindHandler.setProtocolProvider(this);
        this.bindHandler.setDirectoryService(this.getDirectoryService());
        this.handler.addMessageHandler(BindRequest.class, this.bindHandler);
    }

    public CompareHandler getCompareHandler() {
        return this.compareHandler;
    }

    public void setCompareHandler(CompareHandler compareHandler) {
        this.handler.removeMessageHandler(CompareRequest.class);
        this.compareHandler = compareHandler;
        this.compareHandler.setProtocolProvider(this);
        this.handler.addMessageHandler(CompareRequest.class, this.compareHandler);
    }

    public DeleteHandler getDeleteHandler() {
        return this.deleteHandler;
    }

    public void setDeleteHandler(DeleteHandler deleteHandler) {
        this.handler.removeMessageHandler(DeleteRequest.class);
        this.deleteHandler = deleteHandler;
        this.deleteHandler.setProtocolProvider(this);
        this.handler.addMessageHandler(DeleteRequest.class, this.deleteHandler);
    }

    public ExtendedHandler getExtendedHandler() {
        return this.extendedHandler;
    }

    public void setExtendedHandler(ExtendedHandler extendedHandler) {
        this.handler.removeMessageHandler(ExtendedRequest.class);
        this.extendedHandler = extendedHandler;
        this.extendedHandler.setProtocolProvider(this);
        this.handler.addMessageHandler(ExtendedRequest.class, this.extendedHandler);
    }

    public ModifyHandler getModifyHandler() {
        return this.modifyHandler;
    }

    public void setModifyHandler(ModifyHandler modifyHandler) {
        this.handler.removeMessageHandler(ModifyRequest.class);
        this.modifyHandler = modifyHandler;
        this.modifyHandler.setProtocolProvider(this);
        this.handler.addMessageHandler(ModifyRequest.class, this.modifyHandler);
    }

    public ModifyDnHandler getModifyDnHandler() {
        return this.modifyDnHandler;
    }

    public void setModifyDnHandler(ModifyDnHandler modifyDnHandler) {
        this.handler.removeMessageHandler(ModifyDnRequest.class);
        this.modifyDnHandler = modifyDnHandler;
        this.modifyDnHandler.setProtocolProvider(this);
        this.handler.addMessageHandler(ModifyDnRequest.class, this.modifyDnHandler);
    }

    public SearchHandler getSearchHandler() {
        return this.searchHandler;
    }

    public void setSearchHandler(SearchHandler searchHandler) {
        this.handler.removeMessageHandler(SearchRequest.class);
        this.searchHandler = searchHandler;
        this.searchHandler.setProtocolProvider(this);
        this.handler.addMessageHandler(SearchRequest.class, this.searchHandler);
    }

    public UnbindHandler getUnbindHandler() {
        return this.unbindHandler;
    }

    public void setUnbindHandler(UnbindHandler unbindHandler) {
        this.handler.removeMessageHandler(UnbindRequest.class);
        this.unbindHandler = unbindHandler;
        this.unbindHandler.setProtocolProvider(this);
        this.handler.addMessageHandler(UnbindRequest.class, this.unbindHandler);
    }

    public SessionRegistry getRegistry() {
        return this.registry;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void setStarted(boolean started) {
        this.started = started;
    }

    private class LdapProtocolHandler
    extends DemuxingIoHandler {
        private LdapProtocolHandler() {
        }

        public void sessionCreated(IoSession session) throws Exception {
            session.setAttribute(LdapServer.class.toString(), (Object)LdapServer.this);
            IoFilterChain filters = session.getFilterChain();
            filters.addLast("codec", (IoFilter)new ProtocolCodecFilter(LdapServer.this.codecFactory));
        }

        public void sessionClosed(IoSession session) {
            LdapServer.this.registry.remove(session);
        }

        public void messageReceived(IoSession session, Object message) throws Exception {
            ExtendedRequestImpl req;
            if (message == SSLFilter.SESSION_SECURED) {
                req = new ExtendedRequestImpl(0);
                req.setOid("1.3.6.1.4.1.1466.20037");
                req.setPayload("SECURED".getBytes("ISO-8859-1"));
                message = req;
            } else if (message == SSLFilter.SESSION_UNSECURED) {
                req = new ExtendedRequestImpl(0);
                req.setOid("1.3.6.1.4.1.1466.20037");
                req.setPayload("UNSECURED".getBytes("ISO-8859-1"));
                message = req;
            }
            if (((Request)message).getControls().size() > 0 && message instanceof ResultResponseRequest) {
                req = (ResultResponseRequest)message;
                for (Control control1 : req.getControls().values()) {
                    MutableControl control = (MutableControl)control1;
                    if (!control.isCritical() || LdapServer.this.supportedControls.contains(control.getID())) continue;
                    ResultResponse resp = req.getResultResponse();
                    resp.getLdapResult().setErrorMessage("Unsupport critical control: " + control.getID());
                    resp.getLdapResult().setResultCode(ResultCodeEnum.UNAVAILABLE_CRITICAL_EXTENSION);
                    session.write((Object)resp);
                    return;
                }
            }
            super.messageReceived(session, message);
        }

        public void exceptionCaught(IoSession session, Throwable cause) {
            if (cause.getCause() instanceof ResponseCarryingMessageException) {
                ResponseCarryingMessageException rcme = (ResponseCarryingMessageException)cause.getCause();
                session.write((Object)rcme.getResponse());
                return;
            }
            SessionLog.warn((IoSession)session, (String)"Unexpected exception forcing session to close: sending disconnect notice to client.", (Throwable)cause);
            session.write((Object)NoticeOfDisconnect.PROTOCOLERROR);
            LdapServer.this.registry.remove(session);
            session.close();
        }
    }

    private static final class ProtocolCodecFactoryImpl
    implements ProtocolCodecFactory {
        final DirectoryService directoryService;

        public ProtocolCodecFactoryImpl(DirectoryService directoryService) {
            this.directoryService = directoryService;
        }

        public ProtocolEncoder getEncoder() {
            return new Asn1CodecEncoder((StatefulEncoder)new MessageEncoder());
        }

        public ProtocolDecoder getDecoder() {
            return new Asn1CodecDecoder((StatefulDecoder)new MessageDecoder(new BinaryAttributeDetector(){

                public boolean isBinary(String id) {
                    AttributeTypeRegistry attrRegistry = ProtocolCodecFactoryImpl.this.directoryService.getRegistries().getAttributeTypeRegistry();
                    try {
                        AttributeType type = attrRegistry.lookup(id);
                        return !type.getSyntax().isHumanReadable();
                    }
                    catch (NamingException e) {
                        return false;
                    }
                }
            }));
        }
    }
}

