/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.support.bind;

import java.util.Hashtable;
import javax.naming.ldap.LdapContext;
import javax.security.sasl.AuthorizeCallback;
import org.apache.directory.server.ldap.support.bind.AbstractSaslCallbackHandler;
import org.apache.directory.server.ldap.support.bind.GetBindDn;
import org.apache.mina.common.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CramMd5CallbackHandler
extends AbstractSaslCallbackHandler {
    private static final Logger log = LoggerFactory.getLogger(CramMd5CallbackHandler.class);
    private IoSession session;
    private Object message;
    private String bindDn;
    private String userPassword;

    public CramMd5CallbackHandler(IoSession session, Object message) {
        this.session = session;
        this.message = message;
    }

    protected String lookupPassword(String username, String realm) {
        Hashtable<String, Object> env = this.getEnvironment(this.session);
        LdapContext ctx = this.getContext(this.session, this.message, env);
        GetBindDn getDn = new GetBindDn(username);
        getDn.execute(ctx, null);
        this.bindDn = getDn.getBindDn();
        this.userPassword = getDn.getUserPassword();
        return this.userPassword;
    }

    protected void authorize(AuthorizeCallback authorizeCB) {
        if (log.isDebugEnabled()) {
            log.debug("Converted username " + this.getUsername() + " to DN " + this.bindDn + " with password " + this.userPassword);
        }
        this.session.setAttribute("java.naming.security.principal", (Object)this.bindDn);
        authorizeCB.setAuthorizedID(this.bindDn);
        authorizeCB.setAuthorized(true);
    }
}

