/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.support.bind;

import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.spi.InitialContextFactory;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.message.BindRequest;
import org.apache.directory.shared.ldap.message.LdapResult;
import org.apache.directory.shared.ldap.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.message.MutableControl;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.ExceptionUtils;
import org.apache.mina.common.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSaslCallbackHandler
implements CallbackHandler {
    private static final Logger log = LoggerFactory.getLogger(AbstractSaslCallbackHandler.class);
    private static final MutableControl[] EMPTY = new MutableControl[0];
    private String username;
    private String realm;

    protected String getUsername() {
        return this.username;
    }

    protected String getRealm() {
        return this.realm;
    }

    protected abstract String lookupPassword(String var1, String var2);

    protected abstract void authorize(AuthorizeCallback var1);

    @Override
    public void handle(Callback[] callbacks) {
        for (int i = 0; i < callbacks.length; ++i) {
            Callback callback = callbacks[i];
            if (log.isDebugEnabled()) {
                log.debug("Processing callback " + (i + 1) + " of " + callbacks.length + ":  " + callback.getClass().toString());
            }
            if (callback instanceof NameCallback) {
                NameCallback nameCB = (NameCallback)callback;
                log.debug("NameCallback default name:  {}", (Object)nameCB.getDefaultName());
                this.username = nameCB.getDefaultName();
                continue;
            }
            if (callback instanceof RealmCallback) {
                RealmCallback realmCB = (RealmCallback)callback;
                log.debug("RealmCallback default text:  {}", (Object)realmCB.getDefaultText());
                this.realm = realmCB.getDefaultText();
                continue;
            }
            if (callback instanceof PasswordCallback) {
                PasswordCallback passwordCB = (PasswordCallback)callback;
                String userPassword = this.lookupPassword(this.getUsername(), this.getRealm());
                if (userPassword == null) continue;
                passwordCB.setPassword(userPassword.toCharArray());
                continue;
            }
            if (!(callback instanceof AuthorizeCallback)) continue;
            AuthorizeCallback authorizeCB = (AuthorizeCallback)callback;
            log.debug("AuthorizeCallback authnID:  {}", (Object)authorizeCB.getAuthenticationID());
            log.debug("AuthorizeCallback authzID:  {}", (Object)authorizeCB.getAuthorizationID());
            log.debug("AuthorizeCallback authorizedID:  {}", (Object)authorizeCB.getAuthorizedID());
            log.debug("AuthorizeCallback isAuthorized:  {}", (Object)authorizeCB.isAuthorized());
            this.authorize(authorizeCB);
        }
    }

    protected LdapContext getContext(IoSession session, Object message, Hashtable env) {
        BindRequest request = (BindRequest)message;
        LdapResult result = request.getResultResponse().getLdapResult();
        LdapContext ctx = null;
        try {
            if (env.containsKey("server.use.factory.instance")) {
                InitialContextFactory factory = (InitialContextFactory)env.get("server.use.factory.instance");
                if (factory == null) {
                    throw new NullPointerException("server.use.factory.instance was set in env but was null");
                }
                ctx = (LdapContext)factory.getInitialContext(env);
            } else {
                MutableControl[] connCtls = request.getControls().values().toArray(EMPTY);
                ctx = new InitialLdapContext(env, (Control[])connCtls);
            }
        }
        catch (NamingException e) {
            ResultCodeEnum code;
            if (e instanceof LdapException) {
                code = ((LdapException)e).getResultCode();
                result.setResultCode(code);
            } else {
                code = ResultCodeEnum.getBestEstimate((Throwable)e, (MessageTypeEnum)request.getType());
                result.setResultCode(code);
            }
            String msg = "Bind failed: " + e.getMessage();
            if (log.isDebugEnabled()) {
                msg = msg + ":\n" + ExceptionUtils.getStackTrace((Throwable)e);
                msg = msg + "\n\nBindRequest = \n" + request.toString();
            }
            if (e.getResolvedName() != null && (code == ResultCodeEnum.NO_SUCH_OBJECT || code == ResultCodeEnum.ALIAS_PROBLEM || code == ResultCodeEnum.INVALID_DN_SYNTAX || code == ResultCodeEnum.ALIAS_DEREFERENCING_PROBLEM)) {
                result.setMatchedDn((LdapDN)e.getResolvedName());
            }
            result.setErrorMessage(msg);
            session.write((Object)request.getResultResponse());
            ctx = null;
        }
        return ctx;
    }

    protected Hashtable<String, Object> getEnvironment(IoSession session) {
        Hashtable<String, Object> env = new Hashtable<String, Object>();
        env.put("java.naming.provider.url", session.getAttribute("baseDn"));
        env.put("java.naming.factory.initial", "org.apache.directory.server.core.jndi.CoreContextFactory");
        env.put("java.naming.security.principal", "uid=admin,ou=system");
        env.put("java.naming.security.credentials", "secret");
        env.put("java.naming.security.authentication", "simple");
        return env;
    }
}

